/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.areas;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;

public class PlotArea
implements Runnable {
    private final TARDIS plugin;
    private final World world;

    public PlotArea(TARDIS plugin, World world) {
        this.plugin = plugin;
        this.world = world;
    }

    @Override
    public void run() {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("area_name", "Plots");
        where.put("world", this.world.getName());
        ResultSetAreas rsa = new ResultSetAreas(this.plugin, where, false, true);
        if (rsa.resultSet()) {
            return;
        }
        int size = this.plugin.getGeneratorConfig().getInt("plot.size");
        int max = 16 * size - 2;
        int y = this.world.getMinHeight() + 64;
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("area_name", "Plots");
        set.put("world", this.world.getName());
        set.put("minx", 6);
        set.put("minz", 6);
        set.put("maxx", max);
        set.put("maxz", max);
        set.put("y", y + 1);
        this.plugin.getQueryFactory().doInsert("areas", set);
        for (int x = 6; x <= max; ++x) {
            for (int z = 6; z <= max; ++z) {
                if ((x - 2) % 5 == 0 && (z - 2) % 5 == 0) {
                    this.world.getBlockAt(x, y, z).setType(Material.RESIN_BRICKS);
                    continue;
                }
                this.world.getBlockAt(x, y, z).setType(Material.STRIPPED_BIRCH_WOOD);
            }
        }
        HashMap<String, Object> setp = new HashMap<String, Object>();
        setp.put("uuid", TARDISConstants.UUID_ZERO.toString());
        setp.put("world", this.world.getName());
        setp.put("chunk_x", 0);
        setp.put("chunk_z", 0);
        setp.put("size", size);
        setp.put("name", "TARDIS Landing");
        this.plugin.getQueryFactory().doInsert("plots", setp);
        Block block = this.world.getBlockAt(5, y + 2, 5);
        if (Tag.SIGNS.isTagged((Keyed)block.getType())) {
            Sign sign = (Sign)block.getState();
            SignSide front = sign.getSide(Side.FRONT);
            front.line(0, (Component)Component.text((String)"TARDIS"));
            front.line(1, (Component)Component.text((String)"Landing Area"));
            front.line(3, (Component)Component.text((String)"X:0, Z:0"));
            SignSide back = sign.getSide(Side.BACK);
            back.line(0, (Component)Component.text((String)"TARDIS"));
            back.line(1, (Component)Component.text((String)"Landing Area"));
            back.line(3, (Component)Component.text((String)"X:0, Z:0"));
            sign.setWaxed(true);
            sign.update(true);
        }
    }
}

