/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import java.util.HashMap;
import java.util.Map;
import me.eccentric_nz.TARDIS.ARS.ARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARSJettison;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import org.bukkit.Chunk;

class TARDISARSProcessor {
    private final TARDIS plugin;
    private final int id;
    private final int limit;
    private String error = "ENERGY_NOT_ENOUGH";
    private HashMap<TARDISARSSlot, ARS> changed;
    private HashMap<TARDISARSJettison, ARS> jettison;

    public TARDISARSProcessor(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.limit = this.plugin.getConfig().getInt("growth.ars_limit");
    }

    public boolean compare3DArray(String[][][] start, String[][][] end) {
        boolean overlimit;
        this.changed = new HashMap();
        this.jettison = new HashMap();
        Chunk c = this.plugin.getLocationUtils().getTARDISChunk(this.id);
        for (int l = 0; l < 3; ++l) {
            for (int x = 0; x < 9; ++x) {
                block12: for (int z = 0; z < 9; ++z) {
                    if (start[l][x][z].equals(end[l][x][z])) continue;
                    if (end[l][x][z].equals("TNT")) {
                        TARDISARSJettison slot = new TARDISARSJettison();
                        slot.setChunk(c);
                        slot.setLevel(l);
                        slot.setX(x);
                        slot.setZ(z);
                        this.jettison.put(slot, TARDISARS.ARSFor(start[l][x][z]));
                        if (start[l][x][z].equals("SANDSTONE") && l == 2) {
                            TARDISARSJettison uslot = new TARDISARSJettison();
                            uslot.setChunk(c);
                            uslot.setLevel(3);
                            uslot.setX(x);
                            uslot.setZ(z);
                            this.jettison.put(uslot, TARDISARS.ANTIGRAVITY);
                        }
                        if (!start[l][x][z].equals("MOSSY_COBBLESTONE") || l != 0) continue;
                        TARDISARSJettison lslot = new TARDISARSJettison();
                        lslot.setChunk(c);
                        lslot.setLevel(-1);
                        lslot.setX(x);
                        lslot.setZ(z);
                        this.jettison.put(lslot, TARDISARS.GRAVITY);
                        continue;
                    }
                    switch (end[l][x][z]) {
                        case "PURPLE_TERRACOTTA": {
                            if (l == 0 && start[1][x][z].equals("PURPLE_TERRACOTTA")) {
                                this.plugin.getTrackerKeeper().getIsStackedStaircase().put(this.id, false);
                            } else if (l == 1 && start[0][x][z].equals("PURPLE_TERRACOTTA")) {
                                this.plugin.getTrackerKeeper().getIsStackedStaircase().put(this.id, true);
                            } else if (l == 1 && start[2][x][z].equals("PURPLE_TERRACOTTA")) {
                                this.plugin.getTrackerKeeper().getIsStackedStaircase().put(this.id, false);
                            } else if (l == 2 && start[1][x][z].equals("PURPLE_TERRACOTTA")) {
                                this.plugin.getTrackerKeeper().getIsStackedStaircase().put(this.id, true);
                            }
                            TARDISARSSlot slot = new TARDISARSSlot();
                            slot.setChunk(c);
                            slot.setY(l);
                            slot.setX(x);
                            slot.setZ(z);
                            this.changed.put(slot, TARDISARS.ARSFor(end[l][x][z]));
                            continue block12;
                        }
                        case "SANDSTONE": {
                            if (!(l == 0 || l == 1 && !end[l - 1][x][z].equals("SANDSTONE") || l == 2 && !end[l - 1][x][z].equals("SANDSTONE")) && (l != 2 || !end[l - 1][x][z].equals("SANDSTONE") || !end[l - 2][x][z].equals("SANDSTONE"))) continue block12;
                            TARDISARSSlot slot = new TARDISARSSlot();
                            slot.setChunk(c);
                            slot.setY(l);
                            slot.setX(x);
                            slot.setZ(z);
                            this.changed.put(slot, TARDISARS.ARSFor(end[l][x][z]));
                            continue block12;
                        }
                        case "MOSSY_COBBLESTONE": {
                            if (!(l == 2 || l == 1 && !end[l + 1][x][z].equals("MOSSY_COBBLESTONE") || l == 0 && !end[l + 1][x][z].equals("MOSSY_COBBLESTONE")) && (l != 0 || !end[l + 1][x][z].equals("MOSSY_COBBLESTONE") || !end[l + 2][x][z].equals("MOSSY_COBBLESTONE"))) continue block12;
                            TARDISARSSlot slot = new TARDISARSSlot();
                            slot.setChunk(c);
                            slot.setY(l - 1);
                            slot.setX(x);
                            slot.setZ(z);
                            this.changed.put(slot, TARDISARS.ARSFor(end[l][x][z]));
                            continue block12;
                        }
                        default: {
                            TARDISARSSlot slot = new TARDISARSSlot();
                            slot.setChunk(c);
                            slot.setY(l);
                            slot.setX(x);
                            slot.setZ(z);
                            this.changed.put(slot, TARDISARS.ARSFor(end[l][x][z]));
                        }
                    }
                }
            }
        }
        boolean bl = overlimit = this.limit > 0 && this.changed.size() > this.limit;
        if (overlimit) {
            this.error = "ARS_LIMIT";
        }
        return !this.jettison.isEmpty() || !this.changed.isEmpty() && !overlimit;
    }

    boolean checkCosts(HashMap<TARDISARSSlot, ARS> changed, HashMap<TARDISARSJettison, ARS> jettison) {
        if (!changed.isEmpty()) {
            int n;
            int totalcost = 0;
            int recoveredcost = 0;
            for (Map.Entry<TARDISARSJettison, ARS> entry : jettison.entrySet()) {
                if (entry.getValue() == null) continue;
                recoveredcost += Math.round((float)this.plugin.getArtronConfig().getInt("jettison") / 100.0f * (float)this.plugin.getRoomsConfig().getInt("rooms." + entry.getValue().toString() + ".cost"));
            }
            for (Map.Entry<Object, ARS> entry : changed.entrySet()) {
                int cost = this.plugin.getRoomsConfig().getInt("rooms." + entry.getValue().toString() + ".cost");
                totalcost += cost;
            }
            ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
            if (rs.fromID(this.id) && totalcost - recoveredcost > (n = rs.getArtronLevel())) {
                this.error = "ENERGY_NOT_ENOUGH";
                return false;
            }
        }
        return true;
    }

    public HashMap<TARDISARSSlot, ARS> getChanged() {
        return this.changed;
    }

    public HashMap<TARDISARSJettison, ARS> getJettison() {
        return this.jettison;
    }

    public String getError() {
        return this.error;
    }
}

