/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.utils;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.MonsterEquipment;
import me.eccentric_nz.tardisweepingangels.nms.FollowerPersister;
import me.eccentric_nz.tardisweepingangels.nms.TWAFollower;
import me.eccentric_nz.tardisweepingangels.utils.ResetMonster;
import org.bukkit.craftbukkit.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.EntitiesLoadEvent;
import org.bukkit.event.world.EntitiesUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.persistence.PersistentDataContainer;

public class MonsterLoadUnloadListener
implements Listener {
    private final TARDIS plugin;
    private final List<EntityType> justThese = List.of(EntityType.DROWNED, EntityType.PIGLIN_BRUTE, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.HUSK, EntityType.ZOMBIFIED_PIGLIN);

    public MonsterLoadUnloadListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onMonsterLoad(EntitiesLoadEvent event) {
        for (Entity e : event.getEntities()) {
            if (!this.justThese.contains(e.getType()) || !MonsterEquipment.isMonster(e)) continue;
            new ResetMonster(this.plugin, e).reset();
        }
    }

    @EventHandler
    public void onEntityUnload(EntitiesUnloadEvent event) {
        for (Entity e : event.getEntities()) {
            net.minecraft.world.entity.Entity entity;
            PersistentDataContainer pdc;
            if (e.getType() != EntityType.HUSK || !(pdc = e.getPersistentDataContainer()).has(TARDISWeepingAngels.OWNER_UUID, TARDISWeepingAngels.PersistentDataTypeUUID) || !((entity = ((CraftEntity)e).getHandle()) instanceof TWAFollower)) continue;
            TWAFollower follower = (TWAFollower)entity;
            new FollowerPersister(this.plugin).save(follower);
        }
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        for (Entity e : event.getWorld().getEntities()) {
            if (!this.justThese.contains(e.getType()) || !MonsterEquipment.isMonster(e)) continue;
            new ResetMonster(this.plugin, e).reset();
        }
    }
}

