/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.daleks;

import java.util.Collection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.monsters.daleks.DalekEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WaterChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class DalekRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int spawn_rate;

    public DalekRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = plugin.getMonstersConfig().getInt("spawn_rate.how_many");
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("daleks.worlds." + name) > 0) {
                int daleks = 0;
                Collection skeletons = w.getEntitiesByClass(Skeleton.class);
                for (Skeleton d : skeletons) {
                    PersistentDataContainer pdc = d.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.DALEK, PersistentDataType.INTEGER)) continue;
                    ++daleks;
                }
                if (daleks < this.plugin.getMonstersConfig().getInt("daleks.worlds." + name)) {
                    for (int i = 0; i < this.spawn_rate; ++i) {
                        this.spawnDalek((World)w);
                    }
                }
            }
        });
    }

    private void spawnDalek(World world) {
        int z;
        int y;
        Chunk c;
        int x;
        Location l;
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0 && WaterChecker.isNotWater(l = new Location(world, (double)(x = (c = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)]).getX() * 16 + TARDISConstants.RANDOM.nextInt(16)), (double)((y = world.getHighestBlockYAt(x, z = c.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16))) + 1), (double)z))) {
            Monster monster;
            EntityType dalek;
            boolean dav;
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            int chance = TARDISConstants.RANDOM.nextInt(100);
            boolean sec = chance < this.plugin.getMonstersConfig().getInt("daleks.dalek_sec_chance");
            boolean bl = dav = chance > 100 - this.plugin.getMonstersConfig().getInt("daleks.davros_chance");
            if (sec) {
                dalek = EntityType.ZOMBIFIED_PIGLIN;
                monster = Monster.DALEK_SEC;
            } else if (dav) {
                dalek = EntityType.ZOMBIFIED_PIGLIN;
                monster = Monster.DAVROS;
            } else {
                dalek = EntityType.SKELETON;
                monster = Monster.DALEK;
            }
            LivingEntity e = sec ? new MonsterSpawner().create(l, monster) : (LivingEntity)world.spawnEntity(l, dalek);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                if (sec) {
                    new Equipper(monster, e, false).setHelmetAndInvisibility();
                } else {
                    DalekEquipment.set(e, false);
                }
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)e, dalek, monster, l));
            }, 5L);
        }
    }
}

