/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisshop.ShopItem;
import me.eccentric_nz.tardisshop.ShopItemRecipe;
import me.eccentric_nz.tardisshop.TARDISShopItem;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;

public class TARDISShopItemSpawner {
    private final TARDIS plugin;

    public TARDISShopItemSpawner(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void setItem(Location location, TARDISShopItem what) {
        String toEnum = TARDISStringUtils.toEnumUppercase(what.item());
        try {
            ShopItem si = ShopItem.valueOf(toEnum);
            ItemStack is = ItemStack.of((Material)si.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            if (si.getRecipeType() == ShopItemRecipe.MODELLED || si.getRecipeType() == ShopItemRecipe.TWA) {
                im.setItemModel(si.getModel());
            }
            if (si.getFloats() != null) {
                CustomModelDataComponent component = im.getCustomModelDataComponent();
                component.setFloats(si.getFloats());
                im.setCustomModelDataComponent(component);
            }
            im.displayName((Component)Component.text((String)what.item()));
            im.getPersistentDataContainer().set(this.plugin.getShopSettings().getItemKey(), PersistentDataType.INTEGER, (Object)10001);
            is.setItemMeta(im);
            ItemDisplay display = (ItemDisplay)location.getWorld().spawnEntity(location.clone().add(0.5, 1.25, 0.5), EntityType.ITEM_DISPLAY);
            display.setItemStack(is);
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
            display.setBillboard(Display.Billboard.VERTICAL);
            display.setInvulnerable(true);
            TextDisplay text = (TextDisplay)location.getWorld().spawnEntity(location.clone().add(0.5, 1.65, 0.5), EntityType.TEXT_DISPLAY);
            text.setAlignment(TextDisplay.TextAlignment.CENTER);
            text.text(((TextComponent)((TextComponent)Component.text((String)what.item(), (TextColor)NamedTextColor.WHITE).append((Component)Component.newline())).append((Component)Component.text((String)"Cost:", (TextColor)NamedTextColor.RED))).append((Component)Component.text((String)String.format(" %.2f", what.cost()), (TextColor)NamedTextColor.WHITE)));
            text.setTransformation(new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, TARDISConstants.VECTOR_QUARTER, TARDISConstants.AXIS_ANGLE_ZERO));
            text.setBillboard(Display.Billboard.VERTICAL);
        }
        catch (IllegalArgumentException e) {
            this.plugin.debug("Illegal shop item [" + toEnum + "] :" + e.getMessage());
        }
    }
}

