/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisshop.TARDISShopItem;
import me.eccentric_nz.tardisshop.TARDISShopItemSpawner;
import me.eccentric_nz.tardisshop.database.ResultSetUpdateShop;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;

public class TARDISShopDisplayConverter
implements Runnable {
    private final TARDIS plugin;
    private int count = 0;

    public TARDISShopDisplayConverter(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        if (this.findAndReplace()) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.SHOP, "Converted " + this.count + " shop display items");
        } else {
            String message = this.count > 0 ? "Converting shop display items failed!" : "There were no shop display items to convert";
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.SHOP, message);
        }
    }

    public boolean findAndReplace() {
        ResultSetUpdateShop rs = new ResultSetUpdateShop(this.plugin);
        if (rs.getAll()) {
            for (TARDISShopItem si : rs.getShopItems()) {
                Chunk chunk = si.location().getChunk();
                while (!chunk.isLoaded()) {
                    chunk.load();
                }
                for (Entity e : si.location().getWorld().getNearbyEntities(si.location(), 1.0, 2.0, 1.0)) {
                    if (!(e instanceof Item) && !(e instanceof ArmorStand)) continue;
                    e.remove();
                }
                new TARDISShopItemSpawner(this.plugin).setItem(si.location(), si);
                ++this.count;
            }
            return true;
        }
        return false;
    }
}

