/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisregeneration;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.tardisregeneration.ElixirOfLife;
import me.eccentric_nz.tardisregeneration.Regenerator;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDismountEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;

public class ElixirOfLifeListener
implements Listener {
    private final TARDIS plugin;

    public ElixirOfLifeListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onDrinkElixir(PlayerItemConsumeEvent event) {
        ItemStack goblet = event.getItem();
        if (!ElixirOfLife.is(goblet)) {
            return;
        }
        new Regenerator().processPlayer(this.plugin, event.getPlayer());
    }

    @EventHandler
    public void onPlayerDamage(EntityDamageEvent event) {
        if (!this.plugin.getConfig().getBoolean("modules.regeneration")) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getHealth() - event.getDamage() > 0.0) {
                return;
            }
            if (!TARDISPermission.hasPermission(player, "tardis.regenerate")) {
                return;
            }
            if (this.plugin.getTrackerKeeper().getJohnSmith().containsKey(player.getUniqueId())) {
                return;
            }
            if (this.hasTotem(player)) {
                return;
            }
            new Regenerator().processPlayer(this.plugin, player);
        }
    }

    private boolean hasTotem(Player player) {
        ItemStack totem = player.getInventory().getItemInMainHand();
        return totem.getType() == Material.TOTEM_OF_UNDYING;
    }

    @EventHandler
    public void onPlayerDismount(EntityDismountEvent event) {
        Player player;
        Entity entity = event.getEntity();
        if (entity instanceof Player && (player = (Player)entity).hasPotionEffect(PotionEffectType.INVISIBILITY) && player.isInvulnerable()) {
            event.setCancelled(true);
        }
    }
}

