/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.feature;

import me.eccentric_nz.tardischunkgenerator.worldgen.feature.TARDISGrassData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;

public class VastialPlacer {
    private final RandomSource random = RandomSource.create();

    public void place(TARDISGrassData data, WorldGenLevel level, BlockPos blockPos) {
        boolean success = false;
        int y = blockPos.getY();
        int upperY = y + data.halfHeight();
        int lowerY = y - data.halfHeight() - 1;
        int var9 = data.radius().sample(this.random);
        BlockPos.MutableBlockPos var10 = new BlockPos.MutableBlockPos();
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-var9, 0, -var9), (BlockPos)blockPos.offset(var9, 0, var9))) {
            int var14;
            int var13 = pos.getX() - blockPos.getX();
            if (var13 * var13 + (var14 = pos.getZ() - blockPos.getZ()) * var14 > var9 * var9) continue;
            success |= this.placeColumn(data, level, upperY, lowerY, var10.set((Vec3i)pos));
        }
    }

    protected boolean placeColumn(TARDISGrassData data, WorldGenLevel level, int start, int limit, BlockPos.MutableBlockPos pos) {
        boolean success = false;
        for (int y = start; y > limit; --y) {
            pos.setY(y);
            if (!data.target().test((Object)level, (Object)pos)) continue;
            BlockState state = data.state().getState(level, this.random, (BlockPos)pos);
            level.setBlock((BlockPos)pos, state, 2);
            this.markAboveForPostProcessing(level, (BlockPos)pos);
            success = true;
        }
        return success;
    }

    protected void markAboveForPostProcessing(WorldGenLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos blockPos = pos.mutable();
        for (int y = 0; y < 2; ++y) {
            blockPos.move(Direction.UP);
            if (level.getBlockState((BlockPos)blockPos).isAir()) {
                return;
            }
            level.getChunk((BlockPos)blockPos).markPosForPostprocessing((BlockPos)blockPos);
        }
    }
}

