/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlotCount;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.tardischunkgenerator.worldgen.PlotGenerator;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class PlotListener
implements Listener {
    private final TARDIS plugin;
    private final int size;
    private final int claim_max;

    public PlotListener(TARDIS plugin) {
        this.plugin = plugin;
        this.size = Math.max(plugin.getGeneratorConfig().getInt("plot_size", 3), 2);
        this.claim_max = plugin.getGeneratorConfig().getInt("plot_size", 3);
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!TARDISPermission.hasPermission(player, "tardis.plot")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_PLOT");
            return;
        }
        if (!(player.getWorld().getGenerator() instanceof PlotGenerator)) {
            return;
        }
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getHand() != null && event.getHand().equals((Object)EquipmentSlot.HAND)) {
            if (event.getClickedBlock() == null) {
                return;
            }
            Block block = event.getClickedBlock().getRelative(BlockFace.UP);
            if (Tag.STANDING_SIGNS.isTagged((Keyed)block.getType())) {
                int x = block.getChunk().getX();
                int z = block.getChunk().getZ();
                Sign sign = (Sign)block.getState();
                if (sign.isWaxed()) {
                    if (ComponentUtils.stripColour(sign.getSide(Side.FRONT).line(1)).equals(player.getName()) && this.plugin.getTrackerKeeper().getPlotters().containsKey(player.getUniqueId())) {
                        String name = this.plugin.getTrackerKeeper().getPlotters().get(player.getUniqueId());
                        sign.getSide(Side.FRONT).line(0, (Component)Component.text((String)name));
                        sign.getSide(Side.BACK).line(0, (Component)Component.text((String)name));
                        sign.update();
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("name", name);
                        HashMap<String, Object> where = new HashMap<String, Object>();
                        where.put("uuid", player.getUniqueId().toString());
                        where.put("world", player.getWorld().getName());
                        String[] split = ComponentUtils.stripColour(sign.getSide(Side.FRONT).line(3)).split(", ");
                        String[] sx = split[0].split(":");
                        int dx = TARDISNumberParsers.parseInt(sx[1]);
                        String[] sz = split[1].split(":");
                        int dz = TARDISNumberParsers.parseInt(sz[1]);
                        where.put("chunk_x", dx);
                        where.put("chunk_z", dz);
                        this.plugin.getQueryFactory().doUpdate("plots", set, where);
                        this.plugin.getTrackerKeeper().getPlotters().remove(player.getUniqueId());
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLOT_NAMED");
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLOT_ALREADY_CLAIMED");
                    }
                    return;
                }
                ResultSetPlotCount rsp = new ResultSetPlotCount(this.plugin);
                if (rsp.fromUUID(player.getUniqueId().toString()) >= this.claim_max) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "");
                    return;
                }
                SignSide front = sign.getSide(Side.FRONT);
                front.line(0, (Component)Component.text((String)"/tplot name [name]"));
                front.line(1, (Component)Component.text((String)player.getName()));
                front.line(3, (Component)Component.text((String)("X:" + x + ", Z:" + z)));
                SignSide back = sign.getSide(Side.BACK);
                back.line(0, (Component)Component.text((String)"/tplot name [name]"));
                back.line(1, (Component)Component.text((String)player.getName()));
                back.line(3, (Component)Component.text((String)("X:" + x + ", Z:" + z)));
                sign.setWaxed(true);
                sign.update(true);
                Location min = block.getLocation();
                int add = 11 + (this.size - 1) * 16;
                Location max = min.clone().add((double)add, 0.0, (double)add);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("uuid", player.getUniqueId().toString());
                set.put("world", min.getWorld().getName());
                set.put("chunk_x", x);
                set.put("chunk_z", z);
                set.put("size", this.size);
                this.plugin.getQueryFactory().doInsert("plots", set);
                if (this.plugin.isWorldGuardOnServer()) {
                    this.plugin.getWorldGuardUtils().addPlotProtection(player.getUniqueId(), min, max);
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLOT_CLAIMED");
            }
        }
    }
}

