/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.custombiome;

import java.util.Locale;
import org.bukkit.Location;
import org.bukkit.World;
import org.terraform.biome.BiomeBank;
import org.terraform.biome.BiomeType;
import org.terraform.data.TerraformWorld;
import org.terraform.utils.GenUtils;
import org.terraform.utils.Vector2f;

public class TerraBiomeLocator {
    private final World world;
    private final Location current;
    private final String biome;

    public TerraBiomeLocator(World world, Location current, String biome) {
        this.world = world;
        this.current = current;
        this.biome = biome;
    }

    public Location execute() {
        try {
            TerraformWorld terraformWorld = TerraformWorld.get((World)this.world);
            BiomeBank biomeBank = BiomeBank.valueOf((String)this.biome.toUpperCase(Locale.ROOT));
            int x = this.current.getBlockX();
            int z = this.current.getBlockZ();
            Vector2f location = biomeBank.getType() == BiomeType.BEACH || biomeBank.getType() == BiomeType.RIVER ? GenUtils.locateHeightDependentBiome((TerraformWorld)terraformWorld, (BiomeBank)biomeBank, (Vector2f)new Vector2f((float)x, (float)z), (int)5000, (int)25) : GenUtils.locateHeightIndependentBiome((TerraformWorld)terraformWorld, (BiomeBank)biomeBank, (Vector2f)new Vector2f((float)x, (float)z));
            if (location != null) {
                return new Location(this.world, (double)location.x, (double)this.world.getHighestBlockYAt((int)location.x, (int)location.y), (double)location.y);
            }
            return null;
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }
}

