/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Waterlogged;

public class TARDISSponge {
    private static final int radius = 5;

    public static void removeWater(Block block) {
        for (int cx = -5; cx <= 5; ++cx) {
            for (int cy = -5; cy <= 5; ++cy) {
                for (int cz = -5; cz <= 5; ++cz) {
                    Block water = block.getRelative(cx, cy, cz);
                    if (!TARDISSponge.isWithinSphericalRadius(water, block, 5.0)) continue;
                    if (TARDISSponge.isRemovableWater(water.getType())) {
                        water.setType(Material.AIR);
                        continue;
                    }
                    BlockData data = water.getBlockData();
                    if (!(data instanceof Waterlogged)) continue;
                    Waterlogged waterlogged = (Waterlogged)data;
                    waterlogged.setWaterlogged(false);
                    water.setBlockData((BlockData)waterlogged);
                }
            }
        }
    }

    public static void addWater(Block block) {
        Block water;
        int cz;
        int cy;
        int cx = -6;
        for (cy = -6; cy <= 6; ++cy) {
            for (cz = -6; cz <= 6; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (TARDISSponge.isWithinSphericalRadius(water, block, 6.0) || !TARDISSponge.isRemovableWater(water.getType())) continue;
                TARDISSponge.setBlockToWater(water.getRelative(1, 0, 0), water);
            }
        }
        cx = 6;
        for (cy = -6; cy <= 6; ++cy) {
            for (cz = -6; cz <= 6; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (TARDISSponge.isWithinSphericalRadius(water, block, 6.0) || !TARDISSponge.isRemovableWater(water.getType())) continue;
                TARDISSponge.setBlockToWater(water.getRelative(-1, 0, 0), water);
            }
        }
        cy = -6;
        for (cx = -6; cx <= 6; ++cx) {
            for (cz = -6; cz <= 6; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (TARDISSponge.isWithinSphericalRadius(water, block, 6.0) || !TARDISSponge.isRemovableWater(water.getType())) continue;
                TARDISSponge.setBlockToWater(water.getRelative(0, 1, 0), water);
            }
        }
        cy = 6;
        for (cx = -6; cx <= 6; ++cx) {
            for (cz = -6; cz <= 6; ++cz) {
                water = block.getRelative(cx, cy, cz);
                if (TARDISSponge.isWithinSphericalRadius(water, block, 6.0) || !TARDISSponge.isRemovableWater(water.getType())) continue;
                TARDISSponge.setBlockToWater(water.getRelative(0, -1, 0), water);
            }
        }
        cz = -6;
        for (cx = -6; cx <= 6; ++cx) {
            for (cy = -6; cy <= 6; ++cy) {
                water = block.getRelative(cx, cy, cz);
                if (TARDISSponge.isWithinSphericalRadius(water, block, 6.0) || !TARDISSponge.isRemovableWater(water.getType())) continue;
                TARDISSponge.setBlockToWater(water.getRelative(0, 0, 1), water);
            }
        }
        cz = 6;
        for (cx = -6; cx <= 6; ++cx) {
            for (cy = -6; cy <= 6; ++cy) {
                water = block.getRelative(cx, cy, cz);
                if (TARDISSponge.isWithinSphericalRadius(water, block, 6.0) || !TARDISSponge.isRemovableWater(water.getType())) continue;
                TARDISSponge.setBlockToWater(water.getRelative(0, 0, -1), water);
            }
        }
    }

    private static boolean isRemovableWater(Material material) {
        return material == Material.WATER || material == Material.SEAGRASS || material == Material.TALL_SEAGRASS || material == Material.KELP_PLANT || material == Material.KELP;
    }

    private static boolean isWithinSphericalRadius(Location base, Location checked, double radius) {
        return base.getWorld() == checked.getWorld() && base.distanceSquared(checked) <= radius * radius;
    }

    private static boolean isWithinSphericalRadius(Block base, Block checked, double radius) {
        return TARDISSponge.isWithinSphericalRadius(base.getLocation(), checked.getLocation(), radius + 0.5);
    }

    private static void setBlockToWater(Block block, Block source) {
        if (block.getType().isAir()) {
            Levelled levelled;
            int sourceLevel;
            BlockData sourceData = source.getBlockData();
            int level = 0;
            if (sourceData instanceof Levelled && (sourceLevel = (levelled = (Levelled)sourceData).getLevel()) != 0) {
                level = Math.max(levelled.getLevel() + 1, 7);
            }
            Levelled data = (Levelled)Bukkit.createBlockData((Material)Material.WATER);
            data.setLevel(level);
            block.setBlockData((BlockData)data);
        }
    }
}

