/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.upgrades;

import java.util.ArrayList;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.SystemUpgrade;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISSystemTreeGUI
implements InventoryHolder {
    private final TARDIS plugin;
    private final SystemUpgrade sysData;
    private final Inventory inventory;

    public TARDISSystemTreeGUI(TARDIS plugin, SystemUpgrade sysData) {
        this.plugin = plugin;
        this.sysData = sysData;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS System Upgrades", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStacks());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStacks() {
        ItemStack[] stacks = new ItemStack[54];
        for (SystemTree g : SystemTree.values()) {
            if (g.getSlot() == -1) continue;
            ItemStack is = ItemStack.of((Material)g.getMaterial(), (int)1);
            ItemMeta itemMeta = is.getItemMeta();
            if (g.getBranch().equals("branch")) {
                itemMeta.displayName(Component.text((String)g.getName(), (TextColor)NamedTextColor.GOLD).decorate(TextDecoration.ITALIC));
            } else {
                itemMeta.displayName((Component)Component.text((String)g.getName()));
            }
            ArrayList<Component> lore = new ArrayList<Component>(g.getLore());
            int has = this.sysData.getUpgrades().get((Object)g).booleanValue();
            if (has == 0) {
                String cost = g.getBranch().equals("branch") ? this.plugin.getSystemUpgradesConfig().getString("branch") : this.plugin.getSystemUpgradesConfig().getString(g.getBranch() + "." + g.toString().toLowerCase(Locale.ROOT));
                lore.add(Component.text((String)("Cost: " + cost), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
            } else if (g != SystemTree.UPGRADE_TREE) {
                lore.add(Component.text((String)"Unlocked", (TextColor)NamedTextColor.GREEN).decorate(TextDecoration.ITALIC));
            } else {
                lore.add(Component.text((String)("Artron Level: " + this.sysData.getArtronLevel()), (TextColor)NamedTextColor.AQUA).decorate(TextDecoration.ITALIC));
            }
            itemMeta.lore(lore);
            itemMeta.setItemModel(has != 0 ? g.getUnlocked() : g.getLocked());
            is.setItemMeta(itemMeta);
            stacks[g.getSlot()] = is;
        }
        ItemStack ld = ItemStack.of((Material)SystemTree.LEFT_DOWN.getMaterial(), (int)1);
        ItemMeta eft = ld.getItemMeta();
        eft.displayName((Component)ComponentUtils.toWhite(""));
        eft.setItemModel(SystemTree.LEFT_DOWN.getLocked());
        ld.setItemMeta(eft);
        stacks[0] = ld;
        int[] horizontal = new int[]{1, 3, 5, 7};
        ItemStack his = ItemStack.of((Material)SystemTree.H_LINE.getMaterial(), (int)1);
        ItemMeta him = his.getItemMeta();
        him.displayName((Component)ComponentUtils.toWhite(""));
        him.setItemModel(SystemTree.H_LINE.getLocked());
        his.setItemMeta(him);
        for (int h : horizontal) {
            stacks[h] = his;
        }
        int[] nArray = new int[]{2, 6};
        ItemStack bd = ItemStack.of((Material)SystemTree.BOTH_DOWN.getMaterial(), (int)1);
        ItemMeta bdim = bd.getItemMeta();
        bdim.displayName((Component)ComponentUtils.toWhite(""));
        bdim.setItemModel(SystemTree.BOTH_DOWN.getLocked());
        bd.setItemMeta(bdim);
        for (int d : nArray) {
            stacks[d] = bd;
        }
        ItemStack rd = ItemStack.of((Material)SystemTree.RIGHT_DOWN.getMaterial(), (int)1);
        ItemMeta own = rd.getItemMeta();
        own.displayName((Component)ComponentUtils.toWhite(""));
        own.setItemModel(SystemTree.RIGHT_DOWN.getLocked());
        rd.setItemMeta(own);
        stacks[8] = rd;
        ItemStack is = ItemStack.of((Material)SystemTree.BLANK.getMaterial(), (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)ComponentUtils.toWhite(""));
        im.setItemModel(SystemTree.BLANK.getLocked());
        is.setItemMeta(im);
        stacks[10] = is;
        ItemStack vert = ItemStack.of((Material)SystemTree.VERTICAL.getMaterial(), (int)1);
        ItemMeta ical = vert.getItemMeta();
        ical.displayName((Component)ComponentUtils.toWhite(""));
        ical.setItemModel(SystemTree.VERTICAL.getLocked());
        vert.setItemMeta(ical);
        stacks[13] = vert;
        ItemStack close = ItemStack.of((Material)SystemTree.CLOSE.getMaterial(), (int)1);
        ItemMeta close_im = close.getItemMeta();
        close_im.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close_im.setItemModel(SystemTree.CLOSE.getLocked());
        close.setItemMeta(close_im);
        stacks[45] = close;
        return stacks;
    }
}

