/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel.save;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISAreaCheck;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.travel.save.TARDISSavesInventory;
import me.eccentric_nz.TARDIS.travel.save.TARDISSavesPlanetInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISSavesListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISSavesListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSaveTerminalClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            event.setCancelled(this.plugin.getTrackerKeeper().getArrangers().contains(event.getWhoClicked().getUniqueId()));
            return;
        }
        if (event.getInventory().getHolder(false) instanceof TARDISSavesInventory) {
            Player player = (Player)event.getWhoClicked();
            UUID uuid = player.getUniqueId();
            boolean allow = false;
            int occupiedTardisId = -1;
            int playerTardisId = -1;
            if (this.plugin.getTrackerKeeper().getJunkPlayers().containsKey(uuid)) {
                allow = true;
                playerTardisId = occupiedTardisId = this.plugin.getTrackerKeeper().getJunkPlayers().get(uuid).intValue();
            } else if (this.plugin.getTrackerKeeper().getSavesIds().containsKey(uuid)) {
                playerTardisId = this.plugin.getTrackerKeeper().getSavesIds().get(uuid);
                allow = true;
            }
            HashMap<String, Object> wheres = new HashMap<String, Object>();
            wheres.put("uuid", uuid.toString());
            ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
            if (rst.resultSet()) {
                occupiedTardisId = rst.getTardis_id();
                allow = true;
            }
            if (!allow) {
                event.setCancelled(true);
            } else {
                int slot = event.getRawSlot();
                if (this.plugin.getTrackerKeeper().getArrangers().contains(uuid)) {
                    if (slot >= 0 && slot < 45 || slot == 47) {
                        if (event.getClick().equals((Object)ClickType.SHIFT_LEFT) || event.getClick().equals((Object)ClickType.SHIFT_RIGHT)) {
                            this.plugin.debug("TARDISSavesListener");
                            event.setCancelled(true);
                            return;
                        }
                        if (slot == 47) {
                            ItemStack cursor = player.getItemOnCursor();
                            if (cursor.getType().isAir()) {
                                event.setCancelled(true);
                            } else {
                                ItemMeta cim = cursor.getItemMeta();
                                String save = ComponentUtils.stripColour(cim.displayName());
                                HashMap<String, Object> where = new HashMap<String, Object>();
                                where.put("tardis_id", occupiedTardisId);
                                where.put("dest_name", save);
                                this.plugin.getQueryFactory().doDelete("destinations", where);
                                player.setItemOnCursor(null);
                            }
                            event.setCancelled(true);
                        }
                    } else {
                        event.setCancelled(true);
                    }
                } else {
                    event.setCancelled(true);
                    if (slot >= 0 && slot < 45) {
                        ItemStack is;
                        Location exterior = null;
                        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, occupiedTardisId);
                        if (rsc.resultSet()) {
                            exterior = rsc.getCurrent().location();
                        }
                        if ((is = event.getView().getItem(slot)) != null) {
                            ItemMeta im = is.getItemMeta();
                            List lore = im.lore();
                            if (lore != null && ComponentUtils.stripColour((Component)lore.getFirst()).startsWith("TARDIS_")) {
                                this.close(player);
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NO_TARDIS");
                                return;
                            }
                            Location save_dest = this.getLocation(lore);
                            if (save_dest != null) {
                                int travel;
                                if (!this.plugin.getPluginRespect().getRespect(save_dest, new Parameters(player, Flag.getDefaultFlags()))) {
                                    this.close(player);
                                    return;
                                }
                                ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
                                if (!rs.fromID(occupiedTardisId)) {
                                    this.close(player);
                                    return;
                                }
                                int level = rs.getArtronLevel();
                                if (level < (travel = this.plugin.getArtronConfig().getInt("travel"))) {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                                    this.close(player);
                                    return;
                                }
                                TARDISAreaCheck tac = this.plugin.getTardisArea().isSaveInArea(save_dest);
                                if (tac.isInArea()) {
                                    HashMap<String, Object> wheresave = new HashMap<String, Object>();
                                    wheresave.put("world", ComponentUtils.stripColour((Component)lore.getFirst()));
                                    wheresave.put("x", ComponentUtils.stripColour((Component)lore.get(1)));
                                    wheresave.put("y", ComponentUtils.stripColour((Component)lore.get(2)));
                                    wheresave.put("z", ComponentUtils.stripColour((Component)lore.get(3)));
                                    ResultSetCurrentLocation rsz = new ResultSetCurrentLocation(this.plugin, wheresave);
                                    if (rsz.resultSet()) {
                                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "TARDIS_IN_SPOT", "/tardistravel area [name]", this.plugin);
                                        this.close(player);
                                        return;
                                    }
                                    String invisibility = tac.getArea().invisibility();
                                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                                    wheret.put("tardis_id", occupiedTardisId);
                                    ResultSetTardis resultSetTardis = new ResultSetTardis(this.plugin, wheret, "", false);
                                    if (resultSetTardis.resultSet()) {
                                        if (invisibility.equals("DENY") && resultSetTardis.getTardis().getPreset().equals((Object)ChameleonPreset.INVISIBLE)) {
                                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NO_INVISIBLE");
                                            return;
                                        }
                                        if (!invisibility.equals("ALLOW")) {
                                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_FORCE_PRESET", invisibility);
                                            HashMap<String, Object> wherei = new HashMap<String, Object>();
                                            wherei.put("tardis_id", occupiedTardisId);
                                            HashMap<String, Object> seti = new HashMap<String, Object>();
                                            seti.put("chameleon_preset", invisibility);
                                            seti.put("adapti_on", 0);
                                            this.plugin.getQueryFactory().doSyncUpdate("tardis", seti, wherei);
                                        }
                                    }
                                }
                                if (!save_dest.equals((Object)exterior) || this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(occupiedTardisId)) {
                                    String six;
                                    DamageUtility.run(this.plugin, DiskCircuit.MEMORY, occupiedTardisId, player);
                                    HashMap<String, Object> set = new HashMap<String, Object>();
                                    set.put("world", ComponentUtils.stripColour((Component)lore.getFirst()));
                                    set.put("x", TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(1))));
                                    set.put("y", TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(2))));
                                    set.put("z", TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(3))));
                                    int l_size = lore.size();
                                    if (l_size >= 5) {
                                        String four = ComponentUtils.stripColour((Component)lore.get(4));
                                        if (!four.isEmpty() && !four.equals("Current location")) {
                                            set.put("direction", four);
                                        }
                                        if (l_size > 5) {
                                            String five = ComponentUtils.stripColour((Component)lore.get(5));
                                            if (five.equals("true")) {
                                                set.put("submarine", 1);
                                            } else {
                                                set.put("submarine", 0);
                                            }
                                        }
                                    }
                                    if (l_size >= 7 && !(six = ComponentUtils.stripColour((Component)lore.get(6))).equals("Current location")) {
                                        HashMap<String, Object> sett = new HashMap<String, Object>();
                                        sett.put("chameleon_preset", six);
                                        sett.put("adapti_on", 0);
                                        HashMap<String, Object> wheret = new HashMap<String, Object>();
                                        wheret.put("tardis_id", occupiedTardisId);
                                        this.plugin.getQueryFactory().doSyncUpdate("tardis", sett, wheret);
                                    }
                                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                                    wheret.put("tardis_id", occupiedTardisId);
                                    this.plugin.getQueryFactory().doSyncUpdate("next", set, wheret);
                                    TravelType travelType = ComponentUtils.stripColour(im.displayName()).equals("Home") ? TravelType.HOME : TravelType.SAVE;
                                    this.plugin.getTrackerKeeper().getHasDestination().put(occupiedTardisId, new TravelCostAndType(travel, travelType));
                                    this.plugin.getTrackerKeeper().getRescue().remove(occupiedTardisId);
                                    this.close(player);
                                    this.plugin.getMessenger().sendJoined(player, "DEST_SET_TERMINAL", ComponentUtils.stripColour(im.displayName()), !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(occupiedTardisId));
                                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(occupiedTardisId)) {
                                        new TARDISLand(this.plugin, occupiedTardisId, player).exitVortex();
                                        this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, travelType, occupiedTardisId));
                                    }
                                } else if (!lore.contains(Component.text((String)"Current location", (TextColor)NamedTextColor.GOLD))) {
                                    lore.add(Component.text((String)"Current location", (TextColor)NamedTextColor.GOLD));
                                    im.lore(lore);
                                    is.setItemMeta(im);
                                }
                            } else {
                                this.close(player);
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DEST_NOT_VALID", ComponentUtils.stripColour(im.displayName()));
                            }
                        }
                    }
                    if (slot == 45) {
                        HashMap<String, Object> wherez = new HashMap<String, Object>();
                        wherez.put("tardis_id", occupiedTardisId);
                        wherez.put("uuid", uuid.toString());
                        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherez, "", false);
                        if (rs.resultSet()) {
                            this.plugin.getTrackerKeeper().getArrangers().add(uuid);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_ARRANGE");
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_OWNER");
                        }
                    }
                    if (slot == 53) {
                        int finalId = playerTardisId != -1 ? playerTardisId : occupiedTardisId;
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TARDISSavesPlanetInventory(this.plugin, finalId, player).getInventory()), 2L);
                    }
                }
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onSaveSignClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISSavesInventory)) {
            return;
        }
        Component inv_name = event.getView().title();
        boolean isPageTwo = inv_name.equals((Object)Component.text((String)"TARDIS saves 2", (TextColor)NamedTextColor.RED));
        UUID uuid = event.getPlayer().getUniqueId();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (rst.resultSet()) {
            int start;
            int id = rst.getTardis_id();
            ItemStack[] stack = event.getInventory().getContents();
            for (int i = start = isPageTwo ? 0 : 1; i < 45; ++i) {
                if (stack[i] == null) continue;
                ItemMeta im = stack[i].getItemMeta();
                String save = ComponentUtils.stripColour(im.displayName());
                HashMap<String, Object> set = new HashMap<String, Object>();
                int slot = isPageTwo ? 45 + i : i;
                set.put("slot", slot);
                set.put("icon", stack[i].getType().toString());
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                where.put("dest_name", save);
                this.plugin.getQueryFactory().doUpdate("destinations", set, where);
            }
        }
        if (this.plugin.getTrackerKeeper().getArrangers().contains(uuid)) {
            event.getPlayer().setItemOnCursor(ItemStack.of((Material)Material.AIR));
            this.plugin.getTrackerKeeper().getArrangers().remove(uuid);
        }
    }

    private Location getLocation(List<Component> lore) {
        if (lore == null) {
            return null;
        }
        World w = TARDISAliasResolver.getWorldFromAlias(ComponentUtils.stripColour(lore.getFirst()));
        if (w == null) {
            return null;
        }
        int x = TARDISNumberParsers.parseInt(ComponentUtils.stripColour(lore.get(1)));
        int y = TARDISNumberParsers.parseInt(ComponentUtils.stripColour(lore.get(2)));
        int z = TARDISNumberParsers.parseInt(ComponentUtils.stripColour(lore.get(3)));
        return new Location(w, (double)x, (double)y, (double)z);
    }
}

