/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.Check;
import me.eccentric_nz.TARDIS.travel.TARDISCaveFinder;
import me.eccentric_nz.TARDIS.travel.TARDISStructureLocation;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.generator.structure.Structure;
import org.bukkit.util.StructureSearchResult;

public class TARDISStructureTravel {
    public static final List<Structure> netherStructures = new ArrayList<Structure>();
    public static final List<Structure> overworldStructures = new ArrayList<Structure>();
    private final TARDIS plugin;

    public TARDISStructureTravel(TARDIS plugin) {
        this.plugin = plugin;
    }

    public TARDISStructureLocation getRandom(Player p, int id, String[] args) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (rsc.resultSet()) {
            Current current = rsc.getCurrent();
            World world = current.location().getWorld();
            World.Environment env = world.getEnvironment();
            Structure structure = null;
            if (args.length > 1) {
                structure = (Structure)RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).get(NamespacedKey.minecraft((String)args[1].toLowerCase(Locale.ROOT)));
                if (structure == null) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "VILLAGE_NO_STRUCTURE", args[1]);
                    return null;
                }
                String perm = RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE).getKey((Keyed)structure).getKey();
                if (!p.hasPermission("tardis.timetravel.structure." + perm)) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "NO_PERM_STRUCTURE", TARDISStringUtils.capitalise(perm));
                    return null;
                }
                if (!env.equals((Object)World.Environment.NETHER) && netherStructures.contains(structure)) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "VILLAGE_NO_SEARCH", args[1], (env.equals((Object)World.Environment.THE_END) ? "" : "a ") + TARDISStringUtils.capitalise(env.toString()));
                    return null;
                }
                if (!env.equals((Object)World.Environment.THE_END) && structure.equals(Structure.END_CITY)) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "VILLAGE_NO_SEARCH", args[1], "a " + TARDISStringUtils.capitalise(env.toString()));
                    return null;
                }
                if (!env.equals((Object)World.Environment.NORMAL) && overworldStructures.contains(structure)) {
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "VILLAGE_NO_SEARCH", args[1], (env.equals((Object)World.Environment.THE_END) ? "" : "a ") + TARDISStringUtils.capitalise(env.toString()));
                    return null;
                }
            }
            Location loc = null;
            switch (env) {
                case NETHER: {
                    StructureSearchResult netherResult;
                    if (args.length < 2) {
                        structure = netherStructures.get(ThreadLocalRandom.current().nextInt(netherStructures.size()));
                    }
                    loc = (netherResult = world.locateNearestStructure(current.location(), structure, 64, false)) != null ? netherResult.getLocation() : null;
                    break;
                }
                case THE_END: {
                    StructureSearchResult endResult = world.locateNearestStructure(current.location(), Structure.END_CITY, 64, false);
                    if (endResult == null) break;
                    loc = endResult.getLocation();
                    int highesty = TARDISStaticLocationGetters.getHighestYin3x3(world, current.location().getBlockX(), current.location().getBlockZ());
                    loc.setY((double)highesty);
                    break;
                }
                default: {
                    StructureSearchResult normalResult;
                    if (args.length < 2) {
                        structure = overworldStructures.get(ThreadLocalRandom.current().nextInt(overworldStructures.size()));
                    }
                    Location location = loc = (normalResult = world.locateNearestStructure(current.location(), structure, 64, false)) != null ? normalResult.getLocation() : null;
                    if (loc == null) break;
                    if (structure.equals(Structure.ANCIENT_CITY)) {
                        Check check = this.isThereRoom(world, loc.getBlockX(), loc.getBlockY(), loc.getBlockZ());
                        if (!check.isSafe()) break;
                        loc.setY((double)check.getY());
                        break;
                    }
                    loc.setY((double)world.getHighestBlockYAt(loc));
                }
            }
            if (loc == null) {
                return null;
            }
            Block b = loc.getBlock();
            boolean unsafe = true;
            while (unsafe) {
                boolean clear = true;
                for (BlockFace f : this.plugin.getGeneralKeeper().getSurrounding()) {
                    if (TARDISConstants.GOOD_MATERIALS.contains(b.getRelative(f).getType())) continue;
                    b = b.getRelative(BlockFace.UP);
                    clear = false;
                    break;
                }
                unsafe = !clear;
            }
            loc.setY((double)b.getY());
            return new TARDISStructureLocation(this.plugin, loc, structure);
        }
        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
        return null;
    }

    private Check isThereRoom(World w, int x, int starty, int z) {
        Check ret = new Check();
        ret.setSafe(false);
        for (int y = starty; y > w.getMinHeight() + 14; --y) {
            int yy;
            if (!w.getBlockAt(x, y, z).getType().isAir() || (yy = TARDISCaveFinder.getLowestAirBlock(w, x, y, z)) > y - 3 || w.getBlockAt(x - 1, yy - 1, z - 1).getType().equals((Object)Material.STONE) || !w.getBlockAt(x - 1, yy, z - 1).getType().isAir() || !w.getBlockAt(x - 1, yy, z).getType().isAir() || !w.getBlockAt(x - 1, yy, z + 1).getType().isAir() || !w.getBlockAt(x, yy, z - 1).getType().isAir() || !w.getBlockAt(x, yy, z + 1).getType().isAir() || !w.getBlockAt(x + 1, yy, z - 1).getType().isAir() || !w.getBlockAt(x + 1, yy, z).getType().isAir() || !w.getBlockAt(x + 1, yy, z + 1).getType().isAir()) continue;
            ret.setSafe(true);
            ret.setY(yy);
        }
        return ret;
    }

    static {
        netherStructures.add(Structure.BASTION_REMNANT);
        netherStructures.add(Structure.FORTRESS);
        netherStructures.add(Structure.NETHER_FOSSIL);
        netherStructures.add(Structure.RUINED_PORTAL_NETHER);
        overworldStructures.add(Structure.ANCIENT_CITY);
        overworldStructures.add(Structure.DESERT_PYRAMID);
        overworldStructures.add(Structure.IGLOO);
        overworldStructures.add(Structure.JUNGLE_PYRAMID);
        overworldStructures.add(Structure.MANSION);
        overworldStructures.add(Structure.MINESHAFT);
        overworldStructures.add(Structure.MINESHAFT_MESA);
        overworldStructures.add(Structure.MONUMENT);
        overworldStructures.add(Structure.OCEAN_RUIN_COLD);
        overworldStructures.add(Structure.OCEAN_RUIN_WARM);
        overworldStructures.add(Structure.PILLAGER_OUTPOST);
        overworldStructures.add(Structure.RUINED_PORTAL);
        overworldStructures.add(Structure.RUINED_PORTAL_DESERT);
        overworldStructures.add(Structure.RUINED_PORTAL_JUNGLE);
        overworldStructures.add(Structure.RUINED_PORTAL_SWAMP);
        overworldStructures.add(Structure.RUINED_PORTAL_MOUNTAIN);
        overworldStructures.add(Structure.RUINED_PORTAL_OCEAN);
        overworldStructures.add(Structure.SHIPWRECK);
        overworldStructures.add(Structure.SHIPWRECK_BEACHED);
        overworldStructures.add(Structure.STRONGHOLD);
        overworldStructures.add(Structure.SWAMP_HUT);
        overworldStructures.add(Structure.TRAIL_RUINS);
        overworldStructures.add(Structure.VILLAGE_DESERT);
        overworldStructures.add(Structure.VILLAGE_PLAINS);
        overworldStructures.add(Structure.VILLAGE_SAVANNA);
        overworldStructures.add(Structure.VILLAGE_SNOWY);
        overworldStructures.add(Structure.VILLAGE_TAIGA);
    }
}

