/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.sonic.TARDISSonicData;
import me.eccentric_nz.TARDIS.sonic.TARDISSonicDock;
import me.eccentric_nz.TARDIS.sonic.TARDISViewPlayerInventory;
import me.eccentric_nz.TARDIS.sonic.actions.TARDISSonicSound;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISSonicEntityListener
implements Listener {
    private final TARDIS plugin;

    public TARDISSonicEntityListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInteract(PlayerInteractEntityEvent event) {
        if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        long now = System.currentTimeMillis();
        ItemStack is = player.getInventory().getItemInMainHand();
        Entity ent = event.getRightClicked();
        if (is.getType().equals((Object)Material.BLAZE_ROD) && is.hasItemMeta()) {
            ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
            if (ComponentUtils.endsWith(im.displayName(), "Sonic Screwdriver")) {
                List lore = im.lore();
                if (ent instanceof Player) {
                    Player scanned = (Player)ent;
                    TARDISSonicSound.playSonicSound(this.plugin, player, now, 3050L, "sonic_screwdriver");
                    if (TARDISPermission.hasPermission(player, "tardis.sonic.admin") && lore != null && lore.contains(Component.text((String)"Admin Upgrade")) && player.isSneaking()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_INV");
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TARDISViewPlayerInventory(this.plugin, scanned).getInventory()), 40L);
                    } else if (TARDISPermission.hasPermission(player, "tardis.sonic.bio") && lore != null && lore.contains(Component.text((String)"Bio-scanner Upgrade"))) {
                        new TARDISSonicData().saveOrUpdate(this.plugin, scanned.getUniqueId().toString(), 1, is, player);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_PLAYER");
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            double mh = scanned.getAttribute(Attribute.MAX_HEALTH).getValue();
                            double health = scanned.getHealth() / mh * scanned.getHealthScale();
                            float hunger = (float)scanned.getFoodLevel() / 20.0f * 100.0f;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_NAME", scanned.getName());
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_AGE", this.convertTicksToTime(scanned.getTicksLived()));
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_HEALTH", String.format("%f", health));
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SONIC_HUNGER", String.format("%.2f", Float.valueOf(hunger)));
                        }, 40L);
                    }
                } else if (ent instanceof ItemFrame) {
                    ItemFrame frame = (ItemFrame)ent;
                    int id = this.isDock(frame);
                    if (id == -1) {
                        return;
                    }
                    new TARDISSonicDock(this.plugin).dock(id, frame, player, is);
                }
            }
        } else if (ent instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)ent;
            if (is.getType() == Material.AIR) {
                int id = this.isDock(frame);
                if (id == -1) {
                    return;
                }
                new TARDISSonicDock(this.plugin).undock(frame, player);
            }
        }
    }

    private int isDock(ItemFrame frame) {
        ItemStack dock = frame.getItem();
        if (dock.getType() != Material.FLOWER_POT || !dock.hasItemMeta()) {
            return -1;
        }
        ItemMeta im = dock.getItemMeta();
        if (!im.hasItemModel() || !im.getItemModel().getKey().contains("sonic_dock")) {
            return -1;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("type", 48);
        where.put("location", frame.getLocation().toString());
        ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
        return rsc.resultSet() ? rsc.getTardis_id() : -1;
    }

    private String convertTicksToTime(int time) {
        int seconds = time / 20;
        int h = seconds / 3600;
        int remainder = seconds - h * 3600;
        int m = remainder / 60;
        int s = remainder - m * 60;
        String gh = h > 1 || h == 0 ? " hours " : " hour ";
        String gm = m > 1 || m == 0 ? " minutes " : " minute ";
        String gs = s > 1 || s == 0 ? " seconds" : " second";
        return h + gh + m + gm + s + gs;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInventoryViewClick(InventoryClickEvent event) {
        if (event.getInventory().getHolder() instanceof TARDISViewPlayerInventory) {
            event.setCancelled(true);
        }
    }
}

