/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import io.papermc.paper.dialog.DialogResponseView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.TARDISBeaconToggler;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.preferences.TARDISBuildCommand;
import me.eccentric_nz.TARDIS.commands.preferences.TARDISJunkPreference;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.FlightMode;
import me.eccentric_nz.TARDIS.enumeration.Hum;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.forcefield.TARDISForceField;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PreferencesProcessor {
    private final TARDIS plugin;
    private final Player player;
    private final List<Material> keys = new ArrayList<Material>();

    public PreferencesProcessor(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        plugin.getBlocksConfig().getStringList("keys").forEach(m -> {
            try {
                this.keys.add(Material.valueOf((String)m));
            }
            catch (IllegalArgumentException e) {
                plugin.debug("Illegal Key value!");
            }
        });
    }

    public void process(DialogResponseView response) {
        String raw = response.payload().string();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", this.player.getUniqueId().toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        rs.resultSet();
        Tardis tardis = rs.getTardis();
        HashMap<String, Object> set = new HashMap<String, Object>();
        block27: for (String part : raw.substring(1, raw.length() - 1).split(",")) {
            String[] colon;
            if (part.startsWith("id") || !part.contains(":") || (colon = part.split(":")).length <= 1) continue;
            switch (colon[0]) {
                case "beacon_on": {
                    ResultSetTardisID rsi = new ResultSetTardisID(this.plugin);
                    if (!rsi.fromUUID(this.player.getUniqueId().toString())) continue block27;
                    new TARDISBeaconToggler(this.plugin).flickSwitch(this.player.getUniqueId(), rsi.getTardisId(), colon[1].equals("1b"));
                    set.put("beacon_on", colon[1].equals("1b") ? 1 : 0);
                    continue block27;
                }
                case "build": {
                    if (!this.plugin.isWorldGuardOnServer() || !this.plugin.getConfig().getBoolean("allow.wg_flag_set")) continue block27;
                    String onoff = colon[1].equals("1b") ? "on" : "off";
                    new TARDISBuildCommand(this.plugin).toggleCompanionBuilding(this.player, new String[]{"", onoff});
                    continue block27;
                }
                case "flight": {
                    FlightMode flightMode = FlightMode.valueOf(StringUtils.strip((String)colon[1], (String)"\""));
                    set.put("flying_mode", flightMode.getMode());
                    continue block27;
                }
                case "forcefield": {
                    if (!TARDISPermission.hasPermission(this.player, "tardis.forcefield")) {
                        return;
                    }
                    if (colon[1].equals("1b") && !this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(this.player.getUniqueId())) {
                        ResultSetArtronLevel rsal = new ResultSetArtronLevel(this.plugin, this.player.getUniqueId().toString());
                        if (rsal.resultset()) {
                            if (rsal.getArtronLevel() <= this.plugin.getArtronConfig().getInt("standby")) {
                                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_LOW");
                                continue block27;
                            }
                            if (!TARDISForceField.addToTracker(this.player)) continue block27;
                            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "PREF_WAS_ON", "The TARDIS force field");
                            continue block27;
                        }
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_LEVEL");
                        continue block27;
                    }
                    if (!colon[1].equals("0b") || !this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(this.player.getUniqueId())) continue block27;
                    this.plugin.getTrackerKeeper().getActiveForceFields().remove(this.player.getUniqueId());
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "PREF_WAS_OFF", "The TARDIS force field");
                    continue block27;
                }
                case "junk_mode": {
                    if ((!tardis.getPreset().equals((Object)ChameleonPreset.JUNK_MODE) || !colon[1].equals("0b")) && (tardis.getPreset().equals((Object)ChameleonPreset.JUNK_MODE) || !colon[1].equals("1b"))) continue block27;
                    new TARDISJunkPreference(this.plugin).toggle(this.player, colon[1].equals("1b") ? "off" : "on");
                    continue block27;
                }
                case "hads_type": 
                case "eps_message": {
                    set.put(colon[0], StringUtils.strip((String)colon[1], (String)"\""));
                    continue block27;
                }
                case "hum": {
                    Hum go = Hum.valueOf(StringUtils.strip((String)colon[1], (String)"\""));
                    String hum_set = go.equals((Object)Hum.RANDOM) ? "" : go.toString().toLowerCase(Locale.ROOT);
                    set.put("hum", hum_set);
                    continue block27;
                }
                case "isomorphic": {
                    int iso;
                    int n = iso = colon[1].equals("0b") ? 0 : 1;
                    if (tardis.isIsomorphicOn() && iso == 1 || !tardis.isIsomorphicOn() && iso == 0) continue block27;
                    HashMap<String, Object> seti = new HashMap<String, Object>();
                    seti.put("iso_on", iso);
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", tardis.getTardisId());
                    this.plugin.getQueryFactory().doUpdate("tardis", seti, wheret);
                    continue block27;
                }
                case "key": {
                    Material go;
                    String setMaterial = StringUtils.strip((String)colon[1], (String)"\"").toUpperCase(Locale.ROOT);
                    try {
                        go = Material.valueOf((String)setMaterial);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
                        return;
                    }
                    if (go.isBlock()) {
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "KEY_NO_BLOCK");
                        return;
                    }
                    if (this.plugin.getConfig().getBoolean("travel.give_key") && !this.plugin.getConfig().getBoolean("allow.all_blocks") && !this.keys.contains(go)) {
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
                        return;
                    }
                    String field = "sqlite".equals(this.plugin.getConfig().getString("storage.database")) ? "key" : "key_item";
                    set.put(field, setMaterial);
                    continue block27;
                }
                case "lock_containers": {
                    if (!this.plugin.isWorldGuardOnServer() || !this.plugin.getUtils().inTARDISWorld(this.player)) continue block27;
                    if (colon[1].equals("1b")) {
                        this.plugin.getWorldGuardUtils().lockContainers(this.player.getWorld(), this.player.getName());
                        continue block27;
                    }
                    this.plugin.getWorldGuardUtils().unlockContainers(this.player.getWorld(), this.player.getName());
                    continue block27;
                }
                default: {
                    set.put(colon[0], colon[1].equals("1b") ? 1 : 0);
                }
            }
        }
        if (!set.isEmpty()) {
            HashMap<String, Object> whereP = new HashMap<String, Object>();
            whereP.put("uuid", this.player.getUniqueId().toString());
            this.plugin.getQueryFactory().doUpdate("player_prefs", set, whereP);
            this.plugin.getMessenger().message((CommandSender)this.player, TardisModule.TARDIS, "Preferences saved.");
        }
    }
}

