/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.particles;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIParticle;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.particles.ParticleColour;
import me.eccentric_nz.TARDIS.particles.ParticleEffect;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISParticleInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final String uuid;
    private final Inventory inventory;

    public TARDISParticleInventory(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Particle Preferences", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ParticleData data;
        ItemStack[] stacks = new ItemStack[54];
        ResultSetParticlePrefs rs = new ResultSetParticlePrefs(this.plugin);
        if (rs.fromUUID(this.uuid)) {
            data = rs.getData();
        } else {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", this.uuid);
            this.plugin.getQueryFactory().doSyncInsert("particle_prefs", set);
            data = new ParticleData(ParticleEffect.ASH, ParticleShape.RANDOM, 16, 0.0, "WHITE", "STONE", false);
        }
        ItemStack shape = ItemStack.of((Material)GUIParticle.SHAPE_INFO.material(), (int)1);
        ItemMeta sim = shape.getItemMeta();
        sim.displayName((Component)Component.text((String)"Effect Shape"));
        sim.lore(List.of(Component.text((String)"Choose a shape"), Component.text((String)"from the options"), Component.text((String)"on the right.")));
        shape.setItemMeta(sim);
        stacks[GUIParticle.SHAPE_INFO.slot()] = shape;
        int i = 1;
        for (ParticleShape ps : ParticleShape.values()) {
            Material sm = data.getShape() == ps ? Material.LAPIS_ORE : GUIParticle.SHAPE.material();
            ItemStack pshape = ItemStack.of((Material)sm, (int)1);
            ItemMeta me = pshape.getItemMeta();
            me.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(ps.toString())));
            pshape.setItemMeta(me);
            stacks[i] = pshape;
            ++i;
        }
        ItemStack effect = ItemStack.of((Material)GUIParticle.EFFECT_INFO.material(), (int)1);
        ItemMeta eim = effect.getItemMeta();
        eim.displayName((Component)Component.text((String)"Effect Particle"));
        eim.lore(List.of(Component.text((String)"Choose a particle"), Component.text((String)"from the options"), Component.text((String)"on the right.")));
        effect.setItemMeta(eim);
        stacks[GUIParticle.EFFECT_INFO.slot()] = effect;
        i = 10;
        for (ParticleEffect pe : ParticleEffect.values()) {
            if (pe == ParticleEffect.LEAVES) continue;
            Material pm = data.getEffect() == pe ? Material.REDSTONE_ORE : GUIParticle.EFFECT.material();
            ItemStack peffect = ItemStack.of((Material)pm, (int)1);
            ItemMeta pim = peffect.getItemMeta();
            pim.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(pe.toString())));
            peffect.setItemMeta(pim);
            stacks[i] = peffect;
            if (i % 9 == 7) {
                i += 3;
                continue;
            }
            ++i;
        }
        Material lm = data.getEffect() == ParticleEffect.LEAVES ? Material.REDSTONE_ORE : GUIParticle.EFFECT.material();
        ItemStack leaves = ItemStack.of((Material)lm, (int)1);
        ItemMeta lim = leaves.getItemMeta();
        lim.displayName((Component)Component.text((String)"Leaves"));
        leaves.setItemMeta(lim);
        stacks[27] = leaves;
        ItemStack colour_info = ItemStack.of((Material)GUIParticle.COLOUR_INFO.material(), (int)1);
        ItemMeta ciim = colour_info.getItemMeta();
        ciim.displayName((Component)Component.text((String)"Effect Colour"));
        ciim.lore(List.of(Component.text((String)"Only affects DUST"), Component.text((String)"and EFFECT particles."), Component.text((String)"Click below to cycle through"), Component.text((String)"the 16 Minecraft colours.")));
        colour_info.setItemMeta(ciim);
        stacks[GUIParticle.COLOUR_INFO.slot()] = colour_info;
        ItemStack colour = ItemStack.of((Material)GUIParticle.COLOUR.material(), (int)1);
        ItemMeta cim = colour.getItemMeta();
        cim.displayName((Component)Component.text((String)"Particle Colour"));
        NamedTextColor chatColor = ParticleColour.fromColor(data.getColour());
        String col = ParticleColour.toString(chatColor);
        cim.lore(List.of(Component.text((String)col, (TextColor)chatColor)));
        colour.setItemMeta(cim);
        stacks[GUIParticle.COLOUR.slot()] = colour;
        ItemStack block_info = ItemStack.of((Material)GUIParticle.BLOCK_INFO.material(), (int)1);
        ItemMeta blim = block_info.getItemMeta();
        blim.displayName((Component)Component.text((String)"Effect Block"));
        blim.lore(List.of(Component.text((String)"Only affects BLOCK particles."), Component.text((String)"Click below to cycle"), Component.text((String)"through different blocks.")));
        block_info.setItemMeta(blim);
        stacks[GUIParticle.BLOCK_INFO.slot()] = block_info;
        ItemStack block = ItemStack.of((Material)GUIParticle.BLOCK.material(), (int)1);
        ItemMeta bim = block.getItemMeta();
        bim.displayName((Component)Component.text((String)"Block Type"));
        bim.lore(List.of(Component.text((String)data.getBlockData().getMaterial().toString())));
        block.setItemMeta(bim);
        stacks[GUIParticle.BLOCK.slot()] = block;
        ItemStack toggle = ItemStack.of((Material)GUIParticle.TOGGLE.material(), (int)1);
        ItemMeta tim = toggle.getItemMeta();
        tim.displayName((Component)Component.text((String)"Particles Enabled"));
        tim.lore(List.of(Component.text((String)(data.isOn() ? "ON" : "OFF"))));
        CustomModelDataComponent tcomponent = tim.getCustomModelDataComponent();
        tcomponent.setFloats(data.isOn() ? SwitchVariant.BUTTON_TOGGLE_ON.getFloats() : SwitchVariant.BUTTON_TOGGLE_OFF.getFloats());
        tim.setCustomModelDataComponent(tcomponent);
        toggle.setItemMeta(tim);
        stacks[GUIParticle.TOGGLE.slot()] = toggle;
        ItemStack test = ItemStack.of((Material)GUIParticle.TEST.material(), (int)1);
        ItemMeta xim = test.getItemMeta();
        xim.displayName((Component)Component.text((String)"Test"));
        xim.lore(List.of(Component.text((String)"Display particles"), Component.text((String)"around your TARDIS"), Component.text((String)"with the current settings.")));
        test.setItemMeta(xim);
        stacks[GUIParticle.TEST.slot()] = test;
        ItemStack density = ItemStack.of((Material)GUIParticle.DENSITY.material(), (int)1);
        ItemMeta dim = density.getItemMeta();
        dim.displayName((Component)Component.text((String)"Particle Density"));
        dim.lore(List.of(Component.text((int)data.getDensity(), (TextColor)NamedTextColor.AQUA), Component.text((String)"Has no effect"), Component.text((String)"on some shapes."), Component.text((String)"Range: 8 - 32.")));
        density.setItemMeta(dim);
        stacks[GUIParticle.DENSITY.slot()] = density;
        ItemStack speed = ItemStack.of((Material)GUIParticle.SPEED.material(), (int)1);
        ItemMeta spim = speed.getItemMeta();
        spim.displayName((Component)Component.text((String)"Particle Speed"));
        spim.lore(List.of(Component.text((String)String.format("%.0f", data.getSpeed() * 10.0), (TextColor)NamedTextColor.AQUA), Component.text((String)"Range: 0 - 10.")));
        speed.setItemMeta(spim);
        stacks[GUIParticle.SPEED.slot()] = speed;
        ItemStack minus = ItemStack.of((Material)GUIParticle.MINUS.material(), (int)1);
        ItemMeta mim = minus.getItemMeta();
        mim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_LESS", "Less")));
        minus.setItemMeta(mim);
        stacks[45] = minus;
        stacks[49] = minus;
        ItemStack plus = ItemStack.of((Material)GUIParticle.PLUS.material(), (int)1);
        ItemMeta pim = plus.getItemMeta();
        pim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_MORE", "More")));
        plus.setItemMeta(pim);
        stacks[47] = plus;
        stacks[51] = plus;
        ItemStack close = ItemStack.of((Material)GUIParticle.CLOSE.material(), (int)1);
        ItemMeta clim = close.getItemMeta();
        clim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(clim);
        stacks[GUIParticle.CLOSE.slot()] = close;
        return stacks;
    }
}

