/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mobfarming;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.mobfarming.HappyGhastUtils;
import me.eccentric_nz.TARDIS.move.TARDISDoorListener;
import me.eccentric_nz.TARDIS.travel.TARDISDoorLocation;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.HappyGhast;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerUnleashEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class TARDISLeashListener
implements Listener {
    private final TARDIS plugin;

    public TARDISLeashListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onLeashCut(PlayerUnleashEntityEvent event) {
        String name;
        if (!this.plugin.getUtils().inTARDISWorld(event.getPlayer())) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof Slime)) {
            return;
        }
        Slime slime = (Slime)entity;
        if (slime.hasAI()) {
            return;
        }
        if (slime.getPassengers().isEmpty()) {
            return;
        }
        if (!(slime.getPassengers().getFirst() instanceof ItemDisplay)) {
            return;
        }
        PersistentDataContainer pdc = slime.getPersistentDataContainer();
        if (!pdc.has(HappyGhastUtils.SLOT, PersistentDataType.INTEGER) || !pdc.has(HappyGhastUtils.ID, PersistentDataType.INTEGER)) {
            return;
        }
        event.setDropLeash(false);
        HappyGhastUtils.setSlotUnoccupied(this.plugin, (Integer)pdc.get(HappyGhastUtils.SLOT, PersistentDataType.INTEGER), (Integer)pdc.get(HappyGhastUtils.ID, PersistentDataType.INTEGER));
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", event.getPlayer().getUniqueId().toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
        if (!rst.resultSet()) {
            event.setCancelled(true);
        }
        int id = rst.getTardis_id();
        TARDISDoorLocation dl = TARDISDoorListener.getDoor(0, id);
        Location l = dl.getL();
        switch (dl.getD()) {
            case NORTH: {
                l.setZ(l.getZ() + 4.5);
                l.setYaw(0.0f);
                break;
            }
            case WEST: {
                l.setX(l.getX() + 4.5);
                l.setYaw(270.0f);
                break;
            }
            case SOUTH: {
                l.setZ(l.getZ() - 4.5);
                l.setYaw(180.0f);
                break;
            }
            default: {
                l.setX(l.getX() - 4.5);
                l.setYaw(90.0f);
            }
        }
        HappyGhast skies = (HappyGhast)l.getWorld().spawnEntity(l, EntityType.HAPPY_GHAST);
        skies.setAge(((Integer)pdc.get(HappyGhastUtils.AGE, PersistentDataType.INTEGER)).intValue());
        if (((Boolean)pdc.get(HappyGhastUtils.BABY, PersistentDataType.BOOLEAN)).booleanValue()) {
            skies.setBaby();
        }
        if (pdc.has(HappyGhastUtils.HARNESS)) {
            String material = (String)pdc.get(HappyGhastUtils.HARNESS, PersistentDataType.STRING);
            ItemStack harness = ItemStack.of((Material)Material.valueOf((String)material));
            skies.getEquipment().setItem(EquipmentSlot.BODY, harness);
        }
        skies.setHealth(((Double)pdc.get(HappyGhastUtils.HEALTH, PersistentDataType.DOUBLE)).doubleValue());
        if (pdc.has(HappyGhastUtils.NAME) && (name = (String)pdc.get(HappyGhastUtils.NAME, PersistentDataType.STRING)) != null && !name.isEmpty()) {
            skies.customName((Component)Component.text((String)name));
        }
        for (Entity p : slime.getPassengers()) {
            slime.removePassenger(p);
            p.remove();
        }
        slime.remove();
    }
}

