/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.CustomPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISCustomPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISStainedGlassLookup;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;

public class TARDISMakePresetListener
implements Listener {
    private final TARDIS plugin;
    private final int[] orderx;
    private final int[] orderz;
    private final String GLASS = TARDISConstants.GLASS.getAsString();

    public TARDISMakePresetListener(TARDIS plugin) {
        this.plugin = plugin;
        this.orderx = new int[]{0, 1, 2, 2, 2, 1, 0, 0, 1, -1};
        this.orderz = new int[]{0, 0, 0, 1, 2, 2, 2, 1, 1, 1};
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAreaInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Block block = event.getClickedBlock();
        if (block != null && this.plugin.getTrackerKeeper().getPreset().containsKey(uuid)) {
            String name = this.plugin.getTrackerKeeper().getPreset().get(uuid);
            JsonArray blueprint = new JsonArray();
            JsonArray stained = new JsonArray();
            JsonArray glass = new JsonArray();
            Location block_loc = block.getLocation();
            World w = block_loc.getWorld();
            int fx = block_loc.getBlockX();
            int fy = block_loc.getBlockY();
            int fz = block_loc.getBlockZ();
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PRESET_SCAN");
            for (int c = 0; c < 10; ++c) {
                JsonArray b = new JsonArray();
                JsonArray s = new JsonArray();
                JsonArray g = new JsonArray();
                for (int y = fy; y < fy + 4; ++y) {
                    Block at = w.getBlockAt(fx + this.orderx[c], y, fz + this.orderz[c]);
                    Material material = at.getType();
                    BlockData data = at.getBlockData();
                    String dataStr = data.getAsString();
                    b.add(dataStr);
                    if (TARDISMaterials.not_glass.contains(material)) {
                        s.add(dataStr);
                        g.add(dataStr);
                        continue;
                    }
                    Material colour = TARDISStainedGlassLookup.stainedGlassFromMaterial(w, material);
                    s.add(colour.createBlockData().getAsString());
                    g.add(this.GLASS);
                }
                blueprint.add((JsonElement)b);
                stained.add((JsonElement)s);
                glass.add((JsonElement)g);
            }
            JsonObject custom = new JsonObject();
            custom.add("blueprint", (JsonElement)blueprint);
            custom.add("stained", (JsonElement)stained);
            custom.add("glass", (JsonElement)glass);
            JsonArray sign = new JsonArray();
            sign.add(" ");
            sign.add(" ");
            custom.add("sign", (JsonElement)sign);
            custom.addProperty("icon", "ENDER_CHEST");
            this.plugin.getTrackerKeeper().getPreset().remove(uuid);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PRESET_DONE", "custom_presets.json");
            File file = new File(String.valueOf(TARDIS.plugin.getDataFolder()) + File.separator + "custom_presets.json");
            try (FileReader reader = new FileReader(file);){
                JsonObject root = JsonParser.parseReader((JsonReader)new JsonReader((Reader)reader)).getAsJsonObject();
                root.add(name, (JsonElement)custom);
                try (FileWriter writer = new FileWriter(file);){
                    new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create().toJson((JsonElement)root, (Appendable)writer);
                    EnumMap<COMPASS, TARDISChameleonColumn> blueprints = new EnumMap<COMPASS, TARDISChameleonColumn>(COMPASS.class);
                    EnumMap<COMPASS, TARDISChameleonColumn> stains = new EnumMap<COMPASS, TARDISChameleonColumn>(COMPASS.class);
                    EnumMap<COMPASS, TARDISChameleonColumn> glasses = new EnumMap<COMPASS, TARDISChameleonColumn>(COMPASS.class);
                    for (COMPASS d : COMPASS.values()) {
                        blueprints.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, blueprint));
                        stains.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, stained));
                        glasses.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, glass));
                    }
                    TARDISCustomPreset.CUSTOM_PRESETS.put(name, new CustomPreset(blueprints, stains, glasses, List.of(" ", " "), Material.ENDER_CHEST));
                }
            }
            catch (IOException io) {
                TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not read custom presets file! " + io.getMessage());
            }
        }
    }
}

