/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.utils.TARDISAcceptor;
import me.eccentric_nz.TARDIS.desktop.PreviewData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesPattern;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesRequest;
import me.eccentric_nz.TARDIS.howto.TARDISSeedsInventory;
import me.eccentric_nz.TARDIS.travel.ComehereAction;
import me.eccentric_nz.TARDIS.travel.ComehereRequest;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TARDISChatListener
implements Listener {
    private final TARDIS plugin;
    private final Pattern handlesPattern = TARDISHandlesPattern.getPattern("prefix");
    private Pattern howToPattern = null;

    public TARDISChatListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        Player player = event.getPlayer();
        UUID chatter = player.getUniqueId();
        String chat = ComponentUtils.stripColour(event.message()).toLowerCase(Locale.ROOT);
        if (chat.equals("tardis rescue accept") || chat.equals("tardis request accept")) {
            event.setCancelled(true);
            boolean request = chat.equals("tardis request accept");
            if (this.plugin.getTrackerKeeper().getChatRescue().containsKey(chatter)) {
                new TARDISAcceptor(this.plugin).doRequest(player, request);
            } else {
                String message = request ? "REQUEST_TIMEOUT" : "RESCUE_TIMEOUT";
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
            }
        } else if (chat.equals("tardis call accept")) {
            event.setCancelled(true);
            if (this.plugin.getTrackerKeeper().getComehereRequests().containsKey(chatter)) {
                ComehereRequest request = this.plugin.getTrackerKeeper().getComehereRequests().get(chatter);
                new ComehereAction(this.plugin).doTravel(request);
                this.plugin.getTrackerKeeper().getComehereRequests().remove(chatter);
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_TIMEOUT");
            }
        } else if (this.handlesPattern.matcher(chat).lookingAt()) {
            event.setCancelled(true);
            new TARDISHandlesRequest(this.plugin).process(chatter, ComponentUtils.stripColour(event.message()));
        } else if (chat.equals("done") && this.plugin.getTrackerKeeper().getPreviewers().containsKey(chatter)) {
            event.setCancelled(true);
            PreviewData pd = this.plugin.getTrackerKeeper().getPreviewers().get(chatter);
            Location transmat = pd.location();
            if (transmat != null) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
                this.plugin.getTrackerKeeper().getPreviewers().remove(chatter);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    player.playSound(transmat, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                    player.teleport(transmat);
                    player.setGameMode(pd.gamemode());
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        HashMap<String, Object> set = new HashMap<String, Object>();
                        set.put("tardis_id", pd.id());
                        set.put("uuid", chatter.toString());
                        this.plugin.getQueryFactory().doSyncInsert("travellers", set);
                    }, 10L);
                }, 10L);
            }
        } else {
            this.handleChat(player, ComponentUtils.stripColour(event.message()));
        }
    }

    private void handleChat(Player p, String message) {
        if (this.plugin.getTrackerKeeper().getHowTo().contains(p.getUniqueId())) {
            return;
        }
        if (this.howToPattern == null) {
            this.howToPattern = Pattern.compile("(^|.*\\W)how\\W.*\\W(craft|create|make|build|get)\\W.*tardis(\\W.*|$)", 2);
        }
        if (this.howToPattern.matcher(message).matches()) {
            this.plugin.getTrackerKeeper().getHowTo().add(p.getUniqueId());
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.openInventory(new TARDISSeedsInventory(this.plugin, p).getInventory()), 1L);
        }
    }
}

