/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.ReplacedBlock;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.hads.TARDISHostileAction;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TARDISBlockDamageListener
implements Listener {
    private final TARDIS plugin;

    public TARDISBlockDamageListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPoliceBoxDamage(BlockDamageEvent event) {
        Block b = event.getBlock();
        String l = b.getLocation().toString();
        if (this.plugin.getGeneralKeeper().getProtectBlockMap().containsKey(l)) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("location", l);
            ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, where, false);
            if (rsb.resultSet()) {
                ItemStack is;
                Player p = event.getPlayer();
                ReplacedBlock rb = rsb.getReplacedBlock();
                int id = rb.getTardis_id();
                if (TARDISPermission.hasPermission(p, "tardis.sonic.admin") && (is = event.getItemInHand()).getType().equals((Object)Material.BLAZE_ROD)) {
                    this.unhide(id, p);
                }
                boolean m = false;
                boolean isDoor = false;
                int damage = this.plugin.getTrackerKeeper().getHadsDamage().getOrDefault(id, 0);
                if (damage <= this.plugin.getConfig().getInt("preferences.hads_damage") && this.plugin.getConfig().getBoolean("allow.hads") && !this.plugin.getTrackerKeeper().getInVortex().contains(id) && TARDISStaticUtils.isOwnerOnline(id) && !this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                    if (TARDISMaterials.doors.contains(b.getType()) && this.isOwner(id, p.getUniqueId().toString())) {
                        isDoor = true;
                    }
                    if (!isDoor && rb.getPolice_box() == 1) {
                        this.plugin.getTrackerKeeper().getHadsDamage().put(id, damage + 1);
                        if (damage == this.plugin.getConfig().getInt("preferences.hads_damage")) {
                            new TARDISHostileAction(this.plugin).processAction(id, p);
                            m = true;
                        }
                        if (!m) {
                            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "HADS_WARNING", String.format("%d", this.plugin.getConfig().getInt("preferences.hads_damage") - damage));
                        }
                    }
                } else {
                    this.plugin.getMessenger().sendStatus(p, "TARDIS_BREAK");
                }
                event.setCancelled(true);
            }
        }
    }

    private boolean isOwner(int id, String uuid) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("uuid", uuid);
        ResultSetTardis rst = new ResultSetTardis(this.plugin, where, "", false);
        return rst.resultSet();
    }

    private void unhide(int id, Player player) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rst = new ResultSetTardis(this.plugin, where, "", false);
        if (rst.resultSet() && rst.getTardis().isHidden()) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return;
            }
            Current current = rsc.getCurrent();
            BuildData bd = new BuildData(player.getUniqueId().toString());
            bd.setDirection(current.direction());
            bd.setLocation(current.location());
            bd.setMalfunction(false);
            bd.setOutside(false);
            bd.setPlayer((OfflinePlayer)player);
            bd.setRebuild(true);
            bd.setSubmarine(current.submarine());
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 5L);
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            HashMap<String, Object> seth = new HashMap<String, Object>();
            seth.put("hidden", 0);
            this.plugin.getQueryFactory().doUpdate("tardis", seth, whereh);
        }
    }
}

