/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lights;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.lights.Sequences;
import me.eccentric_nz.TARDIS.lights.TARDISLightSequenceInventory;
import me.eccentric_nz.TARDIS.lights.TARDISLightsInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISLightSequenceGUIListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final List<Material> colours = List.of(Material.BLUE_WOOL, Material.GREEN_WOOL, Material.ORANGE_WOOL, Material.PINK_WOOL, Material.PURPLE_WOOL, Material.YELLOW_WOOL, Material.RED_WOOL, Material.WHITE_WOOL, Material.BLACK_WOOL);
    private final List<ClickType> clicks = List.of(ClickType.SHIFT_LEFT, ClickType.SHIFT_RIGHT, ClickType.DOUBLE_CLICK);

    public TARDISLightSequenceGUIListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onLightMenuClick(InventoryClickEvent event) {
        ItemStack is;
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof TARDISLightSequenceInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (slot >= 0 && slot < 45 && (is = view.getItem(slot)) != null) {
            switch (slot) {
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    this.setColour(view, slot);
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.setDelay(view, slot, this.clicks.contains(event.getClick()));
                    break;
                }
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    this.setLevel(view, slot, this.clicks.contains(event.getClick()));
                    break;
                }
                case 36: {
                    this.cyclePresets(view);
                    break;
                }
                case 40: {
                    this.save(view, uuid.toString());
                    break;
                }
                case 42: {
                    ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                    if (!rst.fromUUID(uuid.toString())) break;
                    player.openInventory(new TARDISLightsInventory(this.plugin, rst.getTardisId(), uuid).getInventory());
                    break;
                }
                case 44: {
                    this.close(player);
                    break;
                }
            }
        }
    }

    private void setColour(InventoryView view, int slot) {
        ItemStack wool = view.getItem(slot);
        int index = this.colours.indexOf(wool.getType()) + 1;
        if (index == this.colours.size()) {
            index = 0;
        }
        Material next = this.colours.get(index);
        view.setItem(slot, ItemStack.of((Material)next));
    }

    private void setDelay(InventoryView view, int slot, boolean shift) {
        ItemStack delay = view.getItem(slot);
        int amount = delay.getAmount() + 1;
        if (amount > 40) {
            amount = 5;
        }
        if (shift) {
            for (int i = 18; i < 27; ++i) {
                ItemStack d = view.getItem(i);
                d.setAmount(amount);
            }
        } else {
            delay.setAmount(amount);
        }
    }

    private void setLevel(InventoryView view, int slot, boolean shift) {
        ItemStack level = view.getItem(slot);
        int amount = level.getAmount();
        int index = ArrayUtils.indexOf((int[])LightLevel.interior_level, (int)amount) + 1;
        if (index == 8) {
            index = 0;
        }
        if (shift) {
            for (int i = 27; i < 36; ++i) {
                ItemStack l = view.getItem(i);
                l.setAmount(LightLevel.interior_level[index]);
            }
        } else {
            level.setAmount(LightLevel.interior_level[index]);
        }
    }

    private void cyclePresets(InventoryView view) {
        ItemStack preset = view.getItem(36);
        ItemMeta im = preset.getItemMeta();
        List lore = im.lore();
        String num = ComponentUtils.stripColour((Component)lore.get(2));
        int next = TARDISNumberParsers.parseInt(num) + 1;
        if (next == Sequences.PRESETS.size()) {
            next = 0;
        }
        List<Material> sequence = Sequences.PRESETS.get(next);
        for (int i = 9; i < 18; ++i) {
            view.setItem(i, ItemStack.of((Material)sequence.get(i - 9)));
        }
        List<Integer> delays = Sequences.DELAYS.get(next);
        for (int i = 18; i < 27; ++i) {
            view.getItem(i).setAmount(delays.get(i - 18).intValue());
        }
        List<Integer> levels = Sequences.LEVELS.get(next);
        for (int i = 27; i < 36; ++i) {
            view.getItem(i).setAmount(levels.get(i - 27).intValue());
        }
        lore.set(2, Component.text((int)next));
        im.lore(lore);
        preset.setItemMeta(im);
    }

    private void save(InventoryView view, String uuid) {
        ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
        if (rst.fromUUID(uuid)) {
            int id = rst.getTardisId();
            StringBuilder patternBuilder = new StringBuilder();
            for (int i = 9; i < 18; ++i) {
                ItemStack wool = view.getItem(i);
                String material = wool.getType().toString().replace("_WOOL", "");
                patternBuilder.append(material);
                if (i == 17) continue;
                patternBuilder.append(":");
            }
            StringBuilder delayBuilder = new StringBuilder();
            for (int i = 18; i < 27; ++i) {
                ItemStack delay = view.getItem(i);
                int amount = delay.getAmount();
                delayBuilder.append(amount);
                if (i == 26) continue;
                delayBuilder.append(":");
            }
            StringBuilder levelBuilder = new StringBuilder();
            for (int i = 27; i < 36; ++i) {
                ItemStack level = view.getItem(i);
                int amount = level.getAmount();
                levelBuilder.append(amount);
                if (i == 35) continue;
                levelBuilder.append(":");
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("pattern", patternBuilder.toString());
            set.put("delays", delayBuilder.toString());
            set.put("levels", levelBuilder.toString());
            ResultSetLightPrefs rslp = new ResultSetLightPrefs(this.plugin);
            if (rslp.fromID(id)) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                this.plugin.getQueryFactory().doUpdate("light_prefs", set, where);
            } else {
                set.put("tardis_id", id);
                this.plugin.getQueryFactory().doInsert("light_prefs", set);
            }
        }
    }
}

