/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus.disguise;

import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguise;
import me.eccentric_nz.TARDIS.lazarus.disguise.TARDISDisguiseTracker;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerLookAtPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class TARDISArmourStandDisguiser {
    private final ArmorStand stand;
    private final Object[] options;
    private final EntityType entityType;
    private Entity entity;

    public TARDISArmourStandDisguiser(ArmorStand stand, EntityType entityType, Object[] options) {
        this.stand = stand;
        this.entityType = entityType;
        this.options = options;
        this.createDisguise();
    }

    public static void disguiseToPlayer(Player to, World world) {
        for (Map.Entry<UUID, TARDISDisguise> map : TARDISDisguiseTracker.DISGUISED_ARMOR_STANDS.entrySet()) {
            Entity mob;
            ArmorStand stand = (ArmorStand)Bukkit.getEntity((UUID)map.getKey());
            if (stand == null || stand.getWorld() != world || (mob = TARDISDisguise.createMobDisguise(map.getValue(), world)) == null) continue;
            TARDISArmourStandDisguiser.setEntityLocationIdAndName(mob, stand.getLocation(), stand);
            ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{stand.getEntityId()});
            ClientboundAddEntityPacket packetPlayOutSpawnEntityLiving = new ClientboundAddEntityPacket(mob, 0, mob.blockPosition());
            ClientboundSetEntityDataPacket packetPlayOutEntityMetadata = new ClientboundSetEntityDataPacket(mob.getId(), mob.getEntityData().getNonDefaultValues());
            ClientboundPlayerLookAtPacket packetPlayOutEntityLook = new ClientboundPlayerLookAtPacket(EntityAnchorArgument.Anchor.FEET, (double)mob.blockPosition().getX(), (double)mob.blockPosition().getY(), (double)mob.blockPosition().getZ());
            ServerGamePacketListenerImpl connection = ((CraftPlayer)to).getHandle().connection;
            connection.send((Packet)packetPlayOutEntityDestroy);
            connection.send((Packet)packetPlayOutSpawnEntityLiving);
            connection.send((Packet)packetPlayOutEntityMetadata);
            connection.send((Packet)packetPlayOutEntityLook);
        }
    }

    public static void redisguise(ArmorStand stand, World world) {
        TARDISDisguise disguise = TARDISDisguiseTracker.DISGUISED_AS_MOB.get(stand.getUniqueId());
        Entity mob = TARDISDisguise.createMobDisguise(disguise, world);
        if (mob != null) {
            TARDISArmourStandDisguiser.setEntityLocationIdAndName(mob, stand.getLocation(), stand);
            TARDISDisguiseTracker.DISGUISED_AS_MOB.put(stand.getUniqueId(), new TARDISDisguise(disguise.entityType(), disguise.options()));
            ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{stand.getEntityId()});
            ClientboundAddEntityPacket packetPlayOutSpawnEntityLiving = new ClientboundAddEntityPacket(mob, 0, mob.blockPosition());
            ClientboundSetEntityDataPacket packetPlayOutEntityMetadata = new ClientboundSetEntityDataPacket(mob.getId(), mob.getEntityData().getNonDefaultValues());
            ClientboundPlayerLookAtPacket packetPlayOutEntityLook = new ClientboundPlayerLookAtPacket(EntityAnchorArgument.Anchor.FEET, (double)mob.blockPosition().getX(), (double)mob.blockPosition().getY(), (double)mob.blockPosition().getZ());
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (stand.getWorld() != p.getWorld()) continue;
                ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
                connection.send((Packet)packetPlayOutEntityDestroy);
                connection.send((Packet)packetPlayOutSpawnEntityLiving);
                connection.send((Packet)packetPlayOutEntityMetadata);
                connection.send((Packet)packetPlayOutEntityLook);
            }
        }
    }

    private static void setEntityLocationIdAndName(Entity entity, Location location, ArmorStand stand) {
        entity.setPos(location.getX(), location.getY(), location.getZ());
        entity.setId(stand.getEntityId());
        float fixed = TARDISArmourStandDisguiser.fixYaw(location.getYaw());
        entity.setYHeadRot(fixed);
        entity.setYBodyRot(fixed);
        entity.setYRot(fixed);
        entity.setXRot(location.getPitch());
        Mob insentient = (Mob)entity;
        insentient.setNoAi(true);
    }

    private static float fixYaw(float yaw) {
        return yaw * 256.0f / 360.0f;
    }

    public static void removeDisguise(ArmorStand stand) {
        TARDISDisguiseTracker.DISGUISED_ARMOR_STANDS.remove(stand.getUniqueId());
        ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{stand.getEntityId()});
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (stand.getWorld() != p.getWorld()) continue;
            ((CraftPlayer)p).getHandle().connection.send((Packet)packetPlayOutEntityDestroy);
        }
    }

    private void createDisguise() {
        if (this.entityType != null) {
            Location location = this.stand.getLocation();
            TARDISDisguise disguise = new TARDISDisguise(this.entityType, this.options);
            this.entity = TARDISDisguise.createMobDisguise(disguise, location.getWorld());
            if (this.entity != null) {
                TARDISArmourStandDisguiser.setEntityLocationIdAndName(this.entity, location, this.stand);
            }
        }
    }

    public void disguiseToAll() {
        TARDISDisguiseTracker.DISGUISED_AS_MOB.put(this.stand.getUniqueId(), new TARDISDisguise(this.entityType, this.options));
        ClientboundRemoveEntitiesPacket packetPlayOutEntityDestroy = new ClientboundRemoveEntitiesPacket(new int[]{this.stand.getEntityId()});
        ClientboundAddEntityPacket packetPlayOutSpawnEntityLiving = new ClientboundAddEntityPacket(this.entity, 0, this.entity.blockPosition());
        ClientboundSetEntityDataPacket packetPlayOutEntityMetadata = new ClientboundSetEntityDataPacket(this.entity.getId(), this.entity.getEntityData().getNonDefaultValues());
        ClientboundPlayerLookAtPacket packetPlayOutEntityLook = new ClientboundPlayerLookAtPacket(EntityAnchorArgument.Anchor.FEET, (double)this.entity.blockPosition().getX(), (double)this.entity.blockPosition().getY(), (double)this.entity.blockPosition().getZ());
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (this.stand.getWorld() != p.getWorld()) continue;
            ServerGamePacketListenerImpl connection = ((CraftPlayer)p).getHandle().connection;
            connection.send((Packet)packetPlayOutEntityDestroy);
            connection.send((Packet)packetPlayOutSpawnEntityLiving);
            connection.send((Packet)packetPlayOutEntityMetadata);
            connection.send((Packet)packetPlayOutEntityLook);
        }
    }
}

