/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.info;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIChameleonPoliceBoxes;
import me.eccentric_nz.TARDIS.info.TARDISInfoMenu;
import me.eccentric_nz.TARDIS.info.TISCategory;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISIndexFileSection
implements InventoryHolder {
    private final TARDIS plugin;
    private final TISCategory category;
    private final Inventory inventory;

    public TARDISIndexFileSection(TARDIS plugin, TISCategory category) {
        this.plugin = plugin;
        this.category = category;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Info Category", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[54];
        int i = 0;
        for (TARDISInfoMenu tim : TARDISInfoMenu.values()) {
            if (this.category == TISCategory.ITEMS && tim.isItem()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.CONSOLE_BLOCKS && tim.isConsoleBlock()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.ACCESSORIES && tim.isAccessory()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.COMPONENTS && tim.isComponent()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.SONIC_COMPONENTS && tim.isSonicComponent()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.SONIC_UPGRADES && tim.isSonicUpgrade()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.CONSOLES && tim.isConsole()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.DISKS && tim.isDisk()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.ROOMS && tim.isRoom()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.PLANETS && tim.isPlanet()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.TIME_TRAVEL && tim.isTimeTravel()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.FOOD && tim.isFood()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category == TISCategory.UPDATEABLE_BLOCKS && tim.isUpdateable()) {
                stack[i] = this.makeButton(tim);
                ++i;
                continue;
            }
            if (this.category != TISCategory.MONSTERS || !tim.isMonster()) continue;
            stack[i] = this.makeButton(tim);
            ++i;
        }
        ItemStack back = ItemStack.of((Material)GUIChameleonPoliceBoxes.BACK.material(), (int)1);
        ItemMeta but = back.getItemMeta();
        but.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(but);
        stack[45] = back;
        ItemStack close = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta close_im = close.getItemMeta();
        close_im.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(close_im);
        stack[53] = close;
        return stack;
    }

    private ItemStack makeButton(TARDISInfoMenu tim) {
        ItemStack is = ItemStack.of((Material)Material.WRITTEN_BOOK, (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(tim.toString())));
        is.setItemMeta(im);
        return is;
    }
}

