/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.floodgate.FloodgateControlForm;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.geysermc.floodgate.api.FloodgateApi;

public class TARDISFloodgate {
    private static final Pattern VALID_KEY = Pattern.compile("[a-z0-9/._-]+");

    public static boolean isBedrockPlayer(UUID uuid) {
        return FloodgateApi.getInstance().isFloodgatePlayer(uuid);
    }

    public static boolean isFloodgateEnabled() {
        try {
            Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String sanitisePlayerName(String name) {
        String replace = "^" + FloodgateApi.getInstance().getPlayerPrefix();
        return name.replaceFirst(replace, "");
    }

    public static String getPlayerWorldName(String name) {
        return "TARDIS_WORLD_" + name.replaceFirst(FloodgateApi.getInstance().getPlayerPrefix(), ".");
    }

    public static boolean shouldReplacePrefix(String name) {
        if (!TARDISFloodgate.isFloodgateEnabled()) {
            return false;
        }
        Player player = Bukkit.getPlayer((String)name);
        if (player == null) {
            return false;
        }
        if (!TARDISFloodgate.isBedrockPlayer(player.getUniqueId())) {
            return false;
        }
        return !VALID_KEY.matcher(player.getName()).matches();
    }

    public static boolean shouldReplacePrefix(UUID uuid) {
        if (!TARDISFloodgate.isFloodgateEnabled()) {
            return false;
        }
        if (!TARDISFloodgate.isBedrockPlayer(uuid)) {
            return false;
        }
        Player player = Bukkit.getPlayer((UUID)uuid);
        if (player == null) {
            return false;
        }
        return !VALID_KEY.matcher(player.getName()).matches();
    }

    public static void sendControlForm(UUID uuid) {
        new FloodgateControlForm(TARDIS.plugin, uuid).send();
    }
}

