/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.destroyers;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.construct.TARDISConstructColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.CustomPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISCustomPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISStainedGlassLookup;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.ParticleData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCustomPreset;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetParticlePrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.destroyers.TARDISDeinstantPreset;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.particles.Emitter;
import me.eccentric_nz.TARDIS.particles.TARDISParticles;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TARDISDematerialisePreset
implements Runnable {
    private final TARDIS plugin;
    private final DestroyData dd;
    private final int loops;
    private final ChameleonPreset preset;
    private final BlockData cham_id;
    private final TARDISChameleonColumn column;
    private final TARDISChameleonColumn stained_column;
    private final TARDISChameleonColumn glass_column;
    private int task;
    private int i;
    private BlockData the_colour;
    private BlockData stain_colour;

    TARDISDematerialisePreset(TARDIS plugin, DestroyData dd, ChameleonPreset preset, BlockData cham_id) {
        this.plugin = plugin;
        this.dd = dd;
        this.loops = dd.getThrottle().getLoops();
        this.preset = preset;
        this.i = 0;
        this.cham_id = cham_id;
        if (this.preset.equals((Object)ChameleonPreset.CONSTRUCT)) {
            this.column = new TARDISConstructColumn(plugin, dd.getTardisID(), "blueprintData", dd.getDirection().forPreset()).getColumn();
            this.stained_column = new TARDISConstructColumn(plugin, dd.getTardisID(), "stainData", dd.getDirection().forPreset()).getColumn();
            this.glass_column = new TARDISConstructColumn(plugin, dd.getTardisID(), "glassData", dd.getDirection().forPreset()).getColumn();
        } else if (this.preset.equals((Object)ChameleonPreset.CUSTOM)) {
            ResultSetCustomPreset rscp = new ResultSetCustomPreset(plugin);
            String key = rscp.fromId(dd.getTardisID()) ? rscp.getPreset() : "custom";
            CustomPreset custom = TARDISCustomPreset.CUSTOM_PRESETS.get(key);
            this.column = custom.blueprint().get((Object)dd.getDirection().forPreset());
            this.stained_column = custom.stained().get((Object)dd.getDirection().forPreset());
            this.glass_column = custom.glass().get((Object)dd.getDirection().forPreset());
        } else {
            this.column = plugin.getPresets().getColumn(preset, dd.getDirection().forPreset());
            this.stained_column = plugin.getPresets().getStained(preset, dd.getDirection().forPreset());
            this.glass_column = plugin.getPresets().getGlass(preset, dd.getDirection().forPreset());
        }
    }

    @Override
    public void run() {
        if (this.column == null || this.stained_column == null || this.glass_column == null) {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = 0;
            this.plugin.getMessenger().sendColouredCommand((CommandSender)this.dd.getPlayer().getPlayer(), "INVALID_CONSTRUCT", "/tardistravel stop", this.plugin);
            this.plugin.getTrackerKeeper().getDematerialising().removeAll(Collections.singleton(this.dd.getTardisID()));
            this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(this.dd.getTardisID()));
            return;
        }
        int x = this.dd.getLocation().getBlockX();
        int plusx = this.dd.getLocation().getBlockX() + 1;
        int minusx = this.dd.getLocation().getBlockX() - 1;
        int y = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.dd.getLocation().getBlockY() - 1 : this.dd.getLocation().getBlockY();
        int z = this.dd.getLocation().getBlockZ();
        int plusz = this.dd.getLocation().getBlockZ() + 1;
        int minusz = this.dd.getLocation().getBlockZ() - 1;
        World world = this.dd.getLocation().getWorld();
        if (this.i < this.loops) {
            BlockData[][] data = this.i % 2 == 0 ? this.stained_column.blockData() : (this.i % 4 == 1 ? this.glass_column.blockData() : this.column.blockData());
            ++this.i;
            if (this.i == 1) {
                UUID uuid;
                ResultSetParticlePrefs rspp;
                switch (this.preset) {
                    case GRAVESTONE: {
                        int flowerx;
                        int flowery = this.dd.getLocation().getBlockY() + 1;
                        TARDISBlockSetters.setBlock(world, flowerx, flowery, switch (this.dd.getDirection().forPreset()) {
                            case COMPASS.NORTH -> {
                                flowerx = this.dd.getLocation().getBlockX();
                                yield this.dd.getLocation().getBlockZ() + 1;
                            }
                            case COMPASS.WEST -> {
                                flowerx = this.dd.getLocation().getBlockX() + 1;
                                yield this.dd.getLocation().getBlockZ();
                            }
                            case COMPASS.SOUTH -> {
                                flowerx = this.dd.getLocation().getBlockX();
                                yield this.dd.getLocation().getBlockZ() - 1;
                            }
                            default -> {
                                flowerx = this.dd.getLocation().getBlockX() - 1;
                                yield this.dd.getLocation().getBlockZ();
                            }
                        }, Material.AIR);
                        break;
                    }
                    case CAKE: {
                        this.plugin.getPresetDestroyer().destroyLamp(this.dd.getLocation(), this.preset);
                        break;
                    }
                    case JUNK_MODE: {
                        this.plugin.getPresetDestroyer().destroySign(this.dd.getLocation(), this.dd.getDirection().forPreset(), this.preset);
                        this.plugin.getPresetDestroyer().destroyHandbrake(this.dd.getLocation(), this.dd.getDirection().forPreset());
                        break;
                    }
                    case SWAMP: {
                        this.plugin.getPresetDestroyer().destroySign(this.dd.getLocation(), this.dd.getDirection().forPreset(), this.preset);
                        break;
                    }
                    case JAIL: 
                    case TOPSYTURVEY: {
                        this.plugin.getPresetDestroyer().destroyDoor(this.dd.getTardisID());
                        break;
                    }
                    case MESA: {
                        int bushx;
                        int deadz;
                        int deadx;
                        this.plugin.getPresetDestroyer().destroyDoor(this.dd.getTardisID());
                        int bushy = this.dd.getLocation().getBlockY() + 3;
                        int bushz = switch (this.dd.getDirection().forPreset()) {
                            case COMPASS.NORTH -> {
                                deadx = this.dd.getLocation().getBlockX() + 1;
                                deadz = this.dd.getLocation().getBlockZ() + 1;
                                bushx = this.dd.getLocation().getBlockX() - 1;
                                yield this.dd.getLocation().getBlockZ();
                            }
                            case COMPASS.WEST -> {
                                deadx = this.dd.getLocation().getBlockX() + 1;
                                deadz = this.dd.getLocation().getBlockZ() - 1;
                                bushx = this.dd.getLocation().getBlockX();
                                yield this.dd.getLocation().getBlockZ() + 1;
                            }
                            case COMPASS.SOUTH -> {
                                deadx = this.dd.getLocation().getBlockX() - 1;
                                deadz = this.dd.getLocation().getBlockZ() - 1;
                                bushx = this.dd.getLocation().getBlockX() + 1;
                                yield this.dd.getLocation().getBlockZ();
                            }
                            default -> {
                                deadx = this.dd.getLocation().getBlockX() - 1;
                                deadz = this.dd.getLocation().getBlockZ() + 1;
                                bushx = this.dd.getLocation().getBlockX();
                                yield this.dd.getLocation().getBlockZ() - 1;
                            }
                        };
                        TARDISBlockSetters.setBlock(world, deadx, bushy, deadz, Material.AIR);
                        TARDISBlockSetters.setBlock(world, bushx, bushy, bushz, Material.AIR);
                        break;
                    }
                    case PUNKED: {
                        this.plugin.getPresetDestroyer().destroyPistons(this.dd.getLocation());
                        break;
                    }
                }
                if (this.dd.isOutside()) {
                    ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.dd.getPlayer().getUniqueId().toString());
                    boolean minecart = false;
                    if (rsp.resultSet()) {
                        minecart = rsp.isMinecartOn();
                    }
                    if (!minecart) {
                        String sound;
                        if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                            sound = "junk_takeoff";
                        } else {
                            sound = switch (this.dd.getThrottle()) {
                                case SpaceTimeThrottle.WARP, SpaceTimeThrottle.RAPID, SpaceTimeThrottle.FASTER -> "tardis_takeoff_" + this.dd.getThrottle().toString().toLowerCase(Locale.ROOT);
                                default -> "tardis_takeoff";
                            };
                        }
                        TARDISSounds.playTARDISSound(this.dd.getLocation(), sound);
                    } else {
                        world.playSound(this.dd.getLocation(), Sound.ENTITY_MINECART_INSIDE, 1.0f, 0.0f);
                    }
                }
                if (this.dd.hasParticles() && this.preset != ChameleonPreset.JUNK_MODE && (rspp = new ResultSetParticlePrefs(this.plugin)).fromUUID((uuid = this.dd.getPlayer().getUniqueId()).toString())) {
                    ParticleData particleData = rspp.getData();
                    Emitter emitter = new Emitter(this.plugin, uuid, this.dd.getLocation(), particleData, this.dd.getThrottle().getFlightTime());
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)emitter, 0L, particleData.getShape().getPeriod());
                    emitter.setTaskID(task);
                }
                this.getColours(this.dd.getTardisID(), this.preset);
            } else if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE) && this.plugin.getConfig().getBoolean("junk.particles")) {
                this.plugin.getUtils().getJunkTravellers(this.dd.getLocation()).forEach(e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        Location effectsLoc = this.dd.getLocation().clone().add(0.5, 0.0, 0.5);
                        TARDISParticles.sendVortexParticles(effectsLoc, p);
                    }
                });
            } else {
                if (this.i % 3 == 1 && this.preset.equals((Object)ChameleonPreset.PUNKED)) {
                    this.plugin.getPresetDestroyer().destroyPistons(this.dd.getLocation());
                }
                for (int n = 0; n < 9; ++n) {
                    int xx;
                    BlockData[] colData = data[n];
                    int zz = switch (n) {
                        case 0 -> {
                            xx = minusx;
                            yield minusz;
                        }
                        case 1 -> {
                            xx = x;
                            yield minusz;
                        }
                        case 2 -> {
                            xx = plusx;
                            yield minusz;
                        }
                        case 3 -> {
                            xx = plusx;
                            yield z;
                        }
                        case 4 -> {
                            xx = plusx;
                            yield plusz;
                        }
                        case 5 -> {
                            xx = x;
                            yield plusz;
                        }
                        case 6 -> {
                            xx = minusx;
                            yield plusz;
                        }
                        case 7 -> {
                            xx = minusx;
                            yield z;
                        }
                        default -> {
                            xx = x;
                            yield z;
                        }
                    };
                    block44: for (int yy = 3; yy >= 0; --yy) {
                        Material mat = colData[yy].getMaterial();
                        switch (mat) {
                            case GRASS_BLOCK: 
                            case DIRT: {
                                BlockData subi = this.preset.equals((Object)ChameleonPreset.SUBMERGED) ? this.cham_id : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, subi);
                                continue block44;
                            }
                            case WHITE_WOOL: 
                            case LIME_WOOL: {
                                BlockData chaw = this.preset.equals((Object)ChameleonPreset.FLOWER) ? this.the_colour : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chaw);
                                continue block44;
                            }
                            case ACACIA_SAPLING: 
                            case ALLIUM: 
                            case AZURE_BLUET: 
                            case BAMBOO_SAPLING: 
                            case BEETROOTS: 
                            case BIRCH_SAPLING: 
                            case BLUE_ORCHID: 
                            case CARROTS: 
                            case CORNFLOWER: 
                            case CRIMSON_FUNGUS: 
                            case CRIMSON_ROOTS: 
                            case DANDELION: 
                            case DARK_OAK_SAPLING: 
                            case DEAD_BUSH: 
                            case FERN: 
                            case SHORT_GRASS: 
                            case JUNGLE_SAPLING: 
                            case LARGE_FERN: 
                            case LILAC: 
                            case LILY_OF_THE_VALLEY: 
                            case OAK_SAPLING: 
                            case ORANGE_TULIP: 
                            case OXEYE_DAISY: 
                            case PEONY: 
                            case PINK_TULIP: 
                            case POPPY: 
                            case POTATOES: 
                            case RED_TULIP: 
                            case ROSE_BUSH: 
                            case SPRUCE_SAPLING: 
                            case SUGAR_CANE: 
                            case SUNFLOWER: 
                            case SWEET_BERRY_BUSH: 
                            case TALL_GRASS: 
                            case WARPED_FUNGUS: 
                            case WARPED_ROOTS: 
                            case WHEAT: 
                            case WHITE_TULIP: 
                            case WITHER_ROSE: {
                                continue block44;
                            }
                            case TORCH: 
                            case GLOWSTONE: 
                            case REDSTONE_LAMP: {
                                BlockData light = this.dd.isSubmarine() && mat.equals((Object)Material.TORCH) ? Material.GLOWSTONE.createBlockData() : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, light);
                                continue block44;
                            }
                            case IRON_DOOR: 
                            case ACACIA_DOOR: 
                            case ACACIA_TRAPDOOR: 
                            case ACACIA_WALL_SIGN: 
                            case BAMBOO_DOOR: 
                            case BAMBOO_TRAPDOOR: 
                            case BAMBOO_WALL_SIGN: 
                            case BIRCH_DOOR: 
                            case BIRCH_TRAPDOOR: 
                            case BIRCH_WALL_SIGN: 
                            case CHERRY_DOOR: 
                            case CHERRY_TRAPDOOR: 
                            case CHERRY_WALL_SIGN: 
                            case CRIMSON_DOOR: 
                            case CRIMSON_TRAPDOOR: 
                            case CRIMSON_WALL_SIGN: 
                            case DARK_OAK_DOOR: 
                            case DARK_OAK_TRAPDOOR: 
                            case DARK_OAK_WALL_SIGN: 
                            case JUNGLE_DOOR: 
                            case JUNGLE_TRAPDOOR: 
                            case JUNGLE_WALL_SIGN: 
                            case MANGROVE_DOOR: 
                            case MANGROVE_TRAPDOOR: 
                            case MANGROVE_WALL_SIGN: 
                            case OAK_DOOR: 
                            case OAK_TRAPDOOR: 
                            case OAK_WALL_SIGN: 
                            case SPRUCE_DOOR: 
                            case SPRUCE_TRAPDOOR: 
                            case SPRUCE_WALL_SIGN: 
                            case WARPED_DOOR: 
                            case WARPED_TRAPDOOR: 
                            case WARPED_WALL_SIGN: {
                                if (!this.preset.equals((Object)ChameleonPreset.SWAMP) && !this.preset.equals((Object)ChameleonPreset.TOPSYTURVEY) && !this.preset.equals((Object)ChameleonPreset.JAIL)) continue block44;
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, Material.AIR);
                                continue block44;
                            }
                            case WHITE_STAINED_GLASS: {
                                BlockData chaf = this.preset.equals((Object)ChameleonPreset.FLOWER) ? this.stain_colour : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chaf);
                                continue block44;
                            }
                            case LIME_STAINED_GLASS: {
                                BlockData chap = this.preset.equals((Object)ChameleonPreset.PARTY) ? this.stain_colour : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chap);
                                continue block44;
                            }
                            case LIGHT_GRAY_STAINED_GLASS: {
                                BlockData cham = this.preset.equals((Object)ChameleonPreset.FACTORY) ? TARDISStainedGlassLookup.stainedGlassFromMaterial(world, this.cham_id.getMaterial()).createBlockData() : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, cham);
                                continue block44;
                            }
                            case LIGHT_GRAY_TERRACOTTA: {
                                BlockData chai = this.preset.equals((Object)ChameleonPreset.FACTORY) ? this.cham_id : colData[yy];
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, chai);
                                continue block44;
                            }
                            default: {
                                TARDISBlockSetters.setBlock(world, xx, y + yy, zz, colData[yy]);
                                if (this.preset != ChameleonPreset.JUNK_MODE || mat != Material.ORANGE_WOOL && mat != Material.ORANGE_STAINED_GLASS && mat != Material.GLASS) continue block44;
                                TARDISDisplayItemUtils.remove(world.getBlockAt(xx, y + yy, zz));
                            }
                        }
                    }
                }
            }
        } else {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = 0;
            new TARDISDeinstantPreset(this.plugin).instaDestroyPreset(this.dd, this.dd.isHide(), this.preset);
            if (this.preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
                this.getJunkTravellers().forEach(e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        Location relativeLoc = this.getRelativeLocation(p);
                        p.teleport(relativeLoc);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.teleport(relativeLoc), 2L);
                    }
                });
            }
        }
    }

    private Location getRelativeLocation(Player p) {
        Location playerLoc = p.getLocation();
        double x = this.dd.getFromToLocation().getX() + (playerLoc.getX() - this.dd.getLocation().getX());
        double y = this.dd.getFromToLocation().getY() + (playerLoc.getY() - this.dd.getLocation().getY()) + 1.1;
        double z = this.dd.getFromToLocation().getZ() + (playerLoc.getZ() - this.dd.getLocation().getZ());
        Location l = new Location(this.dd.getFromToLocation().getWorld(), x, y, z, playerLoc.getYaw(), playerLoc.getPitch());
        while (!l.getChunk().isLoaded()) {
            l.getChunk().load();
        }
        return l;
    }

    private List<Entity> getJunkTravellers() {
        Entity orb = this.dd.getLocation().getWorld().spawnEntity(this.dd.getLocation(), EntityType.EXPERIENCE_ORB);
        List ents = orb.getNearbyEntities(1.0, 1.0, 1.0);
        orb.remove();
        return ents;
    }

    private void getColours(int id, ChameleonPreset p) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        where.put("door_type", 0);
        ResultSetDoors rs = new ResultSetDoors(this.plugin, where, false);
        if (rs.resultSet()) {
            try {
                Block b = TARDISStaticLocationGetters.getLocationFromDB(rs.getDoor_location()).getBlock();
                if (p.equals((Object)ChameleonPreset.FLOWER)) {
                    this.the_colour = b.getRelative(BlockFace.UP, 3).getBlockData();
                    String[] split = this.the_colour.getMaterial().toString().toLowerCase(Locale.ROOT).split("_");
                    String colour = split.length > 2 ? split[0] + "_" + split[1] : split[0];
                    this.stain_colour = this.plugin.getServer().createBlockData("minecraft:" + colour + "_stained_glass");
                    return;
                }
                for (BlockFace f : this.plugin.getGeneralKeeper().getFaces()) {
                    if (!Tag.WOOL.isTagged((Keyed)b.getRelative(f).getType())) continue;
                    this.the_colour = b.getRelative(f).getBlockData();
                    String[] split = this.the_colour.getMaterial().toString().toLowerCase(Locale.ROOT).split("_");
                    String colour = split.length > 2 ? split[0] + "_" + split[1] : split[0];
                    this.stain_colour = this.plugin.getServer().createBlockData("minecraft:" + colour + "_stained_glass");
                    return;
                }
            }
            catch (Exception e) {
                this.the_colour = Material.BLUE_WOOL.createBlockData();
                this.stain_colour = Material.BLUE_STAINED_GLASS.createBlockData();
                return;
            }
        }
        this.the_colour = Material.BLUE_WOOL.createBlockData();
        this.stain_colour = Material.BLUE_STAINED_GLASS.createBlockData();
    }

    public void setTask(int task) {
        this.task = task;
    }
}

