/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.SystemUpgrade;

public class ResultSetSystemUpgrades {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String uuid;
    private final String prefix;
    private SystemUpgrade data;

    public ResultSetSystemUpgrades(TARDIS plugin, int id, String uuid) {
        this.plugin = plugin;
        this.id = id;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultset() {
        block16: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT " + this.prefix + "player_prefs.artron_level, " + this.prefix + "system_upgrades.* FROM " + this.prefix + "player_prefs, " + this.prefix + "system_upgrades WHERE " + this.prefix + "system_upgrades.uuid = ? AND " + this.prefix + "system_upgrades.tardis_id = ? AND " + this.prefix + "system_upgrades.uuid = " + this.prefix + "player_prefs.uuid";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                statement.setInt(2, this.id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    rs.next();
                    this.data = new SystemUpgrade(rs.getInt("artron_level"), rs.getBoolean("architecture"), rs.getBoolean("chameleon"), rs.getBoolean("rooms"), rs.getBoolean("desktop"), rs.getBoolean("feature"), rs.getBoolean("saves"), rs.getBoolean("monitor"), rs.getBoolean("force_field"), rs.getBoolean("tools"), rs.getBoolean("locator"), rs.getBoolean("telepathic"), rs.getBoolean("stattenheim_remote"), rs.getBoolean("navigation"), rs.getBoolean("distance_1"), rs.getBoolean("distance_2"), rs.getBoolean("distance_3"), rs.getBoolean("inter_dimension"), rs.getBoolean("throttle"), rs.getBoolean("faster"), rs.getBoolean("rapid"), rs.getBoolean("warp"), rs.getBoolean("flight"));
                    break block16;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for player_prefs (system upgrades from UUID) table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing player_prefs (system upgrades from UUID) statement! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public SystemUpgrade getData() {
        return this.data;
    }
}

