/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetGravity {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final ArrayList<HashMap<String, String>> data = new ArrayList();
    private final String prefix;
    private int gravity_id;
    private int tardis_id;
    private String location;
    private int direction;
    private double distance;
    private double velocity;

    public ResultSetGravity(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block31: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "gravity_well" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else if (entry.getValue() instanceof Integer) {
                            statement.setInt(s, (Integer)entry.getValue());
                        } else if (entry.getValue() instanceof Double) {
                            statement.setDouble(s, (Double)entry.getValue());
                        } else if (entry.getValue() instanceof Float) {
                            statement.setFloat(s, ((Float)entry.getValue()).floatValue());
                        } else if (entry.getValue() instanceof Long) {
                            statement.setLong(s, (Long)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        if (this.multiple) {
                            HashMap<String, String> row = new HashMap<String, String>();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int columns = rsmd.getColumnCount();
                            for (int i = 1; i < columns + 1; ++i) {
                                row.put(rsmd.getColumnName(i).toLowerCase(Locale.ROOT), rs.getString(i));
                            }
                            this.data.add(row);
                        }
                        this.gravity_id = rs.getInt("g_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.location = rs.getString("location");
                        this.direction = rs.getInt("direction");
                        this.distance = rs.getDouble("distance");
                        this.velocity = rs.getDouble("velocity");
                    }
                    break block31;
                }
                boolean row = false;
                return row;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for gravity_well table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing gravity_well table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getGravity_id() {
        return this.gravity_id;
    }

    public int getDirection() {
        return this.direction;
    }

    public ArrayList<HashMap<String, String>> getData() {
        return this.data;
    }
}

