/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetControls {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final ArrayList<HashMap<String, String>> data = new ArrayList();
    private final String prefix;
    private int c_id;
    private int tardis_id;
    private int type;
    private String location;
    private int secondary;

    public ResultSetControls(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block24: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "controls" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        if (this.multiple) {
                            HashMap<String, String> row = new HashMap<String, String>();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int columns = rsmd.getColumnCount();
                            for (int i = 1; i < columns + 1; ++i) {
                                row.put(rsmd.getColumnName(i).toLowerCase(Locale.ROOT), rs.getString(i));
                            }
                            this.data.add(row);
                        }
                        this.c_id = rs.getInt("c_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.type = rs.getInt("type");
                        this.location = rs.getString("location");
                        this.secondary = rs.getInt("secondary");
                    }
                    break block24;
                }
                boolean row = false;
                return row;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for controls table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing controls table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getC_id() {
        return this.c_id;
    }

    public int getTardis_id() {
        return this.tardis_id;
    }

    public int getType() {
        return this.type;
    }

    public String getLocation() {
        return this.location;
    }

    public int getSecondary() {
        return this.secondary;
    }

    public ArrayList<HashMap<String, String>> getData() {
        return this.data;
    }
}

