/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetARS {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final String prefix;
    private int id;
    private int tardis_id;
    private UUID uuid;
    private int east;
    private int south;
    private int layer;
    private String json;

    public ResultSetARS(TARDIS plugin, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block22: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "ars" + (String)wheres;
            try {
                int s;
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        this.id = rs.getInt("ars_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.uuid = !rs.getString("uuid").isEmpty() ? UUID.fromString(rs.getString("uuid")) : UUID.randomUUID();
                        this.east = rs.getInt("ars_x_east");
                        this.south = rs.getInt("ars_z_south");
                        this.layer = rs.getInt("ars_y_layer");
                        this.json = rs.getString("json");
                        if (!rs.wasNull()) continue;
                        this.json = "";
                    }
                    break block22;
                }
                s = 0;
                return s != 0;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for ars table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing ars table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getId() {
        return this.id;
    }

    public int getEast() {
        return this.east;
    }

    public int getSouth() {
        return this.south;
    }

    public int getLayer() {
        return this.layer;
    }

    public String getJson() {
        return this.json;
    }
}

