/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.command.CommandSender;

public class TARDISWallConverter {
    private final String[] find = new String[]{"east=false", "east=true", "north=false", "north=true", "south=false", "south=true", "west=false", "west=true"};
    private final String[] repl = new String[]{"east=none", "east=low", "north=none", "north=low", "south=none", "south=low", "west=none", "west=low"};
    private final List<String> walls = new ArrayList<String>();
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public TARDISWallConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
        this.walls.add("cobblestone_wall");
        this.walls.add("mossy_cobblestone_wall");
        this.walls.add("stone_brick_wall");
        this.walls.add("mossy_stone_brick_wall");
        this.walls.add("andesite_wall");
        this.walls.add("diorite_wall");
        this.walls.add("granite_wall");
        this.walls.add("sandstone_wall");
        this.walls.add("red_sandstone_wall");
        this.walls.add("brick_wall");
        this.walls.add("prismarine_wall");
        this.walls.add("nether_brick_wall");
        this.walls.add("red_nether_brick_wall");
        this.walls.add("end_stone_brick_wall");
    }

    private boolean isWall(String inputStr) {
        return this.walls.stream().anyMatch(inputStr::contains);
    }

    private String fixWallData(String text) {
        return StringUtils.replaceEach((String)text, (String[])this.find, (String[])this.repl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processArchives() {
        int i = 0;
        ResultSet rs = null;
        PreparedStatement statement = null;
        Statement ps = null;
        String query = "SELECT * FROM " + this.prefix + "archive";
        String update = "UPDATE " + this.prefix + "archive SET data = ? WHERE archive_id = ?";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            ps = this.connection.prepareStatement(update);
            rs = statement.executeQuery();
            this.connection.setAutoCommit(false);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    boolean updateRecord = false;
                    JsonObject json = JsonParser.parseString((String)rs.getString("data")).getAsJsonObject();
                    JsonObject dimensions = json.get("dimensions").getAsJsonObject();
                    int h = dimensions.get("height").getAsInt();
                    int w = dimensions.get("width").getAsInt();
                    int c = dimensions.get("length").getAsInt();
                    JsonArray arr = json.get("input").getAsJsonArray();
                    for (int level = 0; level < h; ++level) {
                        JsonArray floor = arr.get(level).getAsJsonArray();
                        for (int row = 0; row < w; ++row) {
                            JsonArray r = (JsonArray)floor.get(row);
                            for (int col = 0; col < c; ++col) {
                                JsonObject block = r.get(col).getAsJsonObject();
                                String data = block.get("data").getAsString();
                                if (!this.isWall(data)) continue;
                                String fixed = this.fixWallData(data);
                                block.remove("data");
                                block.addProperty("data", fixed);
                                updateRecord = true;
                            }
                        }
                    }
                    if (!updateRecord) continue;
                    ps.setString(1, json.toString());
                    ps.setInt(2, rs.getInt("archive_id"));
                    ps.addBatch();
                    ++i;
                }
            }
            if (i > 0) {
                ps.executeBatch();
                this.connection.commit();
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " archive wall block data records");
            }
            this.plugin.getConfig().set("conversions.archive_wall_data", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for archive wall conversion! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing archive wall conversion! " + e.getMessage());
            }
        }
    }
}

