/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.TARDISSQLiteDatabaseUpdater;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class TARDISSQLiteDatabase {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private Statement statement = null;

    public TARDISSQLiteDatabase(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTables() {
        this.service.setIsMySQL(false);
        try {
            String sd_query;
            ResultSet rssd;
            this.statement = this.connection.createStatement();
            String queryAchievements = "CREATE TABLE IF NOT EXISTS " + this.prefix + "achievements (a_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', player TEXT COLLATE NOCASE DEFAULT '', name TEXT DEFAULT '', amount TEXT DEFAULT '', completed INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryAchievements);
            String queryArched = "CREATE TABLE IF NOT EXISTS " + this.prefix + "arched (uuid TEXT PRIMARY KEY NOT NULL, arch_name TEXT DEFAULT '', arch_time INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryArched);
            String queryArchive = "CREATE TABLE IF NOT EXISTS " + this.prefix + "archive (archive_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT, name TEXT, console_size TEXT, beacon INTEGER, lanterns INTEGER, use INTEGER, y INTEGER DEFAULT '64', data TEXT, description TEXT DEFAULT '')";
            this.statement.executeUpdate(queryArchive);
            String queryAreas = "CREATE TABLE IF NOT EXISTS " + this.prefix + "areas (area_id INTEGER PRIMARY KEY NOT NULL, area_name TEXT COLLATE NOCASE DEFAULT '', world TEXT COLLATE NOCASE DEFAULT '', minx INTEGER, minz INTEGER, maxx INTEGER, maxz INTEGER, y INTEGER, parking_distance INTEGER DEFAULT 2, invisibility TEXT DEFAULT 'ALLOW', direction TEXT DEFAULT '', grid INTEGER DEFAULT 1)";
            this.statement.executeUpdate(queryAreas);
            String queryAreaLocations = "CREATE TABLE IF NOT EXISTS " + this.prefix + "area_locations (area_location_id INTEGER PRIMARY KEY NOT NULL, area_id INTEGER, world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER)";
            this.statement.executeUpdate(queryAreaLocations);
            String queryARS = "CREATE TABLE IF NOT EXISTS " + this.prefix + "ars (ars_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, uuid TEXT DEFAULT '', player TEXT COLLATE NOCASE DEFAULT '', ars_x_east INTEGER DEFAULT 2, ars_z_south INTEGER DEFAULT 2, ars_y_layer INTEGER DEFAULT 1, json TEXT DEFAULT '')";
            this.statement.executeUpdate(queryARS);
            String queryAPowered = "CREATE TABLE IF NOT EXISTS " + this.prefix + "artron_powered (a_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, location TEXT DEFAULT '')";
            this.statement.executeUpdate(queryAPowered);
            String queryBack = "CREATE TABLE IF NOT EXISTS " + this.prefix + "back (back_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, direction TEXT DEFAULT '', submarine INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryBack);
            String queryBind = "CREATE TABLE IF NOT EXISTS " + this.prefix + "bind (bind_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, type INTEGER, location TEXT DEFAULT '', name TEXT DEFAULT '')";
            this.statement.executeUpdate(queryBind);
            String queryProtectBlocks = "CREATE TABLE IF NOT EXISTS " + this.prefix + "blocks (b_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, location TEXT COLLATE NOCASE DEFAULT '', data TEXT DEFAULT 'minecraft:air', police_box INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryProtectBlocks);
            String queryBlueprint = "CREATE TABLE IF NOT EXISTS " + this.prefix + "blueprint (bp_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', permission TEXT DEFAULT '')";
            this.statement.executeUpdate(queryBlueprint);
            String queryCamera = "CREATE TABLE IF NOT EXISTS " + this.prefix + "camera (c_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', location TEXT DEFAULT '')";
            this.statement.executeUpdate(queryCamera);
            String queryChameleon = "CREATE TABLE IF NOT EXISTS " + this.prefix + "chameleon (chameleon_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, blueprintData TEXT, stainData TEXT, glassData TEXT, line1 TEXT DEFAULT '', line2 TEXT DEFAULT '', line3 TEXT DEFAULT '', line4 TEXT DEFAULT '', active INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryChameleon);
            String queryColour = "CREATE TABLE IF NOT EXISTS " + this.prefix + "colour (colour_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, red INTEGER, green INTEGER, blue INTEGER)";
            this.statement.executeUpdate(queryColour);
            String queryChunks = "CREATE TABLE IF NOT EXISTS " + this.prefix + "chunks (chunk_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, world TEXT, x INTEGER, z INTEGER)";
            this.statement.executeUpdate(queryChunks);
            String queryCondenser = "CREATE TABLE IF NOT EXISTS " + this.prefix + "condenser (c_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, block_data TEXT COLLATE NOCASE DEFAULT '', block_count INTEGER)";
            this.statement.executeUpdate(queryCondenser);
            String queryControls = "CREATE TABLE IF NOT EXISTS " + this.prefix + "controls (c_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, type INTEGER, location TEXT COLLATE NOCASE DEFAULT '', secondary INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryControls);
            String queryCurrent = "CREATE TABLE IF NOT EXISTS " + this.prefix + "current (current_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, direction TEXT DEFAULT '', submarine INTEGER DEFAULT 0, biome TEXT DEFAULT '')";
            this.statement.executeUpdate(queryCurrent);
            String queryCustom = "CREATE TABLE IF NOT EXISTS " + this.prefix + "custom_preset (custom_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, preset TEXT COLLATE NOCASE DEFAULT 'custom')";
            this.statement.executeUpdate(queryCustom);
            String queryDeaths = "CREATE TABLE IF NOT EXISTS " + this.prefix + "deaths (uuid TEXT PRIMARY KEY NOT NULL, world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, direction TEXT DEFAULT '', submarine INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryDeaths);
            String queryDestinations = "CREATE TABLE IF NOT EXISTS " + this.prefix + "destinations (dest_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, dest_name TEXT COLLATE NOCASE DEFAULT '', world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, direction TEXT DEFAULT '', preset TEXT DEFAULT '', bind TEXT DEFAULT '', type INTEGER DEFAULT 0, submarine INTEGER DEFAULT 0, slot INTEGER DEFAULT '-1', icon TEXT DEFAULT '', autonomous INTEGER DEFAULT '0')";
            this.statement.executeUpdate(queryDestinations);
            String queryDispersed = "CREATE TABLE IF NOT EXISTS " + this.prefix + "dispersed (d_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, tardis_id INTEGER)";
            this.statement.executeUpdate(queryDispersed);
            String queryDoors = "CREATE TABLE IF NOT EXISTS " + this.prefix + "doors (door_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, door_type INTEGER, door_location TEXT, door_direction TEXT DEFAULT 'SOUTH', locked INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryDoors);
            String queryEyes = "CREATE TABLE IF NOT EXISTS " + this.prefix + "eyes (eye_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, capacitors INTEGER DEFAULT 1, damaged INTEGER DEFAULT 0, task INTEGER DEFAULT -1)";
            this.statement.executeUpdate(queryEyes);
            String queryFarming = "CREATE TABLE IF NOT EXISTS " + this.prefix + "farming (farm_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, allay TEXT DEFAULT '', apiary TEXT DEFAULT '', aquarium TEXT DEFAULT '', bamboo TEXT DEFAULT '', birdcage TEXT DEFAULT '', farm TEXT DEFAULT '', geode TEXT DEFAULT '', happy TEXT DEFAULT '', hutch TEXT DEFAULT '', igloo TEXT DEFAULT '', iistubil TEXT DEFAULT '', lava TEXT DEFAULT '', mangrove TEXT DEFAULT '', nautilus TEXT DEFAULT '', pen TEXT DEFAULT '', stable TEXT DEFAULT '', stall TEXT DEFAULT '', village TEXT DEFAULT '')";
            this.statement.executeUpdate(queryFarming);
            String queryFarmingPrefs = "CREATE TABLE IF NOT EXISTS " + this.prefix + "farming_prefs (farm_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', allay INTEGER DEFAULT 1, apiary INTEGER DEFAULT 1, aquarium INTEGER DEFAULT 1, bamboo INTEGER DEFAULT 1, birdcage INTEGER DEFAULT 1, farm INTEGER DEFAULT 1, geode INTEGER DEFAULT 1, happy INTEGER DEFAULT 1, hutch INTEGER DEFAULT 1, igloo INTEGER DEFAULT 1, iistubil INTEGER DEFAULT 1, lava INTEGER DEFAULT 1, mangrove INTEGER DEFAULT 1, nautilus INTEGER DEFAULT 1, pen INTEGER DEFAULT 1, stable INTEGER DEFAULT 1, stall INTEGER DEFAULT 1, village INTEGER DEFAULT 1)";
            this.statement.executeUpdate(queryFarmingPrefs);
            String queryFlight = "CREATE TABLE IF NOT EXISTS " + this.prefix + "flight (f_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', tardis_id INTEGER, location TEXT DEFAULT '', stand TEXT DEFAULT '', display TEXT DEFAULT '')";
            this.statement.executeUpdate(queryFlight);
            String queryForce = "CREATE TABLE IF NOT EXISTS " + this.prefix + "forcefield (uuid TEXT DEFAULT '', location TEXT DEFAULT '')";
            this.statement.executeUpdate(queryForce);
            String queryGardens = "CREATE TABLE IF NOT EXISTS " + this.prefix + "gardens (garden_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, world TEXT COLLATE NOCASE DEFAULT '', minx INTEGER, maxx INTEGER, y INTEGER, minz INTEGER, maxz INTEGER)";
            this.statement.executeUpdate(queryGardens);
            String queryGravity = "CREATE TABLE IF NOT EXISTS " + this.prefix + "gravity_well (g_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, location TEXT COLLATE NOCASE DEFAULT '', direction INTEGER, distance INTEGER DEFAULT 11, velocity REAL DEFAULT 0.5)";
            this.statement.executeUpdate(queryGravity);
            String queryHappy = "CREATE TABLE IF NOT EXISTS " + this.prefix + "happy (happy_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, slots TEXT COLLATE NOCASE DEFAULT '0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0')";
            this.statement.executeUpdate(queryHappy);
            String queryHomes = "CREATE TABLE IF NOT EXISTS " + this.prefix + "homes (home_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, direction TEXT DEFAULT '', submarine INTEGER DEFAULT 0, preset TEXT DEFAULT '')";
            this.statement.executeUpdate(queryHomes);
            String queryInteractions = "CREATE TABLE IF NOT EXISTS " + this.prefix + "interactions (i_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, uuid TEXT DEFAULT '', control TEXT DEFAULT '', state INTEGER)";
            this.statement.executeUpdate(queryInteractions);
            String queryInventories = "CREATE TABLE IF NOT EXISTS " + this.prefix + "inventories (id INTEGER PRIMARY KEY NOT NULL, uuid TEXT, player TEXT, arch INTEGER, inventory TEXT, armour TEXT, attributes TEXT, armour_attributes TEXT)";
            this.statement.executeUpdate(queryInventories);
            String queryJunk = "CREATE TABLE IF NOT EXISTS " + this.prefix + "junk (id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', tardis_id INTEGER, save_sign TEXT COLLATE NOCASE DEFAULT '', handbrake TEXT COLLATE NOCASE DEFAULT '', wall TEXT DEFAULT 'ORANGE_WOOL', floor TEXT DEFAULT 'LIGHT_GRAY_WOOL', preset TEXT DEFAULT '')";
            this.statement.executeUpdate(queryJunk);
            String queryLamps = "CREATE TABLE IF NOT EXISTS " + this.prefix + "lamps (l_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, location TEXT COLLATE NOCASE DEFAULT '', material_on TEXT DEFAULT '', material_off, percentage REAL DEFAULT 1.0)";
            this.statement.executeUpdate(queryLamps);
            String queryLightPrefs = "CREATE TABLE IF NOT EXISTS " + this.prefix + "light_prefs (lp_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, light TEXT COLLATE NOCASE DEFAULT '', material TEXT COLLATE NOCASE DEFAULT '', pattern TEXT COLLATE NOCASE DEFAULT 'BLUE:GREEN:ORANGE:PINK:PURPLE:YELLOW:RED:WHITE:BLACK', delays TEXT COLLATE NOCASE DEFAULT '20:20:20:20:20:20:20:20:20', levels TEXT COLLATE NOCASE DEFAULT '15:15:15:15:15:15:15:15:15')";
            this.statement.executeUpdate(queryLightPrefs);
            String moversQuery = "CREATE TABLE IF NOT EXISTS " + this.prefix + "movers (uuid TEXT PRIMARY KEY NOT NULL)";
            this.statement.executeUpdate(moversQuery);
            String queryNext = "CREATE TABLE IF NOT EXISTS " + this.prefix + "next (next_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, world TEXT COLLATE NOCASE DEFAULT '', x INTEGER, y INTEGER, z INTEGER, direction TEXT DEFAULT '', submarine INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryNext);
            String queryPaperBag = "CREATE TABLE IF NOT EXISTS " + this.prefix + "paper_bag (paper_bag_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', flavour_1 TEXT DEFAULT '', amount_1 INTEGER, flavour_2 TEXT DEFAULT '', amount_2 INTEGER, flavour_3 TEXT DEFAULT '', amount_3 INTEGER, flavour_4 TEXT DEFAULT '', amount_4 INTEGER)";
            this.statement.executeUpdate(queryPaperBag);
            String queryParticlePrefs = "CREATE TABLE IF NOT EXISTS " + this.prefix + "particle_prefs (pp_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', effect TEXT DEFAULT 'ASH', shape TEXT DEFAULT 'RANDOM', density INTEGER DEFAULT 16, speed INTEGER DEFAULT 0, colour TEXT DEFAULT 'WHITE', block TEXT DEFAULT 'STONE', particles_on INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryParticlePrefs);
            String queryPlayers = "CREATE TABLE IF NOT EXISTS " + this.prefix + "player_prefs (pp_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', player TEXT COLLATE NOCASE DEFAULT '', key TEXT DEFAULT '', sfx_on INTEGER DEFAULT 0, quotes_on INTEGER DEFAULT 0, artron_level INTEGER DEFAULT 0, wall TEXT DEFAULT 'ORANGE_WOOL', floor TEXT DEFAULT 'LIGHT_GRAY_WOOL', siege_wall TEXT DEFAULT 'GRAY_TERRACOTTA', siege_floor TEXT DEFAULT 'BLACK_TERRACOTTA', announce_repeaters_on INTEGER DEFAULT 0, auto_on INTEGER DEFAULT 0, auto_type TEXT DEFAULT 'CLOSEST', auto_default TEXT DEFAULT 'HOME', beacon_on INTEGER DEFAULT 1, hads_on INTEGER DEFAULT 1, hads_type TEXT DEFAULT 'DISPLACEMENT', build_on INTEGER DEFAULT 1, close_gui_on INTEGER DEFAULT 1, eps_on INTEGER DEFAULT 0, eps_message TEXT DEFAULT '', language TEXT DEFAULT 'ENGLISH', submarine_on INTEGER DEFAULT 0, dnd_on INTEGER DEFAULT 0, dynamic_lamps_on INTEGER DEFAULT 0, minecart_on INTEGER DEFAULT 0, renderer_on INTEGER DEFAULT 1, sign_on INTEGER DEFAULT 1, telepathy_on INTEGER DEFAULT 0, travelbar_on INTEGER DEFAULT 0, info_on INTEGER DEFAULT 0, farm_on INTEGER DEFAULT 1, lights TEXT DEFAULT 'TENTH', auto_siege_on INTEGER DEFAULT 0, flying_mode INTEGER DEFAULT 1, throttle INTEGER DEFAULT 4, auto_powerup_on INTEGER DEFAULT 0, auto_rescue_on INTEGER DEFAULT 0, hum TEXT DEFAULT '', regenerations INTEGER DEFAULT 15, regen_block_on INTEGER DEFAULT 0, dialogs_on INTEGER DEFAULT 0, open_display_door_on INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryPlayers);
            String queryPlots = "CREATE TABLE IF NOT EXISTS " + this.prefix + "plots (plot_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', world TEXT COLLATE NOCASE DEFAULT '', chunk_x INTEGER DEFAULT 0, chunk_z INTEGER DEFAULT 0, size INTEGER DEFAULT 3, name TEXT DEFAULT '')";
            this.statement.executeUpdate(queryPlots);
            String queryPortals = "CREATE TABLE IF NOT EXISTS " + this.prefix + "portals (portal_id INTEGER PRIMARY KEY NOT NULL, portal TEXT DEFAULT '', teleport TEXT DEFAULT '', direction TEXT DEFAULT '', tardis_id INTEGER DEFAULT 0, abandoned INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryPortals);
            String queryHandles = "CREATE TABLE IF NOT EXISTS " + this.prefix + "programs (program_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', name TEXT DEFAULT '', inventory TEXT DEFAULT '', parsed TEXT DEFAULT '', checked INTEGER DEFAULT 1)";
            this.statement.executeUpdate(queryHandles);
            String queryReminders = "CREATE TABLE IF NOT EXISTS " + this.prefix + "reminders (reminder_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', reminder TEXT DEFAULT '', time INTEGER DEFAULT '0')";
            this.statement.executeUpdate(queryReminders);
            String queryPreviewers = "CREATE TABLE IF NOT EXISTS " + this.prefix + "previewers (uuid TEXT PRIMARY KEY NOT NULL, world TEXT COLLATE NOCASE DEFAULT '', x REAL DEFAULT 0.0, y REAL DEFAULT 0.0, z REAL DEFAULT 0.0, yaw REAL DEFAULT 0.0, pitch REAL DEFAULT 0.0, gamemode TEXT COLLATE NOCASE DEFAULT '', tardis_id INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryPreviewers);
            String queryRoomProgress = "CREATE TABLE IF NOT EXISTS " + this.prefix + "room_progress (progress_id INTEGER PRIMARY KEY NOT NULL, direction TEXT DEFAULT '', room TEXT DEFAULT '', location TEXT DEFAULT '', tardis_id INTEGER DEFAULT 0, progress_row INTEGER DEFAULT 0, progress_column INTEGER DEFAULT 0, progress_level INTEGER DEFAULT 0, middle_type TEXT DEFAULT '', floor_type TEXT DEFAULT '', post_blocks TEXT DEFAULT '')";
            this.statement.executeUpdate(queryRoomProgress);
            String querySeeds = "CREATE TABLE IF NOT EXISTS " + this.prefix + "seeds (seed_id INTEGER PRIMARY KEY NOT NULL, schematic TEXT DEFAULT '', wall TEXT DEFAULT 'ORANGE_WOOL', floor TEXT DEFAULT 'LIGHT_GRAY_WOOL', location TEXT DEFAULT '')";
            this.statement.executeUpdate(querySeeds);
            String querySensors = "CREATE TABLE IF NOT EXISTS " + this.prefix + "sensors (sensor_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER DEFAULT 0, charging TEXT DEFAULT '', flight TEXT DEFAULT '', handbrake TEXT DEFAULT '', malfunction TEXT DEFAULT '', power TEXT DEFAULT '')";
            this.statement.executeUpdate(querySensors);
            String querySiege = "CREATE TABLE IF NOT EXISTS " + this.prefix + "siege (siege_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', tardis_id INTEGER DEFAULT 0)";
            this.statement.executeUpdate(querySiege);
            String querySkins = "CREATE TABLE IF NOT EXISTS " + this.prefix + "skins (skin_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', skin TEXT DEFAULT '')";
            this.statement.executeUpdate(querySkins);
            String querySonic = "CREATE TABLE IF NOT EXISTS " + this.prefix + "sonic (sonic_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', activated INTEGER DEFAULT 0, bio INTEGER DEFAULT 0, diamond INTEGER DEFAULT 0, emerald INTEGER DEFAULT 0, redstone INTEGER DEFAULT 0, painter INTEGER DEFAULT 0, ignite INTEGER DEFAULT 0, arrow INTEGER DEFAULT 0, knockback INTEGER DEFAULT 0, brush INTEGER DEFAULT 0, conversion INTEGER DEFAULT 0, model INTEGER DEFAULT 10000011, sonic_uuid TEXT DEFAULT '', last_scanned TEXT DEFAULT '', scan_type INTEGER DEFAULT 0)";
            this.statement.executeUpdate(querySonic);
            String s_query = "SELECT sql FROM sqlite_master WHERE tbl_name = '" + this.prefix + "storage'";
            ResultSet rss = this.statement.executeQuery(s_query);
            if (rss.next() && !(rssd = this.statement.executeQuery(sd_query = "SELECT sql FROM sqlite_master WHERE tbl_name = '" + this.prefix + "storage' AND sql LIKE '%console%'")).next()) {
                String s_drop = "DROP TABLE storage";
                this.statement.executeUpdate(s_drop);
            }
            String queryStorage = "CREATE TABLE IF NOT EXISTS " + this.prefix + "storage (storage_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, uuid TEXT DEFAULT '', owner TEXT DEFAULT '', saves_one TEXT DEFAULT '', saves_two TEXT DEFAULT '', areas TEXT DEFAULT '', presets_one TEXT DEFAULT '', presets_two TEXT DEFAULT '', biomes_one TEXT DEFAULT '', biomes_two TEXT DEFAULT '', players TEXT DEFAULT '', circuits TEXT DEFAULT '', console TEXT DEFAULT '', versions TEXT DEFAULT '0,0,0,0,0,0,0,0,0')";
            this.statement.executeUpdate(queryStorage);
            String querySystem = "CREATE TABLE IF NOT EXISTS " + this.prefix + "system_upgrades (sys_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, uuid TEXT DEFAULT '', architecture INTEGER DEFAULT 0, chameleon INTEGER DEFAULT 0, rooms INTEGER DEFAULT 0, desktop INTEGER DEFAULT 0, feature INTEGER DEFAULT 0, saves INTEGER DEFAULT 0, monitor INTEGER DEFAULT 0, force_field INTEGER DEFAULT 0, tools INTEGER DEFAULT 0, locator INTEGER DEFAULT 0, telepathic INTEGER DEFAULT 0, stattenheim_remote INTEGER DEFAULT 0, navigation INTEGER DEFAULT 0, distance_1 INTEGER DEFAULT 0, distance_2 INTEGER DEFAULT 0, distance_3 INTEGER DEFAULT 0, inter_dimension INTEGER DEFAULT 0, throttle INTEGER DEFAULT 0, faster INTEGER DEFAULT 0, rapid INTEGER DEFAULT 0, warp INTEGER DEFAULT 0, flight INTEGER DEFAULT 0)";
            this.statement.executeUpdate(querySystem);
            String queryTag = "CREATE TABLE IF NOT EXISTS " + this.prefix + "tag (tag_id INTEGER PRIMARY KEY NOT NULL, player TEXT COLLATE NOCASE DEFAULT '', time INTEGER)";
            this.statement.executeUpdate(queryTag);
            String queryTARDIS = "CREATE TABLE IF NOT EXISTS " + this.prefix + "tardis (tardis_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', owner TEXT COLLATE NOCASE DEFAULT '', last_known_name TEXT COLLATE NOCASE DEFAULT '', chunk TEXT, tips INTEGER DEFAULT '-1', replaced TEXT DEFAULT '', companions TEXT, chameleon_preset TEXT DEFAULT 'FACTORY', chameleon_demat TEXT DEFAULT 'FACTORY', adapti_on INTEGER DEFAULT 0, size TEXT DEFAULT '', abandoned INTEGER DEFAULT 0, artron_level INTEGER DEFAULT 0, creeper TEXT DEFAULT '', handbrake_on INTEGER DEFAULT 1, tardis_init INTEGER DEFAULT 0, recharging INTEGER DEFAULT 0, hidden INTEGER DEFAULT 0, powered_on INTEGER DEFAULT 0, lights_on INTEGER DEFAULT 1, siege_on INTEGER DEFAULT 0, lastuse INTEGER DEFAULT (strftime('%s', 'now')), iso_on INTEGER DEFAULT 0, beacon TEXT DEFAULT '', eps TEXT DEFAULT '', rail TEXT DEFAULT '', renderer TEXT DEFAULT '', zero TEXT DEFAULT '', rotor TEXT DEFAULT '', monsters INTEGER DEFAULT 0, furnaces INTEGER DEFAULT 0, bedrock INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryTARDIS);
            String queryTransmats = "CREATE TABLE IF NOT EXISTS " + this.prefix + "transmats (transmat_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, name TEXT COLLATE NOCASE DEFAULT '', world TEXT COLLATE NOCASE DEFAULT '', x REAL DEFAULT 0.0, y REAL DEFAULT 0.0, z REAL DEFAULT 0.0, yaw REAL DEFAULT 0.0)";
            this.statement.executeUpdate(queryTransmats);
            String queryTravelStats = "CREATE TABLE IF NOT EXISTS " + this.prefix + "travel_stats (travel_stats_id INTEGER PRIMARY KEY NOT NULL, travel_type TEXT DEFAULT '', tardis_id INTEGER, uuid TEXT DEFAULT '')";
            this.statement.executeUpdate(queryTravelStats);
            String queryTraveledTo = "CREATE TABLE IF NOT EXISTS " + this.prefix + "traveled_to (uuid TEXT NOT NULL, environment TEXT NOT NULL)";
            this.statement.executeUpdate(queryTraveledTo);
            String queryTravellers = "CREATE TABLE IF NOT EXISTS " + this.prefix + "travellers (traveller_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, uuid TEXT DEFAULT '', player TEXT COLLATE NOCASE DEFAULT '')";
            this.statement.executeUpdate(queryTravellers);
            String queryT_Counts = "CREATE TABLE IF NOT EXISTS " + this.prefix + "t_count (t_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', player TEXT COLLATE NOCASE DEFAULT '', count INTEGER DEFAULT 0, grace INTEGER DEFAULT 0, repair INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryT_Counts);
            String queryVaults = "CREATE TABLE IF NOT EXISTS " + this.prefix + "vaults (v_id INTEGER PRIMARY KEY NOT NULL, tardis_id INTEGER, location TEXT COLLATE NOCASE DEFAULT '', chest_type TEXT COLLATE NOCASE DEFAULT 'DROP', x INTEGER DEFAULT 0, y INTEGER DEFAULT 0, z INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryVaults);
            String queryVoid = "CREATE TABLE IF NOT EXISTS " + this.prefix + "thevoid (tardis_id INTEGER PRIMARY KEY NOT NULL)";
            this.statement.executeUpdate(queryVoid);
            String queryVortex = "CREATE TABLE IF NOT EXISTS " + this.prefix + "vortex (tardis_id INTEGER PRIMARY KEY NOT NULL, task INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryVortex);
            String queryItems = "CREATE TABLE IF NOT EXISTS " + this.prefix + "items (item_id INTEGER PRIMARY KEY NOT NULL, item TEXT DEFAULT '', location TEXT DEFAULT '', cost REAL DEFAULT 0)";
            this.statement.executeUpdate(queryItems);
            String querySaves = "CREATE TABLE IF NOT EXISTS " + this.prefix + "saves (save_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', save_name TEXT COLLATE NOCASE DEFAULT '', world TEXT COLLATE NOCASE DEFAULT '', x REAL DEFAULT 0.0, y REAL DEFAULT 0.0, z REAL DEFAULT 0.0, yaw REAL DEFAULT 0.0, pitch REAL DEFAULT 0.0)";
            this.statement.executeUpdate(querySaves);
            String queryMessages = "CREATE TABLE IF NOT EXISTS " + this.prefix + "messages (message_id INTEGER PRIMARY KEY NOT NULL, uuid_to TEXT DEFAULT '', uuid_from TEXT DEFAULT '', message TEXT DEFAULT '', date INTEGER DEFAULT (strftime('%s', 'now')), read INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryMessages);
            String queryBeacons = "CREATE TABLE IF NOT EXISTS " + this.prefix + "beacons (beacon_id INTEGER PRIMARY KEY NOT NULL, uuid TEXT DEFAULT '', location TEXT DEFAULT '', block_data TEXT DEFAULT '')";
            this.statement.executeUpdate(queryBeacons);
            String queryManipulator = "CREATE TABLE IF NOT EXISTS " + this.prefix + "manipulator (uuid TEXT PRIMARY KEY NOT NULL, tachyon_level INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryManipulator);
            String queryOod = "CREATE TABLE IF NOT EXISTS " + this.prefix + "followers (uuid TEXT PRIMARY KEY NOT NULL, owner TEXT, species TEXT DEFAULT '', following INTEGER DEFAULT 0, option INTEGER DEFAULT 0, colour TEXT DEFAULT '', ammo INTEGER DEFAULT 0)";
            this.statement.executeUpdate(queryOod);
            String dropSubmerged = "DROP TABLE IF EXISTS submerged";
            this.statement.executeUpdate(dropSubmerged);
            String dropGravity = "DROP TABLE IF EXISTS gravity";
            this.statement.executeUpdate(dropGravity);
            String dropLevers = "DROP TABLE IF EXISTS levers";
            this.statement.executeUpdate(dropLevers);
            TARDISSQLiteDatabaseUpdater dbu = new TARDISSQLiteDatabaseUpdater(this.plugin, this.statement);
            dbu.updateTables();
            String queryRaisedPreset = "UPDATE " + this.prefix + "tardis SET chameleon_preset = 'SWAMP' WHERE chameleon_preset = 'RAISED'";
            this.statement.executeUpdate(queryRaisedPreset);
            String queryRaisedDemat = "UPDATE " + this.prefix + "tardis SET chameleon_demat = 'SWAMP' WHERE chameleon_demat = 'RAISED'";
            this.statement.executeUpdate(queryRaisedDemat);
        }
        catch (SQLException e) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "SQLite create table error: " + String.valueOf(e));
        }
        finally {
            try {
                if (this.statement != null) {
                    this.statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "SQLite close statement error: " + String.valueOf(e));
            }
        }
    }
}

