/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control.actions;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Lamp;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;

public class LightLevelAction {
    private final TARDIS plugin;

    public LightLevelAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void illuminate(int level, int control, boolean powered, int type, boolean policebox, int id, boolean lightsOn) {
        block6: {
            int setLevel;
            block7: {
                setLevel = level + 1 > 7 ? 0 : level + 1;
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("secondary", setLevel);
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("c_id", control);
                this.plugin.getQueryFactory().doSyncUpdate("controls", set, where);
                if (!powered) break block6;
                if (type != 49) break block7;
                if (!policebox) {
                    return;
                }
                int light_level = LightLevel.exterior_level[setLevel];
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                if (!rsc.resultSet()) break block6;
                Current current = rsc.getCurrent();
                if (current.location().getWorld() == null) {
                    return;
                }
                Location location = current.location();
                while (!location.getChunk().isLoaded()) {
                    location.getChunk().load();
                }
                Block light = location.getBlock().getRelative(BlockFace.UP, 2);
                BlockData blockData = light.getBlockData();
                if (!(blockData instanceof Levelled)) break block6;
                Levelled levelled = (Levelled)blockData;
                levelled.setLevel(light_level);
                light.setBlockData((BlockData)levelled);
                break block6;
            }
            if (lightsOn) {
                int light_level = LightLevel.interior_level[setLevel];
                HashMap<String, Object> whereLight = new HashMap<String, Object>();
                whereLight.put("tardis_id", id);
                ResultSetLamps rsl = new ResultSetLamps(this.plugin, whereLight, true);
                if (rsl.resultSet()) {
                    for (Lamp lamp : rsl.getData()) {
                        Block block = lamp.block();
                        BlockData blockData = block.getBlockData();
                        if (!(blockData instanceof Levelled)) continue;
                        Levelled levelled = (Levelled)blockData;
                        levelled.setLevel(Math.round((float)light_level * lamp.percentage()));
                        block.setBlockData((BlockData)levelled);
                    }
                }
            }
        }
    }
}

