/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.telepathic;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.telepathic.EnvironmentBiomes;
import me.eccentric_nz.TARDIS.custommodels.GUIMap;
import me.eccentric_nz.TARDIS.custommodels.GUIWallFloor;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISTelepathicBiome
implements InventoryHolder {
    private final TARDIS plugin;
    private final int id;
    private final Inventory inventory;

    public TARDISTelepathicBiome(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Telepathic Biome Finder", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getButtons());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getButtons() {
        ItemStack[] stack = new ItemStack[54];
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
        if (rsc.resultSet()) {
            World.Environment environment = rsc.getCurrent().location().getWorld().getEnvironment();
            List<Biome> biomes = switch (environment) {
                case World.Environment.NETHER -> EnvironmentBiomes.NETHER;
                case World.Environment.THE_END -> EnvironmentBiomes.END;
                default -> EnvironmentBiomes.OVERWORLD;
            };
            int i = 0;
            for (Biome biome : biomes) {
                if (i > 52) break;
                Material material = EnvironmentBiomes.BIOME_BLOCKS.get(biome.getKey().getKey());
                if (material == null) continue;
                ItemStack is = ItemStack.of((Material)material, (int)1);
                ItemMeta im = is.getItemMeta();
                im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(biome.getKey().getKey())));
                is.setItemMeta(im);
                stack[i] = is;
                if (i % 9 == 7) {
                    i += 2;
                    continue;
                }
                ++i;
            }
            if (environment == World.Environment.NORMAL) {
                ItemStack scroll_up = ItemStack.of((Material)GUIWallFloor.BUTTON_SCROLL_U.material(), (int)1);
                ItemMeta uim = scroll_up.getItemMeta();
                uim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCROLL_U", "Scroll up")));
                uim.setItemModel(GUIWallFloor.BUTTON_SCROLL_U.key());
                scroll_up.setItemMeta(uim);
                stack[GUIWallFloor.BUTTON_SCROLL_U.slot()] = scroll_up;
                ItemStack scroll_down = ItemStack.of((Material)GUIWallFloor.BUTTON_SCROLL_D.material(), (int)1);
                ItemMeta dim = scroll_down.getItemMeta();
                dim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCROLL_D", "Scroll down")));
                dim.setItemModel(GUIWallFloor.BUTTON_SCROLL_D.key());
                scroll_down.setItemMeta(dim);
                stack[GUIWallFloor.BUTTON_SCROLL_D.slot()] = scroll_down;
            }
        }
        ItemStack close = ItemStack.of((Material)GUIMap.BUTTON_CLOSE.material(), (int)1);
        ItemMeta gui = close.getItemMeta();
        gui.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        gui.setItemModel(GUIMap.BUTTON_CLOSE.key());
        close.setItemMeta(gui);
        stack[53] = close;
        return stack;
    }
}

