/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console;

import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.ColourType;
import me.eccentric_nz.TARDIS.custommodels.GUIArs;
import me.eccentric_nz.TARDIS.custommodels.GUICompanion;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CustomiseConsoleInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Inventory inventory;

    public CustomiseConsoleInventory(TARDIS plugin) {
        this.plugin = plugin;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Customise Console", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] consoles = new ItemStack[54];
        ItemStack info = ItemStack.of((Material)Material.BOOK, (int)1);
        ItemMeta info_im = info.getItemMeta();
        info_im.displayName((Component)Component.text((String)"Instructions"));
        info_im.lore(List.of(Component.text((String)"Choose your desired time rotor"), Component.text((String)"Choose your desired console"), Component.text((String)"Click on the Save button"), Component.text((String)"to apply your choices.")));
        info.setItemMeta(info_im);
        consoles[0] = info;
        int r = 9;
        for (Map.Entry<String, Rotor> rotor : Rotor.byName.entrySet()) {
            ItemStack is = ItemStack.of((Material)Material.LIGHT_GRAY_DYE);
            ItemMeta im = is.getItemMeta();
            im.setItemModel(rotor.getValue().offModel());
            im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(rotor.getKey())));
            is.setItemMeta(im);
            consoles[r] = is;
            if (++r <= 17) continue;
            break;
        }
        ItemStack scroll_left = ItemStack.of((Material)GUIArs.BUTTON_SCROLL_L.material(), (int)1);
        ItemMeta nim = scroll_left.getItemMeta();
        nim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCROLL_L", "Scroll left")));
        scroll_left.setItemMeta(nim);
        consoles[18] = scroll_left;
        ItemStack scroll_right = ItemStack.of((Material)GUIArs.BUTTON_SCROLL_R.material(), (int)1);
        ItemMeta pim = scroll_right.getItemMeta();
        pim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCROLL_R", "Scroll right")));
        scroll_right.setItemMeta(pim);
        consoles[26] = scroll_right;
        int c = 27;
        for (Map.Entry<Material, NamespacedKey> colour : ColourType.BY_MATERIAL.entrySet()) {
            String name = colour.getValue().getKey().replace("console_", "");
            ItemStack is = ItemStack.of((Material)colour.getKey(), (int)1);
            ItemMeta im = is.getItemMeta();
            String dn = TARDISStringUtils.capitalise(name) + " Console";
            im.displayName((Component)ComponentUtils.toWhite(dn));
            is.setItemMeta(im);
            consoles[c] = is;
            if (++c <= 35) continue;
            break;
        }
        consoles[36] = scroll_left;
        consoles[44] = scroll_right;
        ItemStack save = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta se = save.getItemMeta();
        se.displayName((Component)Component.text((String)"Save"));
        save.setItemMeta(se);
        consoles[49] = save;
        ItemStack close = ItemStack.of((Material)GUICompanion.BUTTON_CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        consoles[GUICompanion.BUTTON_CLOSE.slot()] = close;
        return consoles;
    }
}

