/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.commands.utils.ArgumentParser;
import me.eccentric_nz.TARDIS.commands.utils.Arguments;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TARDISTravelCoords {
    private final TARDIS plugin;

    public TARDISTravelCoords(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean action(Player player, String[] args, int id) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        ArgumentParser parser = new ArgumentParser();
        String command = parser.join(args);
        Arguments arguments = parser.parse(command);
        switch (arguments.getArguments().size()) {
            case 2: {
                if (args[0].equalsIgnoreCase("random")) {
                    World world = TARDISAliasResolver.getWorldFromAlias(arguments.getArguments().get(1));
                    if (world == null) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COULD_NOT_FIND_WORLD");
                        return true;
                    }
                    if (!this.plugin.getPlanetsConfig().getBoolean("planets." + world.getName() + ".time_travel")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                        return true;
                    }
                    List<String> worlds = List.of(world.getName());
                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                    if (rsc.resultSet()) {
                        Parameters parameters = new Parameters(player, Flag.getNoMessageFlags());
                        parameters.setCompass(rsc.getCurrent().direction());
                        Location l = this.plugin.getTardisAPI().getRandomLocation(worlds, world.getEnvironment(), parameters);
                        if (l == null) break;
                        set.put("world", l.getWorld().getName());
                        set.put("x", l.getBlockX());
                        set.put("y", l.getBlockY());
                        set.put("z", l.getBlockZ());
                        set.put("submarine", 0);
                        this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                        this.plugin.getMessenger().send(player, "LOC_SAVED", true);
                        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.RANDOM));
                        this.plugin.getTrackerKeeper().getRescue().remove(id);
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                            new TARDISLand(this.plugin, id, player).exitVortex();
                            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RANDOM, id));
                        }
                        return true;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                    return true;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_COORDS");
                return false;
            }
            case 3: {
                if (args[0].startsWith("~")) {
                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                    if (!rsc.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                        return true;
                    }
                    Current current = rsc.getCurrent();
                    if (!this.plugin.getPlanetsConfig().getBoolean("planets." + current.location().getWorld().getName() + ".time_travel")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
                        return true;
                    }
                    if (current.submarine()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SUB_NO_CMD");
                        return true;
                    }
                    int rx = this.getRelativeCoordinate(args[0]);
                    int ry = this.getRelativeCoordinate(args[1]);
                    int rz = this.getRelativeCoordinate(args[2]);
                    if (rx == Integer.MAX_VALUE || ry == Integer.MAX_VALUE || rz == Integer.MAX_VALUE) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RELATIVE_NOT_FOUND");
                        return true;
                    }
                    int x = current.location().getBlockX() + rx;
                    int y = current.location().getBlockY() + ry;
                    int z = current.location().getBlockZ() + rz;
                    World.Environment environment = player.getWorld().getEnvironment();
                    if (y < -64 || environment.equals((Object)World.Environment.NORMAL) && y > 310 || !environment.equals((Object)World.Environment.NORMAL) && y > 240) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "Y_NOT_VALID");
                        return true;
                    }
                    Location location = new Location(current.location().getWorld(), (double)x, (double)y, (double)z);
                    int count = this.checkLocation(location, player, id);
                    if (count > 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                    } else {
                        set.put("world", location.getWorld().getName());
                        set.put("x", location.getBlockX());
                        set.put("y", location.getBlockY());
                        set.put("z", location.getBlockZ());
                        set.put("submarine", 0);
                        this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                        this.plugin.getMessenger().send(player, "LOC_SAVED", true);
                        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.RELATIVE_COORDINATES));
                        this.plugin.getTrackerKeeper().getRescue().remove(id);
                        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                            new TARDISLand(this.plugin, id, player).exitVortex();
                            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.RELATIVE_COORDINATES, id));
                        }
                    }
                    return true;
                }
                Location determiney = this.getCoordinateLocation(args, player, id);
                if (determiney == null) break;
                int count = this.checkLocation(determiney, player, id);
                if (count > 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                } else {
                    set.put("world", determiney.getWorld().getName());
                    set.put("x", determiney.getBlockX());
                    set.put("y", determiney.getBlockY());
                    set.put("z", determiney.getBlockZ());
                    set.put("submarine", 0);
                    this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                    this.plugin.getMessenger().send(player, "LOC_SAVED", true);
                    this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.COORDINATES));
                    this.plugin.getTrackerKeeper().getRescue().remove(id);
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                        new TARDISLand(this.plugin, id, player).exitVortex();
                        this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.COORDINATES, id));
                    }
                }
                return true;
            }
            default: {
                Location giveny = this.getCoordinateLocation(args, player, id);
                if (giveny == null) break;
                int count = this.checkLocation(giveny, player, id);
                if (count > 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_SAFE");
                } else {
                    set.put("world", giveny.getWorld().getName());
                    set.put("x", giveny.getBlockX());
                    set.put("y", giveny.getBlockY());
                    set.put("z", giveny.getBlockZ());
                    set.put("submarine", 0);
                    this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                    this.plugin.getMessenger().send(player, "LOC_SAVED", true);
                    this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.COORDINATES));
                    this.plugin.getTrackerKeeper().getRescue().remove(id);
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                        new TARDISLand(this.plugin, id, player).exitVortex();
                        this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.COORDINATES, id));
                    }
                }
                return true;
            }
        }
        return true;
    }

    private int getRelativeCoordinate(String arg) {
        if (arg.startsWith("~")) {
            String value = arg.substring(1);
            if (value.isEmpty()) {
                return 0;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException nfe) {
                this.plugin.debug("Could not convert relative coordinate! " + nfe.getMessage());
                return Integer.MAX_VALUE;
            }
        }
        return Integer.MAX_VALUE;
    }

    private int checkLocation(Location location, Player player, int id) {
        if (location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && location.getY() > 127.0) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NETHER");
            return 1;
        }
        if (this.plugin.getTardisArea().isInExistingArea(location)) {
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "TRAVEL_IN_AREA", "/tardistravel area [area name]", this.plugin);
            return 1;
        }
        if (!this.plugin.getPluginRespect().getRespect(location, new Parameters(player, Flag.getDefaultFlags()))) {
            return 1;
        }
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
            return 1;
        }
        int[] start_loc = TARDISTimeTravel.getStartLocation(location, rsc.getCurrent().direction());
        return TARDISTimeTravel.safeLocation(start_loc[0], location.getBlockY(), start_loc[2], start_loc[1], start_loc[3], location.getWorld(), rsc.getCurrent().direction());
    }

    private Location getCoordinateLocation(String[] args, Player player, int id) {
        int max;
        int y;
        int x;
        World w;
        ArgumentParser parser = new ArgumentParser();
        String command = parser.join(args);
        Arguments arguments = parser.parse(command);
        String w_str = arguments.getArguments().getFirst();
        if (TARDISNumberParsers.isSimpleNumber(arguments.getArguments().getFirst())) {
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "WORLD_NOT_FOUND", "/tardisworld", this.plugin);
            return null;
        }
        int size = arguments.getArguments().size();
        if (size < 3) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARG_COORDS");
            return null;
        }
        if (arguments.getArguments().get(1).startsWith("~")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_RELATIVE");
            return null;
        }
        if (arguments.getArguments().getFirst().equals("~")) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return null;
            }
            w = rsc.getCurrent().location().getWorld();
        } else {
            w = !this.plugin.getPlanetsConfig().getBoolean("planets." + w_str + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getWorld(w_str) : TARDISAliasResolver.getWorldFromAlias(w_str);
        }
        if (w == null) {
            this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "WORLD_NOT_FOUND", "/tardisworld", this.plugin);
            return null;
        }
        if (!this.plugin.getPlanetsConfig().getBoolean("planets." + w.getName() + ".time_travel")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
            return null;
        }
        if (!this.plugin.getConfig().getBoolean("travel.include_default_world") && this.plugin.getConfig().getBoolean("creation.default_world") && arguments.getArguments().getFirst().equals(this.plugin.getConfig().getString("creation.default_world_name"))) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_WORLD_TRAVEL");
            return null;
        }
        int z = TARDISNumberParsers.parseInt(arguments.getArguments().get(size - 1));
        if (size > 3) {
            x = TARDISNumberParsers.parseInt(arguments.getArguments().get(size - 3));
            y = TARDISNumberParsers.parseInt(arguments.getArguments().get(size - 2));
            if (y < -64 || w.getEnvironment().equals((Object)World.Environment.NORMAL) && y > 310 || !w.getEnvironment().equals((Object)World.Environment.NORMAL) && y > 240) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "Y_NOT_VALID");
                return null;
            }
        } else {
            x = TARDISNumberParsers.parseInt(arguments.getArguments().get(size - 2));
            Chunk chunk = w.getChunkAt(x, z);
            while (!chunk.isLoaded()) {
                chunk.load();
            }
            y = w.getEnvironment().equals((Object)World.Environment.NETHER) ? TARDISStaticLocationGetters.getNetherHighest(new Location(w, (double)x, 240.0, (double)z)) : TARDISStaticLocationGetters.getHighestYin3x3(w, x, z);
        }
        if (x > (max = Math.min(this.plugin.getConfig().getInt("travel.max_distance"), (int)(w.getWorldBorder().getSize() / 2.0) - 17)) || x < -max || z > max || z < -max) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "XZ_NOT_VALID");
            return null;
        }
        return new Location(w, (double)x, (double)y, (double)z);
    }
}

