/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelArea;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelAsk;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelBack;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelBiome;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelCancel;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelCave;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelCoords;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelCosts;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelExile;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelGUI;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelHome;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelPlayer;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelSave;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelStop;
import me.eccentric_nz.TARDIS.commands.travel.TARDISTravelStructure;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISTravelCommands
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISTravelCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardistravel")) {
            if (sender instanceof Player) {
                Player player = (Player)sender;
                if (!TARDISPermission.hasPermission(player, "tardis.timetravel")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                    return true;
                }
                if (args.length < 1) {
                    new TARDISCommandHelper(this.plugin).getCommand("tardistravel", sender);
                    return true;
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", player.getUniqueId().toString());
                ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
                if (!rs.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                    return true;
                }
                Tardis tardis = rs.getTardis();
                int id = tardis.getTardisId();
                if (args[0].equalsIgnoreCase("cancel")) {
                    return new TARDISTravelCancel(this.plugin).action(player, id);
                }
                if (args[0].equalsIgnoreCase("costs")) {
                    return new TARDISTravelCosts(this.plugin).action(player);
                }
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CMD");
                    return true;
                }
                if (args.length == 1 && args[0].equalsIgnoreCase("stop")) {
                    return new TARDISTravelStop(this.plugin).action(player, id);
                }
                int level = tardis.getArtronLevel();
                boolean powered = tardis.isPoweredOn();
                if (!tardis.isHandbrakeOn() && !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                    return true;
                }
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("uuid", player.getUniqueId().toString());
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
                boolean isCommunicatorOrInventory = args[args.length - 1].equals("kzsbtr1h2");
                if (!rst.resultSet() && !isCommunicatorOrInventory) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
                    return true;
                }
                int tardis_id = rst.getTardis_id();
                if (tardis_id != id && !isCommunicatorOrInventory) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CMD_ONLY_TL");
                    return true;
                }
                if (this.plugin.getConfig().getBoolean("allow.power_down") && !powered) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                    return true;
                }
                int travel = this.plugin.getArtronConfig().getInt("travel");
                if (level < travel) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                    return true;
                }
                if (TARDISPermission.hasPermission(player, "tardis.exile") && this.plugin.getConfig().getBoolean("travel.exile")) {
                    return new TARDISTravelExile(this.plugin).action(player, id);
                }
                if (isCommunicatorOrInventory) {
                    switch (args[0].toLowerCase(Locale.ROOT)) {
                        case "home": {
                            return new TARDISTravelHome(this.plugin).action(player, id);
                        }
                        case "area": {
                            return new TARDISTravelArea(this.plugin).action(player, args, id, tardis.getPreset());
                        }
                        case "cave": {
                            return new TARDISTravelCave(this.plugin).action(player, id);
                        }
                        case "village": {
                            return new TARDISTravelGUI(this.plugin).open(player, id, args[0].toLowerCase(Locale.ROOT));
                        }
                        case "biome": {
                            return new TARDISTravelBiome(this.plugin).action(player, args, id);
                        }
                        case "dest": {
                            return new TARDISTravelSave(this.plugin).action(player, args, id, tardis.getPreset());
                        }
                    }
                    return new TARDISTravelPlayer(this.plugin).action(player, args[0], id);
                }
                if (args.length == 1) {
                    switch (args[0].toLowerCase(Locale.ROOT)) {
                        case "cancel": {
                            return new TARDISTravelCancel(this.plugin).action(player, id);
                        }
                        case "costs": {
                            return new TARDISTravelCosts(this.plugin).action(player);
                        }
                        case "home": {
                            return new TARDISTravelHome(this.plugin).action(player, id);
                        }
                        case "back": {
                            return new TARDISTravelBack(this.plugin).action(player, id);
                        }
                        case "cave": {
                            return new TARDISTravelCave(this.plugin).action(player, id);
                        }
                        case "village": 
                        case "structure": 
                        case "biome": {
                            return new TARDISTravelGUI(this.plugin).open(player, id, args[0].toLowerCase(Locale.ROOT));
                        }
                    }
                    return new TARDISTravelPlayer(this.plugin).action(player, args[0], id);
                }
                if (args.length == 2 && (args[0].equalsIgnoreCase("structure") || args[0].equalsIgnoreCase("village"))) {
                    return new TARDISTravelStructure(this.plugin).action(player, args, id);
                }
                if (args.length == 2 && args[0].equalsIgnoreCase("player")) {
                    return new TARDISTravelPlayer(this.plugin).action(player, args[1], id);
                }
                if (args.length == 2 && (args[1].equals("?") || args[1].equalsIgnoreCase("tpa"))) {
                    return new TARDISTravelAsk(this.plugin).action(player, args);
                }
                if (args.length == 2 && args[0].equalsIgnoreCase("biome")) {
                    return new TARDISTravelBiome(this.plugin).action(player, args, id);
                }
                if (args.length == 2 && (args[0].equalsIgnoreCase("dest") || args[0].equalsIgnoreCase("save"))) {
                    return new TARDISTravelSave(this.plugin).action(player, args, id, tardis.getPreset());
                }
                if (args.length == 2 && args[0].equalsIgnoreCase("area")) {
                    return new TARDISTravelArea(this.plugin).action(player, args, id, tardis.getPreset());
                }
                if (!TARDISPermission.hasPermission(player, "tardis.timetravel.location")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_COORDS");
                    return true;
                }
                return new TARDISTravelCoords(this.plugin).action(player, args, id);
            }
            return false;
        }
        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
        return true;
    }
}

