/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.travel.TARDISCaveFinder;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TARDISTravelCave {
    private final TARDIS plugin;

    public TARDISTravelCave(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean action(Player player, int id) {
        Location cave;
        if (!TARDISPermission.hasPermission(player, "tardis.timetravel.cave")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_CAVE");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.TELEPATHIC_CIRCUIT)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Telepathic Circuit");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
            TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (!tcc.hasTelepathic()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TELEPATHIC_CIRCUIT");
                return true;
            }
        }
        if ((cave = new TARDISCaveFinder(this.plugin).searchCave(player, id)) == null) {
            this.plugin.getMessenger().sendStatus(player, "CAVE_NOT_FOUND");
            return true;
        }
        if (!this.plugin.getPluginRespect().getRespect(cave, new Parameters(player, Flag.getDefaultFlags()))) {
            if (this.plugin.getConfig().getBoolean("travel.no_destination_malfunctions")) {
                this.plugin.getTrackerKeeper().getMalfunction().put(id, true);
            } else {
                return true;
            }
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("world", cave.getWorld().getName());
        set.put("x", cave.getBlockX());
        set.put("y", cave.getBlockY());
        set.put("z", cave.getBlockZ());
        set.put("submarine", 0);
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_LOADED", "Cave", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
        this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.CAVE));
        this.plugin.getTrackerKeeper().getRescue().remove(id);
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            new TARDISLand(this.plugin, id, player).exitVortex();
            this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.CAVE, id));
        }
        return true;
    }
}

