/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetNextLocation;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

class TARDISHandlesScanCommand {
    private final TARDIS plugin;
    private final Player player;
    private final int id;
    private final boolean inTARDIS;

    TARDISHandlesScanCommand(TARDIS plugin, Player player, int id) {
        this.plugin = plugin;
        this.player = player;
        this.id = id;
        this.inTARDIS = plugin.getUtils().inTARDISWorld(this.player);
    }

    boolean sayScan() {
        String whereIsIt;
        COMPASS tardisDirection;
        Location scan_loc;
        TARDISSounds.playTARDISSound(this.player.getLocation(), "handles_scanner");
        if (this.inTARDIS) {
            if (this.plugin.getTrackerKeeper().getHasDestination().containsKey(this.id)) {
                ResultSetNextLocation rsn = new ResultSetNextLocation(this.plugin, this.id);
                if (!rsn.resultSet()) {
                    this.plugin.getMessenger().handlesSend(this.player, "NEXT_NOT_FOUND");
                    return true;
                }
                scan_loc = new Location(rsn.getWorld(), (double)rsn.getX(), (double)rsn.getY(), (double)rsn.getZ());
                tardisDirection = rsn.getDirection();
                whereIsIt = this.plugin.getLanguage().getString("SCAN_NEXT");
            } else {
                ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
                if (!rsc.resultSet()) {
                    this.plugin.getMessenger().handlesSend(this.player, "CURRENT_NOT_FOUND");
                    return true;
                }
                Current current = rsc.getCurrent();
                scan_loc = current.location();
                tardisDirection = current.direction();
                whereIsIt = this.plugin.getLanguage().getString("SCAN_CURRENT");
            }
        } else {
            scan_loc = this.player.getLocation();
            tardisDirection = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(this.player, false));
            whereIsIt = this.plugin.getLanguage().getString("SCAN_PLAYER");
        }
        HashMap<EntityType, Integer> scannedEntities = new HashMap<EntityType, Integer>();
        ArrayList<String> playerNames = new ArrayList<String>();
        for (Entity k : TARDISScanner.getNearbyEntities(scan_loc, 16)) {
            EntityType et = k.getType();
            if (!TARDISConstants.ENTITY_TYPES.contains(et)) continue;
            boolean visible = true;
            if (et.equals((Object)EntityType.PLAYER)) {
                Player entPlayer = (Player)k;
                if (this.player.canSee(entPlayer)) {
                    playerNames.add(entPlayer.getName());
                } else {
                    visible = false;
                }
            }
            if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
                EntityEquipment ee;
                if ((et.equals((Object)EntityType.SKELETON) || et.equals((Object)EntityType.ZOMBIE) || et.equals((Object)EntityType.ZOMBIFIED_PIGLIN)) && (ee = ((LivingEntity)k).getEquipment()).getHelmet() != null) {
                    switch (ee.getHelmet().getType()) {
                        case BAKED_POTATO: {
                            et = EntityType.EGG;
                            break;
                        }
                        case BOOK: {
                            et = EntityType.END_CRYSTAL;
                            break;
                        }
                        case CRIMSON_BUTTON: {
                            et = EntityType.BLOCK_DISPLAY;
                            break;
                        }
                        case FEATHER: {
                            et = EntityType.JUNGLE_BOAT;
                            break;
                        }
                        case IRON_INGOT: {
                            et = EntityType.AREA_EFFECT_CLOUD;
                            break;
                        }
                        case KELP: {
                            et = EntityType.EXPERIENCE_BOTTLE;
                            break;
                        }
                        case MANGROVE_PROPAGULE: {
                            et = EntityType.SMALL_FIREBALL;
                            break;
                        }
                        case NETHERITE_SCRAP: {
                            et = EntityType.GLOW_ITEM_FRAME;
                            break;
                        }
                        case PAINTING: {
                            et = EntityType.FISHING_BOBBER;
                            break;
                        }
                        case POTATO: {
                            et = EntityType.FIREWORK_ROCKET;
                            break;
                        }
                        case PUFFERFISH: {
                            et = EntityType.INTERACTION;
                            break;
                        }
                        case RED_CANDLE: {
                            et = EntityType.TEXT_DISPLAY;
                            break;
                        }
                        case SLIME_BALL: {
                            et = EntityType.LLAMA_SPIT;
                            break;
                        }
                        case SNOWBALL: {
                            et = EntityType.SNOWBALL;
                            break;
                        }
                        case SPIDER_EYE: {
                            et = EntityType.ITEM_DISPLAY;
                            break;
                        }
                        case STONE_BUTTON: {
                            et = EntityType.DRAGON_FIREBALL;
                            break;
                        }
                        case SUGAR: {
                            et = EntityType.FALLING_BLOCK;
                            break;
                        }
                        case TURTLE_EGG: {
                            et = EntityType.ARROW;
                            break;
                        }
                    }
                }
                if (et.equals((Object)EntityType.ENDERMAN) && !k.getPassengers().isEmpty() && k.getPassengers().getFirst() != null && ((Entity)k.getPassengers().getFirst()).getType().equals((Object)EntityType.GUARDIAN)) {
                    et = EntityType.SPLASH_POTION;
                }
                if (et.equals((Object)EntityType.ARMOR_STAND) && (ee = ((ArmorStand)k).getEquipment()).getHelmet() != null) {
                    switch (ee.getHelmet().getType()) {
                        case YELLOW_DYE: {
                            et = EntityType.SHULKER_BULLET;
                            break;
                        }
                        case BONE: {
                            et = EntityType.EVOKER_FANGS;
                            break;
                        }
                        case ROTTEN_FLESH: {
                            et = EntityType.ITEM_FRAME;
                            break;
                        }
                        case GUNPOWDER: {
                            et = EntityType.ITEM;
                            break;
                        }
                    }
                }
            }
            Integer entity_count = scannedEntities.getOrDefault(et, 0);
            if (!visible) continue;
            scannedEntities.put(et, entity_count + 1);
        }
        long time = scan_loc.getWorld().getTime();
        String daynight = TARDISStaticUtils.getTime(time);
        if (this.inTARDIS) {
            this.plugin.getMessenger().handlesSend(this.player, "SCAN_RESULT", whereIsIt);
        } else {
            this.plugin.getMessenger().handlesSend(this.player, "SCAN_PLAYER");
        }
        String worldname = !this.plugin.getPlanetsConfig().getBoolean("planets." + scan_loc.getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(scan_loc.getWorld()) : TARDISAliasResolver.getWorldAlias(scan_loc.getWorld());
        this.plugin.getMessenger().handlesSend(this.player, "SCAN_WORLD", worldname);
        this.plugin.getMessenger().handlesSend(this.player, "SONIC_COORDS", scan_loc.getBlockX() + ":" + scan_loc.getBlockY() + ":" + scan_loc.getBlockZ());
        BukkitScheduler bsched = this.plugin.getServer().getScheduler();
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().handlesSend(this.player, "SCAN_DIRECTION", tardisDirection.toString()), 20L);
        String biome = scan_loc.getBlock().getBiome().getKey().value().toUpperCase(Locale.ROOT);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().handlesSend(this.player, "BIOME_TYPE", biome), 40L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().handlesSend(this.player, "SCAN_TIME", daynight + " / " + time), 60L);
        String weather = switch (biome) {
            case "DESERT", "DESERT_HILLS", "DESERT_LAKES", "SAVANNA", "SAVANNA_PLATEAU", "SHATTERED_SAVANNA", "SHATTERED_SAVANNA_PLATEAU", "BADLANDS", "BADLANDS_PLATEAU", "ERODED_BADLANDS", "MODIFIED_BADLANDS_PLATEAU", "MODIFIED_WOODED_BADLANDS_PLATEAU", "WOODED_BADLANDS_PLATEAU" -> this.plugin.getLanguage().getString("WEATHER_DRY");
            case "SNOWY_TUNDRA", "ICE_SPIKES", "FROZEN_OCEAN", "FROZEN_RIVER", "SNOWY_BEACH", "SNOWY_TAIGA", "SNOWY_MOUNTAINS", "SNOWY_TAIGA_HILLS", "SNOWY_TAIGA_MOUNTAINS" -> {
                if (scan_loc.getWorld().hasStorm()) {
                    yield this.plugin.getLanguage().getString("WEATHER_SNOW");
                }
                yield this.plugin.getLanguage().getString("WEATHER_COLD");
            }
            default -> scan_loc.getWorld().hasStorm() ? this.plugin.getLanguage().getString("WEATHER_RAIN") : this.plugin.getLanguage().getString("WEATHER_CLEAR");
        };
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().handlesSend(this.player, "SCAN_WEATHER", weather), 80L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().handlesSend(this.player, "SCAN_HUMIDITY", String.format("%.2f", scan_loc.getBlock().getHumidity())), 100L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getMessenger().handlesSend(this.player, "SCAN_TEMP", String.format("%.2f", scan_loc.getBlock().getTemperature())), 120L);
        bsched.scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            if (!scannedEntities.isEmpty()) {
                this.plugin.getMessenger().handlesSend(this.player, "SCAN_ENTS");
                scannedEntities.forEach((ent, value) -> {
                    Object message = "";
                    StringBuilder buf = new StringBuilder();
                    if (ent.equals((Object)EntityType.PLAYER) && !playerNames.isEmpty()) {
                        playerNames.forEach(p -> buf.append(", ").append((String)p));
                        message = " (" + buf.substring(2) + ")";
                    }
                    String m = message;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        switch (ent) {
                            case AREA_EFFECT_CLOUD: {
                                this.player.sendMessage("    Cyberman: " + value);
                                break;
                            }
                            case ARROW: {
                                this.player.sendMessage("    Slitheen: " + value);
                                break;
                            }
                            case BLOCK_DISPLAY: {
                                this.player.sendMessage("    Davros: " + value);
                                break;
                            }
                            case JUNGLE_BOAT: {
                                this.player.sendMessage("    Silurian: " + value);
                                break;
                            }
                            case DRAGON_FIREBALL: {
                                this.player.sendMessage("    Weeping Angel: " + value);
                                break;
                            }
                            case ITEM: {
                                this.player.sendMessage("    Toclafane: " + value);
                                break;
                            }
                            case EGG: {
                                this.player.sendMessage("    Strax: " + value);
                                break;
                            }
                            case END_CRYSTAL: {
                                this.player.sendMessage("    Vashta Nerada: " + value);
                                break;
                            }
                            case EVOKER_FANGS: {
                                this.player.sendMessage("    K9: " + value);
                                break;
                            }
                            case FALLING_BLOCK: {
                                this.player.sendMessage("    Empty Child: " + value);
                                break;
                            }
                            case FIREWORK_ROCKET: {
                                this.player.sendMessage("    Sontaran: " + value);
                                break;
                            }
                            case FISHING_BOBBER: {
                                this.player.sendMessage("    Zygon: " + value);
                                break;
                            }
                            case GLOW_ITEM_FRAME: {
                                this.player.sendMessage("    Mire: " + value);
                                break;
                            }
                            case INTERACTION: {
                                this.player.sendMessage("    Hath: " + value);
                                break;
                            }
                            case ITEM_DISPLAY: {
                                this.player.sendMessage("    Racnoss: " + value);
                                break;
                            }
                            case ITEM_FRAME: {
                                this.player.sendMessage("    Ood: " + value);
                                break;
                            }
                            case LLAMA_SPIT: {
                                this.player.sendMessage("    Dalek: " + value);
                                break;
                            }
                            case SHULKER_BULLET: {
                                this.player.sendMessage("    Judoon: " + value);
                                break;
                            }
                            case SMALL_FIREBALL: {
                                this.player.sendMessage("    Dalek Sec: " + value);
                                break;
                            }
                            case SNOWBALL: {
                                this.player.sendMessage("    Ice Warrior: " + value);
                                break;
                            }
                            case SPLASH_POTION: {
                                this.player.sendMessage("    Silent: " + value);
                                break;
                            }
                            case TEXT_DISPLAY: {
                                this.player.sendMessage("    Headless Monk: " + value);
                                break;
                            }
                            case EXPERIENCE_BOTTLE: {
                                this.player.sendMessage("    Sea Devil: " + value);
                                break;
                            }
                            default: {
                                this.player.sendMessage("    " + String.valueOf(ent) + ": " + value + m);
                            }
                        }
                    }, 3L);
                });
                scannedEntities.clear();
            } else {
                this.plugin.getMessenger().handlesSend(this.player, "SCAN_NONE");
            }
            DamageUtility.run(this.plugin, DiskCircuit.SCANNER, this.id, this.player);
        }, 140L);
        return true;
    }
}

