/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.wiki;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;

public class PageBuilder {
    private final TARDIS plugin;

    public PageBuilder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void save(String filename, String contents) {
        boolean result;
        File wikiDir = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "wiki");
        if (!wikiDir.exists() && (result = wikiDir.mkdir()) && wikiDir.setWritable(true) && wikiDir.setExecutable(true)) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Created wiki directory.");
        }
        File file = new File(String.valueOf(this.plugin.getDataFolder()) + File.separator + "wiki" + File.separator + TARDISStringUtils.toLowercaseDashed(filename) + ".mdx");
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
            bw.write(contents);
        }
        catch (IOException e) {
            this.plugin.debug("Could not create and write to " + filename + "! " + e.getMessage());
        }
    }

    public String getLink(RecipeChoice choice) {
        Object ingredient;
        String MINECRAFT;
        String link = MINECRAFT = "[%s](https://minecraft.wiki/w/%s)";
        if (choice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice mat = (RecipeChoice.MaterialChoice)choice;
            ingredient = TARDISStringUtils.capitalise(((Material)mat.getChoices().getFirst()).toString());
            link = String.format(MINECRAFT, ingredient, ((String)ingredient).replaceAll(" ", "_"));
        }
        if (choice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)choice;
            ItemStack is = exact.getItemStack();
            switch (is.getType()) {
                case POTION: {
                    PotionMeta pm = (PotionMeta)is.getItemMeta();
                    String potion = pm.getBasePotionType().name();
                    ingredient = "Potion of " + TARDISStringUtils.capitalise(potion);
                    link = String.format(MINECRAFT, ingredient, ((String)ingredient).replaceAll(" ", "_"));
                    break;
                }
                case ENCHANTED_BOOK: {
                    EnchantmentStorageMeta bm = (EnchantmentStorageMeta)is.getItemMeta();
                    String enchant = bm.getEnchants().keySet().stream().findFirst().toString();
                    String cap = TARDISStringUtils.capitalise(enchant);
                    ingredient = "Enchanted Book of " + cap;
                    link = String.format(MINECRAFT, ingredient, ((String)ingredient).replaceAll(" ", "_"));
                    break;
                }
                default: {
                    ItemMeta im = is.getItemMeta();
                    String dn = ComponentUtils.stripColour(im.displayName());
                    RecipeItem recipeItem = RecipeItem.getByName(dn);
                    String folder = recipeItem.getCategory().toString().toLowerCase(Locale.ROOT);
                    String WIKI = "[%s](/recipes/%s/%s)";
                    link = String.format(WIKI, folder, dn, TARDISStringUtils.toLowercaseDashed(dn));
                }
            }
        }
        return link;
    }
}

