/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.TARDISRoomMap;
import me.eccentric_nz.TARDIS.rooms.RoomRequiredLister;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISRoomCommands
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISRoomCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisroom")) {
            if (args.length < 2) {
                new TARDISCommandHelper(this.plugin).getCommand("tardisroom", sender);
                return true;
            }
            switch (args[0].toLowerCase(Locale.ROOT)) {
                case "blocks": {
                    String name = args[1].toUpperCase(Locale.ROOT);
                    Set rooms = this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false);
                    if (name.equals("SAVE")) {
                        if (!sender.hasPermission("tardis.admin")) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                            return false;
                        }
                        rooms.forEach(r -> {
                            if (this.plugin.getRoomsConfig().getBoolean("rooms." + name + ".enabled")) {
                                HashMap<String, Integer> blockIDs = this.plugin.getBuildKeeper().getRoomBlockCounts().get(r);
                                String file = String.valueOf(this.plugin.getDataFolder()) + File.separator + r + "_block_list.txt";
                                int cost = 0;
                                try (BufferedWriter bw = new BufferedWriter(new FileWriter(file, false));){
                                    for (Map.Entry<String, Integer> entry : blockIDs.entrySet()) {
                                        String line = entry.getKey() + ", " + String.valueOf(entry.getValue());
                                        bw.write(line);
                                        bw.newLine();
                                        if (!this.plugin.getCondensables().containsKey(entry.getKey())) continue;
                                        int value = entry.getValue() * this.plugin.getCondensables().get(entry.getKey());
                                        cost += value;
                                    }
                                    bw.write("Actual room cost: " + Math.round((float)cost / 2.0f));
                                    bw.newLine();
                                }
                                catch (IOException e) {
                                    this.plugin.debug("Could not create and write to " + r + "_block_list.txt! " + e.getMessage());
                                }
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_FILE_SAVED", r);
                            }
                        });
                    } else {
                        Object rsp;
                        if (!rooms.contains(name)) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_ROOM");
                            return true;
                        }
                        HashMap<String, Integer> blockIDs = this.plugin.getBuildKeeper().getRoomBlockCounts().get(name);
                        boolean hasPrefs = false;
                        String wall = "ORANGE WOOL";
                        String floor = "LIGHT GREY WOOL";
                        if (sender instanceof Player && ((ResultSetPlayerPrefs)(rsp = new ResultSetPlayerPrefs(this.plugin, ((Player)sender).getUniqueId().toString()))).resultSet()) {
                            hasPrefs = true;
                            wall = ((ResultSetPlayerPrefs)rsp).getWall();
                            floor = ((ResultSetPlayerPrefs)rsp).getFloor();
                        }
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_BLOCKS", name);
                        for (Map.Entry entry : blockIDs.entrySet()) {
                            String mat = hasPrefs && (((String)entry.getKey()).equals("ORANGE_WOOL") || ((String)entry.getKey()).equals("LIGHT_GRAY_WOOL")) ? (((String)entry.getKey()).equals("ORANGE_WOOL") ? wall : floor) : (String)entry.getKey();
                            int tmp = Math.round((float)((Integer)entry.getValue()).intValue() / 100.0f * (float)this.plugin.getConfig().getInt("growth.rooms_condenser_percent"));
                            int amount = tmp > 0 ? tmp : 1;
                            String line = mat + ", " + amount;
                            sender.sendMessage(line);
                        }
                    }
                    return true;
                }
                case "required": {
                    Player player = null;
                    if (sender instanceof Player) {
                        player = (Player)sender;
                    }
                    if (player == null) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_NO_CONSOLE");
                        return true;
                    }
                    String name = args[1].toUpperCase(Locale.ROOT);
                    Set rooms = this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false);
                    if (!rooms.contains(name)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COULD_NOT_FIND_ROOM");
                        return true;
                    }
                    RoomRequiredLister.listCondensables(this.plugin, name, player);
                    return true;
                }
                case "add": {
                    if (!sender.hasPermission("tardis.admin")) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                        return false;
                    }
                    Pattern regex = Pattern.compile(".*[A-Z].*");
                    if (regex.matcher(args[1]).matches()) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_LOWERCASE");
                        return true;
                    }
                    String name = args[1].toUpperCase(Locale.ROOT);
                    if (name.equals("ADD") || name.equals("BLOCKS")) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_NO_NAME", args[1]);
                        return false;
                    }
                    if (this.plugin.getRoomsConfig().contains("rooms." + name)) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_EXISTS");
                        return true;
                    }
                    String lower = name.toLowerCase(Locale.ROOT);
                    String filepath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "user_schematics" + File.separator + lower + ".tschm";
                    File file = new File(filepath);
                    if (!file.exists()) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_SCHEMATIC_INFO", lower);
                        return true;
                    }
                    boolean success = new TARDISRoomMap(this.plugin).makeRoomMap(lower, name, true);
                    if (!success) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_FAILED");
                        return true;
                    }
                    this.plugin.getRoomsConfig().set("rooms." + name + ".enabled", (Object)false);
                    this.plugin.getRoomsConfig().set("rooms." + name + ".user", (Object)true);
                    try {
                        this.plugin.getRoomsConfig().save(new File(this.plugin.getDataFolder(), "rooms.yml"));
                    }
                    catch (IOException io) {
                        this.plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
                    }
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_ADDED");
                    return true;
                }
            }
            if (!sender.hasPermission("tardis.admin")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return false;
            }
            String name = args[0].toUpperCase(Locale.ROOT);
            if (!this.plugin.getRoomsConfig().contains("rooms." + name)) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_ROOM");
                return false;
            }
            String option = args[1].toLowerCase(Locale.ROOT);
            if (option.equals("true") || option.equals("false")) {
                if (!(this.plugin.getRoomsConfig().contains("rooms." + name + ".cost") && this.plugin.getRoomsConfig().contains("rooms." + name + ".seed") && this.plugin.getRoomsConfig().contains("rooms." + name + ".offset"))) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_NO_ENABLE");
                    return true;
                }
                boolean bool = Boolean.parseBoolean(args[1]);
                this.plugin.getRoomsConfig().set("rooms." + name + ".enabled", (Object)bool);
                try {
                    this.plugin.getRoomsConfig().save(new File(this.plugin.getDataFolder(), "rooms.yml"));
                }
                catch (IOException io) {
                    this.plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
                }
                if (bool) {
                    this.plugin.getGeneralKeeper().getRoomArgs().add(name);
                } else {
                    this.plugin.getGeneralKeeper().getRoomArgs().remove(name);
                }
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_TRUE_FALSE", name, option);
                return true;
            }
            try {
                int num = Integer.parseInt(args[1]);
                if (num > 0) {
                    this.plugin.getRoomsConfig().set("rooms." + name + ".cost", (Object)num);
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_COST", name, String.format("%d", num));
                } else {
                    this.plugin.getRoomsConfig().set("rooms." + name + ".offset", (Object)num);
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_OFFSET", name, String.format("%d", num));
                }
                try {
                    this.plugin.getRoomsConfig().save(new File(this.plugin.getDataFolder(), "rooms.yml"));
                }
                catch (IOException io) {
                    this.plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
                }
                return true;
            }
            catch (NumberFormatException nfe) {
                String setMaterial = args[1].toUpperCase(Locale.ROOT);
                try {
                    Material.valueOf((String)setMaterial);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "MATERIAL_NOT_VALID");
                    return false;
                }
                for (String m : this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false)) {
                    if (!setMaterial.equalsIgnoreCase(this.plugin.getRoomsConfig().getString("rooms." + m + ".seed"))) continue;
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_SEED_EXISTS");
                    return true;
                }
                this.plugin.getRoomsConfig().set("rooms." + name + ".seed", (Object)setMaterial);
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ROOM_SEED_SET", name, setMaterial);
                try {
                    this.plugin.getRoomsConfig().save(new File(this.plugin.getDataFolder(), "rooms.yml"));
                }
                catch (IOException io) {
                    this.plugin.debug("Could not save rooms.yml, " + String.valueOf(io));
                }
                Material m = Material.valueOf((String)setMaterial);
                this.plugin.getBuildKeeper().getSeeds().put(m, name);
                return true;
            }
        }
        return false;
    }
}

