/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.utility;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.api.event.TARDISCreationEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuildData;
import me.eccentric_nz.TARDIS.builders.interior.TARDISBuilderInner;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCount;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.planets.TARDISSpace;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISSeedBlockProcessor {
    private final TARDIS plugin;

    public TARDISSeedBlockProcessor(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean processBlock(TARDISBuildData seed, Location location, Player player) {
        if (TARDISPermission.hasPermission(player, "tardis.create")) {
            int max_count = this.plugin.getConfig().getInt("creation.count");
            int player_count = 0;
            int grace_count = 0;
            boolean has_count = false;
            UUID uniqueId = player.getUniqueId();
            String uuid = uniqueId.toString();
            ResultSetCount rsc = new ResultSetCount(this.plugin, uuid);
            if (rsc.resultSet()) {
                player_count = rsc.getCount();
                grace_count = rsc.getGrace();
                has_count = true;
                if (player_count == max_count && max_count > 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COUNT_QUOTA");
                    return false;
                }
            }
            String playerNameStr = player.getName();
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(uuid)) {
                Object preset;
                int cz;
                int cx;
                World chunkworld;
                Object cw;
                Schematic schm;
                if (this.plugin.getConfig().getBoolean("creation.check_for_home")) {
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("world", location.getWorld().getName());
                    where.put("x", location.getBlockX());
                    where.put("y", location.getBlockY());
                    where.put("z", location.getBlockZ());
                    ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, where);
                    if (rsh.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_NO_HOME");
                        return false;
                    }
                }
                if (!(schm = seed.getSchematic()).getPermission().equals("budget") && !TARDISPermission.hasPermission(player, "tardis." + schm.getPermission())) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_TARDIS_TYPE", schm.getPermission().toUpperCase(Locale.ROOT));
                    return false;
                }
                boolean tips = false;
                if (this.plugin.getConfig().getBoolean("creation.create_worlds") && !this.plugin.getConfig().getBoolean("creation.default_world")) {
                    cw = TARDISFloodgate.shouldReplacePrefix(uniqueId) ? TARDISFloodgate.getPlayerWorldName(playerNameStr) : "TARDIS_WORLD_" + playerNameStr;
                    space = new TARDISSpace(this.plugin);
                    chunkworld = space.getTardisWorld((String)cw);
                    cx = 0;
                    cz = 0;
                } else if (this.plugin.getConfig().getBoolean("creation.default_world") && this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms") && TARDISPermission.hasPermission(player, "tardis.create_world")) {
                    cw = TARDISFloodgate.shouldReplacePrefix(uniqueId) ? TARDISFloodgate.getPlayerWorldName(playerNameStr) : "TARDIS_WORLD_" + playerNameStr;
                    space = new TARDISSpace(this.plugin);
                    chunkworld = space.getTardisWorld((String)cw);
                    cx = 0;
                    cz = 0;
                } else {
                    Chunk chunk = location.getChunk();
                    if (this.plugin.getConfig().getBoolean("creation.default_world")) {
                        cw = this.plugin.getConfig().getString("creation.default_world_name");
                        chunkworld = TARDISAliasResolver.getWorldFromAlias((String)cw);
                        if (chunkworld == null) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_WORLD_NOT_LOADED");
                            return false;
                        }
                        tips = true;
                    } else {
                        chunkworld = chunk.getWorld();
                        cw = chunkworld.getName();
                    }
                    cx = chunk.getX();
                    cz = chunk.getZ();
                }
                String d = TARDISStaticUtils.getPlayersDirection(player, false);
                int slot = -1000001;
                if (tips) {
                    slot = new TARDISInteriorPostioning(this.plugin).getFreeSlot();
                    if (this.plugin.getConfig().getString("creation.tips_next", "HIGHEST").equalsIgnoreCase("FREE")) {
                        TARDISBuilderInstanceKeeper.getTipsSlots().add(slot);
                    }
                }
                String chun = (String)cw + ":" + cx + ":" + cz;
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tips", slot);
                set.put("uuid", uuid);
                set.put("owner", playerNameStr);
                set.put("chunk", chun);
                set.put("size", schm.getPermission().toUpperCase(Locale.ROOT));
                HashMap<String, Object> setpp = new HashMap<String, Object>();
                Material wall_type = seed.getWallType();
                Material floor_type = seed.getFloorType();
                long now = TARDISPermission.hasPermission(player, "tardis.prune.bypass") ? Long.MAX_VALUE : System.currentTimeMillis();
                set.put("lastuse", now);
                String tmp = this.plugin.getConfig().getString("police_box.default_preset", "FACTORY");
                if (!tmp.contains(":")) {
                    preset = tmp.toUpperCase(Locale.ROOT);
                } else {
                    String[] split = tmp.split(":");
                    preset = "ITEM:" + split[1];
                }
                set.put("chameleon_preset", preset);
                set.put("chameleon_demat", preset);
                setpp.put("wall", wall_type.toString());
                setpp.put("floor", floor_type.toString());
                int lastInsertId = this.plugin.getQueryFactory().doSyncInsert("tardis", set);
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid);
                if (!rsp.resultSet()) {
                    setpp.put("uuid", uuid);
                    String key = this.plugin.getConfig().getString("storage.database", "sqlite").equals("mysql") ? "key_item" : "key";
                    String default_key = this.plugin.getConfig().getString("preferences.key");
                    setpp.put(key, default_key);
                    this.plugin.getQueryFactory().doSyncInsert("player_prefs", setpp);
                } else {
                    HashMap<String, Object> wherepp = new HashMap<String, Object>();
                    wherepp.put("uuid", uuid);
                    this.plugin.getQueryFactory().doUpdate("player_prefs", setpp, wherepp);
                }
                if (this.plugin.getConfig().getBoolean("allow.mob_farming")) {
                    HashMap<String, Object> setf = new HashMap<String, Object>();
                    setf.put("tardis_id", lastInsertId);
                    this.plugin.getQueryFactory().doInsert("farming", setf);
                }
                HashMap<String, Object> setlocs = new HashMap<String, Object>();
                setlocs.put("tardis_id", lastInsertId);
                setlocs.put("world", location.getWorld().getName());
                setlocs.put("x", location.getBlockX());
                setlocs.put("y", location.getBlockY());
                setlocs.put("z", location.getBlockZ());
                setlocs.put("direction", d);
                this.plugin.getQueryFactory().insertLocations(setlocs);
                BuildData bd = new BuildData(uuid);
                bd.setDirection(COMPASS.valueOf(d));
                bd.setLocation(location);
                bd.setMalfunction(false);
                bd.setOutside(true);
                bd.setPlayer((OfflinePlayer)player);
                bd.setRebuild(false);
                bd.setSubmarine(this.isSub(location));
                bd.setTardisID(lastInsertId);
                bd.setThrottle(SpaceTimeThrottle.NORMAL);
                if (chunkworld != null) {
                    this.plugin.getPM().callEvent((Event)new TARDISCreationEvent(player, lastInsertId, location));
                    TARDISBuilderInner builder = new TARDISBuilderInner(this.plugin, schm, chunkworld, lastInsertId, player, wall_type, floor_type, slot);
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)builder, 1L, 3L);
                    builder.setTask(task);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        this.plugin.getPresetBuilder().buildPreset(bd);
                        Block block = location.getBlock();
                        block.setBlockData(TARDISConstants.AIR);
                        TARDISDisplayItemUtils.remove(block);
                    }, schm.getConsoleSize().getDelay());
                    if (TARDISPermission.hasPermission(player, "tardis.book")) {
                        HashMap<String, Object> seta = new HashMap<String, Object>();
                        seta.put("completed", 1);
                        HashMap<String, Object> wherea = new HashMap<String, Object>();
                        wherea.put("uuid", uuid);
                        wherea.put("name", "tardis");
                        this.plugin.getQueryFactory().doUpdate("achievements", seta, wherea);
                        TARDISAchievementFactory.grantAdvancement(Advancement.TARDIS, player);
                    }
                    if (max_count > 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COUNT", String.format("%d", player_count + 1), String.format("%d", max_count));
                    }
                    HashMap<String, Object> setc = new HashMap<String, Object>();
                    setc.put("count", player_count + 1);
                    setc.put("grace", grace_count);
                    if (has_count) {
                        HashMap<String, Object> wheretc = new HashMap<String, Object>();
                        wheretc.put("uuid", uuid);
                        this.plugin.getQueryFactory().doUpdate("t_count", setc, wheretc);
                    } else {
                        setc.put("uuid", uuid);
                        this.plugin.getQueryFactory().doInsert("t_count", setc);
                    }
                    this.plugin.getQueryFactory().insertEye(lastInsertId);
                    return true;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_WORLD_NOT_LOADED");
                return false;
            }
            ResultSetCurrentFromId rscl = new ResultSetCurrentFromId(this.plugin, rs.getTardisId());
            if (rscl.resultSet()) {
                Current current = rscl.getCurrent();
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_HAVE", current.location().getWorld().getName() + " at x:" + current.location().getBlockX() + " y:" + current.location().getBlockY() + " z:" + current.location().getBlockZ());
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HAVE_TARDIS");
            }
            return false;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_TARDIS");
        return false;
    }

    private boolean isSub(Location l) {
        return l.getBlock().getRelative(BlockFace.UP).getType().equals((Object)Material.WATER);
    }
}

