/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISSerializeInventory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISCircuitDamager {
    private final TARDIS plugin;
    private final DiskCircuit circuit;
    private final int id;
    private final Player p;
    private int uses_left;

    public TARDISCircuitDamager(TARDIS plugin, DiskCircuit circuit, int uses_left, int id, Player p) {
        this.plugin = plugin;
        this.circuit = circuit;
        this.uses_left = uses_left;
        this.id = id;
        this.p = p;
    }

    public void damage() {
        int decremented;
        if (this.uses_left == 0) {
            this.uses_left = this.plugin.getConfig().getInt("circuits.uses." + this.circuit.toString().toLowerCase(Locale.ROOT));
        }
        if ((decremented = this.uses_left - 1) <= 0) {
            this.setCircuitDamage(this.circuit.getName(), 0, true);
            this.plugin.getMessenger().send((CommandSender)this.p, TardisModule.TARDIS, "CIRCUIT_VAPOUR", this.circuit.getName());
        } else {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.setCircuitDamage(this.circuit.getName(), decremented, false);
                this.plugin.getMessenger().send((CommandSender)this.p, TardisModule.TARDIS, "CIRCUIT_USES", this.circuit.getName(), String.format("%d", decremented));
            }, 5L);
        }
    }

    private void setCircuitDamage(String c, int decremented, boolean destroy) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
        if (rs.resultSet()) {
            ItemStack[] clone = new ItemStack[18];
            int i = 0;
            try {
                ItemStack[] items;
                for (ItemStack is : items = TARDISSerializeInventory.itemStacksFromString(rs.getConsole())) {
                    ItemMeta im;
                    if (is != null && is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName()) {
                        String dn = ComponentUtils.stripColour(im.displayName());
                        if (dn.endsWith(c)) {
                            if (destroy) {
                                clone[i] = null;
                            } else {
                                List<TextComponent> lore = im.lore();
                                if (lore == null) {
                                    lore = List.of(Component.text((String)"Uses left"), Component.text((String)""));
                                }
                                TextComponent yellow = Component.text((int)decremented, (TextColor)NamedTextColor.YELLOW);
                                lore.set(1, yellow);
                                im.lore(lore);
                                is.setItemMeta(im);
                                clone[i] = is;
                            }
                        } else {
                            clone[i] = is;
                        }
                    }
                    ++i;
                }
                String serialized = TARDISSerializeInventory.itemStacksToString(clone);
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("console", serialized);
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", this.id);
                this.plugin.getQueryFactory().doUpdate("storage", set, wheret);
            }
            catch (IOException ex) {
                this.plugin.debug("Could not get console items: " + String.valueOf(ex));
            }
        }
    }
}

