/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISCommandSetter;
import me.eccentric_nz.TARDIS.TARDISConversions;
import me.eccentric_nz.TARDIS.TARDISGeneralInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISListenerRegisterer;
import me.eccentric_nz.TARDIS.TARDISPersister;
import me.eccentric_nz.TARDIS.TARDISRunnables;
import me.eccentric_nz.TARDIS.TARDISTrackerInstanceKeeper;
import me.eccentric_nz.TARDIS.TARDISWorldConfig;
import me.eccentric_nz.TARDIS.api.TARDII;
import me.eccentric_nz.TARDIS.artron.TARDISCondensables;
import me.eccentric_nz.TARDIS.bStats.TARDISStats;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISPresetBuilderFactory;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chatGUI.TARDISChatGUI;
import me.eccentric_nz.TARDIS.database.QueryFactory;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.TARDISMySQLDatabase;
import me.eccentric_nz.TARDIS.database.TARDISSQLiteDatabase;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTIPS;
import me.eccentric_nz.TARDIS.destroyers.TARDISDestroyerInner;
import me.eccentric_nz.TARDIS.destroyers.TARDISPresetDestroyerFactory;
import me.eccentric_nz.TARDIS.doors.TARDISCustomDoorLoader;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.enumeration.InventoryManager;
import me.eccentric_nz.TARDIS.enumeration.Language;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.files.TARDISAdaptiveUpdater;
import me.eccentric_nz.TARDIS.files.TARDISArtronUpdater;
import me.eccentric_nz.TARDIS.files.TARDISBlockLoader;
import me.eccentric_nz.TARDIS.files.TARDISBlocksUpdater;
import me.eccentric_nz.TARDIS.files.TARDISChameleonGuiUpdater;
import me.eccentric_nz.TARDIS.files.TARDISCondensablesUpdater;
import me.eccentric_nz.TARDIS.files.TARDISConfiguration;
import me.eccentric_nz.TARDIS.files.TARDISCustomPresetConverter;
import me.eccentric_nz.TARDIS.files.TARDISDesktopLoader;
import me.eccentric_nz.TARDIS.files.TARDISFileCopier;
import me.eccentric_nz.TARDIS.files.TARDISGeneratorUpdater;
import me.eccentric_nz.TARDIS.files.TARDISKitsUpdater;
import me.eccentric_nz.TARDIS.files.TARDISLanguageUpdater;
import me.eccentric_nz.TARDIS.files.TARDISPlanetsUpdater;
import me.eccentric_nz.TARDIS.files.TARDISRoomMap;
import me.eccentric_nz.TARDIS.files.TARDISRoomsUpdater;
import me.eccentric_nz.TARDIS.files.TARDISSignsUpdater;
import me.eccentric_nz.TARDIS.files.TARDISSysUpsUpdater;
import me.eccentric_nz.TARDIS.flight.vehicle.VehicleLoader;
import me.eccentric_nz.TARDIS.handles.TARDISHandlesUpdater;
import me.eccentric_nz.TARDIS.handles.wiki.HandlesWikiServerLink;
import me.eccentric_nz.TARDIS.mapping.TARDISBlueMap;
import me.eccentric_nz.TARDIS.mapping.TARDISDynmap;
import me.eccentric_nz.TARDIS.mapping.TARDISMapper;
import me.eccentric_nz.TARDIS.mapping.TARDISSquareMap;
import me.eccentric_nz.TARDIS.messaging.TARDISMessage;
import me.eccentric_nz.TARDIS.monitor.SnapshotLoader;
import me.eccentric_nz.TARDIS.perms.TARDISContexts;
import me.eccentric_nz.TARDIS.placeholders.TARDISPlaceholderExpansion;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.recipes.TARDISDisplayItemRecipe;
import me.eccentric_nz.TARDIS.recipes.TARDISSeedRecipe;
import me.eccentric_nz.TARDIS.recipes.TARDISShapedRecipe;
import me.eccentric_nz.TARDIS.recipes.TARDISShapelessRecipe;
import me.eccentric_nz.TARDIS.recipes.TARDISSmithingRecipe;
import me.eccentric_nz.TARDIS.rooms.eye.EyeLoader;
import me.eccentric_nz.TARDIS.rotors.TARDISCustomRotorLoader;
import me.eccentric_nz.TARDIS.sensor.SensorTracker;
import me.eccentric_nz.TARDIS.skins.SkinChanger;
import me.eccentric_nz.TARDIS.travel.TARDISArea;
import me.eccentric_nz.TARDIS.travel.TARDISPluginRespect;
import me.eccentric_nz.TARDIS.utility.TARDISChecker;
import me.eccentric_nz.TARDIS.utility.TARDISLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISModuleLoader;
import me.eccentric_nz.TARDIS.utility.TARDISMultiverseHelper;
import me.eccentric_nz.TARDIS.utility.TARDISPerceptionFilter;
import me.eccentric_nz.TARDIS.utility.TARDISUUIDDataType;
import me.eccentric_nz.TARDIS.utility.TARDISUtils;
import me.eccentric_nz.TARDIS.utility.logging.TARDISBlockLogger;
import me.eccentric_nz.TARDIS.utility.protection.TARDISWorldGuardUtils;
import me.eccentric_nz.tardischunkgenerator.TARDISHelper;
import me.eccentric_nz.tardischunkgenerator.worldgen.FlatGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.GallifreyGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.PlotGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.RoomGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.SiluriaGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.SkaroGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.TARDISChunkGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.TelosGenerator;
import me.eccentric_nz.tardischunkgenerator.worldgen.WaterGenerator;
import me.eccentric_nz.tardisregeneration.TARDISRegenerationUpdater;
import me.eccentric_nz.tardisshop.ShopSettings;
import me.eccentric_nz.tardissonicblaster.BlasterSettings;
import me.eccentric_nz.tardisvortexmanipulator.TVMSettings;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

public class TARDIS
extends JavaPlugin {
    public static TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final TARDISArea tardisArea = new TARDISArea(this);
    private final TARDISBuilderInstanceKeeper buildKeeper = new TARDISBuilderInstanceKeeper();
    private final TARDISDestroyerInner interiorDestroyer = new TARDISDestroyerInner(this);
    private final TARDISFileCopier tardisCopier = new TARDISFileCopier(this);
    private final TARDISPresetBuilderFactory presetBuilder = new TARDISPresetBuilderFactory(this);
    private final TARDISPresetDestroyerFactory presetDestroyer = new TARDISPresetDestroyerFactory(this);
    private final TARDISTrackerInstanceKeeper trackerKeeper = new TARDISTrackerInstanceKeeper();
    private final List<String> cleanUpWorlds = new ArrayList<String>();
    private final HashMap<String, String> versions = new HashMap();
    private final String versionRegex = "(\\d+[.])+\\d+";
    private final Pattern versionPattern = Pattern.compile("(\\d+[.])+\\d+");
    private TARDISMessage messenger;
    private TARDISChatGUI jsonKeeper;
    private SkinChanger skinChanger;
    private Calendar afterCal;
    private Calendar beforeCal;
    private ConsoleCommandSender console;
    private File quotesfile = null;
    private FileConfiguration achievementConfig;
    private FileConfiguration artronConfig;
    private FileConfiguration blocksConfig;
    private FileConfiguration condensablesConfig;
    private FileConfiguration customConsolesConfig;
    private FileConfiguration customDesktopsConfig;
    private FileConfiguration customDoorsConfig;
    private FileConfiguration customRotorsConfig;
    private FileConfiguration kitsConfig;
    private FileConfiguration language;
    private FileConfiguration lampsConfig;
    private FileConfiguration signs;
    private FileConfiguration chameleonGuis;
    private FileConfiguration roomsConfig;
    private FileConfiguration tagConfig;
    private FileConfiguration planetsConfig;
    private FileConfiguration handlesConfig;
    private FileConfiguration adaptiveConfig;
    private FileConfiguration generatorConfig;
    private FileConfiguration shopConfig;
    private FileConfiguration monstersConfig;
    private FileConfiguration vortexConfig;
    private FileConfiguration itemsConfig;
    private FileConfiguration blasterConfig;
    private FileConfiguration customModelConfig;
    private FileConfiguration systemUpgradesConfig;
    private FileConfiguration regenerationConfig;
    private HashMap<String, Integer> condensables;
    private BukkitTask standbyTask;
    private TARDISChameleonPreset presets;
    private TARDISPerceptionFilter filter;
    private TARDISPluginRespect pluginRespect;
    private TARDISSeedRecipe obstructionum;
    private TARDISShapedRecipe figura;
    private TARDISShapelessRecipe incomposita;
    private TARDISUtils utils;
    private TARDISLocationGetters locationUtils;
    private TARDISWorldGuardUtils worldGuardUtils;
    private boolean hasVersion = false;
    private boolean tardisSpawn = false;
    private boolean worldGuardOnServer = false;
    private boolean disguisesOnServer;
    private InventoryManager invManager = InventoryManager.NONE;
    private PluginManager pm;
    private TARDISGeneralInstanceKeeper generalKeeper;
    private TARDISHelper tardisHelper = null;
    private TARDISMultiverseHelper mvHelper = null;
    private String prefix;
    private CraftingDifficulty craftingDifficulty;
    private WorldManager worldManager;
    private NamespacedKey headBlockKey;
    private NamespacedKey oldBlockKey;
    private NamespacedKey customBlockKey;
    private NamespacedKey destroyKey;
    private NamespacedKey loopKey;
    private NamespacedKey tardisIdKey;
    private NamespacedKey timeLordUuidKey;
    private NamespacedKey standUuidKey;
    private NamespacedKey interactionUuidKey;
    private NamespacedKey modelUuidKey;
    private NamespacedKey unaryKey;
    private NamespacedKey blueprintKey;
    private NamespacedKey sonicUuidKey;
    private NamespacedKey sonicChargeKey;
    private NamespacedKey microscopeKey;
    private PersistentDataType<byte[], UUID> persistentDataTypeUUID;
    private QueryFactory queryFactory;
    private TARDISBlockLogger blockLogger;
    private TARDISMapper tardisMapper;
    private ShopSettings shopSettings;
    private TVMSettings tvmSettings;
    private BlasterSettings blasterSettings;

    public TARDIS() {
        this.versions.put("GriefPrevention", "16.18");
        this.versions.put("LibsDisguises", "11.0.6");
        this.versions.put("Multiverse-Core", "5.0");
        this.versions.put("Multiverse-Inventories", "5.0");
        this.versions.put("Towny", "0.101");
        this.versions.put("WorldGuard", "7.0.14");
    }

    public TARDISMessage getMessenger() {
        return this.messenger;
    }

    public void onDisable() {
        if (this.hasVersion) {
            boolean hasDatabase;
            if (this.tardisMapper != null) {
                this.tardisMapper.disable();
            }
            SensorTracker.resetChargingSensors();
            for (int id : this.getTrackerKeeper().getDematerialising()) {
                if (!this.getTrackerKeeper().getHasDestination().containsKey(id)) continue;
                this.getTrackerKeeper().getDestinationVortex().put(id, -1);
            }
            for (int id : this.getTrackerKeeper().getMaterialising()) {
                this.getTrackerKeeper().getDestinationVortex().put(id, -2);
            }
            boolean bl = hasDatabase = TARDISDatabaseConnection.getINSTANCE().connection != null;
            if (hasDatabase) {
                TARDISPerceptionFilter.removePerceptionFilter();
                this.debug("Perception Filters removed");
                new TARDISPersister(this).save();
            }
            this.getServer().getScheduler().cancelTasks((Plugin)this);
            this.debug("Cancelling all scheduled tasks");
            this.resetTime();
            this.debug("Resetting player time(s)");
            if (hasDatabase) {
                this.updateTagStats();
                this.debug("Updated Tag stats");
                this.closeDatabase();
                this.debug("Closing database");
            }
            this.debug("TARDIS disabled successfully!");
        }
    }

    public void onEnable() {
        ModuleDescriptor.Version minVersion;
        this.pm = this.getServer().getPluginManager();
        plugin = this;
        this.headBlockKey = new NamespacedKey((Plugin)this, "monster_head");
        this.oldBlockKey = new NamespacedKey((Plugin)this, "customBlock");
        this.customBlockKey = new NamespacedKey((Plugin)this, "custom_block");
        this.destroyKey = new NamespacedKey((Plugin)this, "destroy");
        this.loopKey = new NamespacedKey((Plugin)this, "loop");
        this.tardisIdKey = new NamespacedKey((Plugin)this, "tardis_id");
        this.timeLordUuidKey = new NamespacedKey((Plugin)this, "timelord_uuid");
        this.standUuidKey = new NamespacedKey((Plugin)this, "stand_uuid");
        this.interactionUuidKey = new NamespacedKey((Plugin)this, "interaction_uuid");
        this.modelUuidKey = new NamespacedKey((Plugin)this, "model_uuid");
        this.unaryKey = new NamespacedKey((Plugin)this, "unary");
        this.blueprintKey = new NamespacedKey((Plugin)this, "blueprint");
        this.sonicUuidKey = new NamespacedKey((Plugin)this, "sonic_uuid");
        this.sonicChargeKey = new NamespacedKey((Plugin)this, "sonic_charge");
        this.microscopeKey = new NamespacedKey((Plugin)this, "microscope");
        this.persistentDataTypeUUID = new TARDISUUIDDataType();
        this.console = this.getServer().getConsoleSender();
        ModuleDescriptor.Version serverVersion = this.getServerVersion(this.getServer().getVersion());
        if (serverVersion.compareTo(minVersion = ModuleDescriptor.Version.parse("1.21.11")) >= 0) {
            if (this.pm.isPluginEnabled("TARDISChunkGenerator")) {
                this.getLogger().log(Level.SEVERE, "This plugin no longer requires TARDISChunkGenerator please remove and try again, disabling...");
                this.hasVersion = false;
                this.pm.disablePlugin((Plugin)this);
                return;
            }
            this.messenger = new TARDISMessage();
            this.jsonKeeper = new TARDISChatGUI();
            this.skinChanger = new SkinChanger();
            this.messenger.sendStartBanner((CommandSender)this.console);
            for (Map.Entry<String, String> plg : this.versions.entrySet()) {
                if (this.checkPluginVersion(plg.getKey(), plg.getValue())) continue;
                this.getLogger().log(Level.SEVERE, "This plugin requires " + plg.getKey() + " to be v" + plg.getValue() + " or higher, disabling...");
                this.hasVersion = false;
                this.pm.disablePlugin((Plugin)this);
                return;
            }
            File cc = new File(String.valueOf(this.getDataFolder()) + File.separator + "custom_desktops.yml");
            File cd = new File(String.valueOf(this.getDataFolder()) + File.separator + "custom_desktops.yml");
            if (cc.exists() && !cd.exists()) {
                Path source = Paths.get(String.valueOf(this.getDataFolder()) + File.separator + "custom_consoles.yml", new String[0]);
                try {
                    Files.move(source, source.resolveSibling("custom_desktops.yml"), new CopyOption[0]);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Failed to rename 'custom_consoles.yml' to 'custom_desktops.yml', disabling...");
                    this.hasVersion = false;
                    this.pm.disablePlugin((Plugin)this);
                    return;
                }
            }
            this.hasVersion = true;
            this.worldManager = WorldManager.getWorldManager();
            this.saveDefaultConfig();
            this.reloadConfig();
            if (!this.getConfig().getBoolean("conversions.custom_presets")) {
                new TARDISCustomPresetConverter(this).toJson();
            } else {
                this.tardisCopier.copy("custom_presets.json");
            }
            this.tardisCopier.copy("planets.yml");
            this.planetsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "planets.yml"));
            this.loadCustomConfigs();
            this.loadHelper();
            this.loadMultiverse();
            this.loadWorldGuard();
            this.loadLuckPerms();
            this.loadLanguage();
            this.loadSigns();
            this.loadChameleonGUIs();
            new TARDISConfiguration(this).checkConfig();
            this.prefix = this.getConfig().getString("storage.mysql.prefix", "");
            this.loadDatabase();
            this.queryFactory = new QueryFactory(this);
            this.loadInventoryManager();
            new TARDISWorldConfig(this).check();
            TARDISAliasResolver.createAliasMap();
            this.utils = new TARDISUtils(this);
            this.locationUtils = new TARDISLocationGetters(this);
            this.buildKeeper.setSeeds(this.getSeeds());
            if (this.getConfig().getString("creation.tips_next", "HIGHEST").equalsIgnoreCase("FREE")) {
                new ResultSetTIPS(this).fillUsedSlotList();
            }
            if (this.getConfig().getBoolean("preferences.add_server_link")) {
                new HandlesWikiServerLink(this).addServerLink();
            }
            new TARDISDesktopLoader(this).addSchematics();
            new TARDISCustomRotorLoader(this).addRotors();
            new TARDISCustomDoorLoader(this).addDoors();
            this.loadFiles();
            this.disguisesOnServer = this.pm.isPluginEnabled("LibsDisguises");
            this.generalKeeper = new TARDISGeneralInstanceKeeper(this);
            this.generalKeeper.setQuotes(this.quotes());
            try {
                this.craftingDifficulty = CraftingDifficulty.valueOf(this.getConfig().getString("difficulty.crafting", "EASY").toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                this.debug("Could not determine difficulty setting, using EASY");
                this.craftingDifficulty = CraftingDifficulty.EASY;
            }
            this.figura = new TARDISShapedRecipe(this);
            this.figura.addShapedRecipes();
            this.incomposita = new TARDISShapelessRecipe(this);
            this.incomposita.addShapelessRecipes();
            if (this.getConfig().getBoolean("creation.seed_block.crafting")) {
                this.obstructionum = new TARDISSeedRecipe(this);
                this.obstructionum.addSeedRecipes();
            }
            new TARDISSmithingRecipe(this).addSmithingRecipes();
            new TARDISDisplayItemRecipe(this).addDisplayItemRecipes();
            new TARDISListenerRegisterer(this).registerListeners();
            new TARDISCommandSetter(this).loadCommands();
            this.loadPluginRespect();
            String mapper = this.getConfig().getString("mapping.provider", "dynmap");
            if (this.pm.isPluginEnabled(mapper) && this.getConfig().getBoolean("modules.mapping")) {
                this.getMessenger().message((CommandSender)this.console, TardisModule.TARDIS, "Loading Mapping Module");
                this.tardisMapper = mapper.equals("dynmap") ? new TARDISDynmap(this) : (mapper.equals("squaremap") ? new TARDISSquareMap(this) : new TARDISBlueMap(this));
                this.tardisMapper.enable();
            }
            new TARDISModuleLoader(this).enable();
            new TARDISConversions(this).convert();
            TARDISBlockLoader bl = new TARDISBlockLoader(this);
            bl.loadGravityWells();
            bl.loadProtectedBlocks();
            if (this.worldGuardOnServer && this.getConfig().getBoolean("allow.wg_flag_set")) {
                bl.loadAntiBuild();
            }
            this.loadBooks();
            new TARDISChecker(this).checkDataPack();
            this.presets = new TARDISChameleonPreset();
            this.presets.makePresets();
            this.blockLogger = new TARDISBlockLogger(this);
            if (this.pm.getPlugin("CoreProtect") != null) {
                this.debug("Logging block changes with CoreProtect.");
                this.blockLogger.enableLogger();
            }
            new SnapshotLoader(this).load();
            new TARDISPersister(this).load();
            this.setDates();
            if (this.getConfig().getBoolean("allow.perception_filter")) {
                this.filter = new TARDISPerceptionFilter(this);
                this.filter.createPerceptionFilter();
            }
            TARDISCondensables cond = new TARDISCondensables(this);
            cond.makeCondensables();
            this.condensables = cond.getCondensables();
            new TARDISRunnables(this).start();
            if (this.pm.getPlugin("PlaceholderAPI") != null) {
                this.debug("Registering expansion with PlaceholderAPI.");
                new TARDISPlaceholderExpansion(this).register();
            }
            this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, () -> new TARDISStats(this).startMetrics(), 200L);
        } else {
            this.getLogger().log(Level.SEVERE, "This plugin requires Spigot/Paper " + String.valueOf(minVersion) + " or higher, disabling...");
            this.pm.disablePlugin((Plugin)this);
        }
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        if (id != null) {
            if (id.equalsIgnoreCase("flat")) {
                return new FlatGenerator(this);
            }
            if (id.equalsIgnoreCase("plot")) {
                return new PlotGenerator(this);
            }
            if (id.equalsIgnoreCase("water")) {
                return new WaterGenerator();
            }
            if (id.equalsIgnoreCase("gallifrey")) {
                return new GallifreyGenerator(this);
            }
            if (id.equalsIgnoreCase("siluria")) {
                return new SiluriaGenerator(this);
            }
            if (id.equalsIgnoreCase("skaro")) {
                return new SkaroGenerator(this);
            }
            if (id.equalsIgnoreCase("telos")) {
                return new TelosGenerator(this);
            }
            if (id.equalsIgnoreCase("rooms")) {
                return new RoomGenerator(this);
            }
            return new TARDISChunkGenerator();
        }
        return new TARDISChunkGenerator();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public InventoryManager getInvManager() {
        return this.invManager;
    }

    public TARDISMultiverseHelper getMVHelper() {
        return this.mvHelper;
    }

    public TARDISHelper getTardisHelper() {
        return this.tardisHelper;
    }

    public void debug(Object o) {
        if (this.getConfig().getBoolean("debug")) {
            this.getMessenger().message((CommandSender)this.console, TardisModule.DEBUG, String.valueOf(o));
        }
    }

    public FileConfiguration getAchievementConfig() {
        return this.achievementConfig;
    }

    public FileConfiguration getArtronConfig() {
        return this.artronConfig;
    }

    public FileConfiguration getBlocksConfig() {
        return this.blocksConfig;
    }

    public FileConfiguration getRoomsConfig() {
        return this.roomsConfig;
    }

    public FileConfiguration getPlanetsConfig() {
        return this.planetsConfig;
    }

    public FileConfiguration getTagConfig() {
        return this.tagConfig;
    }

    public FileConfiguration getKitsConfig() {
        return this.kitsConfig;
    }

    public FileConfiguration getCondensablesConfig() {
        return this.condensablesConfig;
    }

    public FileConfiguration getCustomConsolesConfig() {
        return this.customConsolesConfig;
    }

    public FileConfiguration getCustomDesktopsConfig() {
        return this.customDesktopsConfig;
    }

    public FileConfiguration getCustomDoorsConfig() {
        return this.customDoorsConfig;
    }

    public FileConfiguration getCustomRotorsConfig() {
        return this.customRotorsConfig;
    }

    public FileConfiguration getGeneratorConfig() {
        return this.generatorConfig;
    }

    public FileConfiguration getShopConfig() {
        return this.shopConfig;
    }

    public FileConfiguration getMonstersConfig() {
        return this.monstersConfig;
    }

    public FileConfiguration getVortexConfig() {
        return this.vortexConfig;
    }

    public FileConfiguration getItemsConfig() {
        return this.itemsConfig;
    }

    public FileConfiguration getBlasterConfig() {
        return this.blasterConfig;
    }

    public FileConfiguration getCustomModelConfig() {
        return this.customModelConfig;
    }

    public FileConfiguration getSystemUpgradesConfig() {
        return this.systemUpgradesConfig;
    }

    public FileConfiguration getRegenerationConfig() {
        return this.regenerationConfig;
    }

    public FileConfiguration getLampsConfig() {
        return this.lampsConfig;
    }

    public FileConfiguration getLanguage() {
        return this.language;
    }

    public void setLanguage(FileConfiguration language) {
        this.language = language;
    }

    public FileConfiguration getSigns() {
        return this.signs;
    }

    public FileConfiguration getChameleonGuis() {
        return this.chameleonGuis;
    }

    public FileConfiguration getHandlesConfig() {
        return this.handlesConfig;
    }

    public FileConfiguration getAdaptiveConfig() {
        return this.adaptiveConfig;
    }

    public TARDISUtils getUtils() {
        return this.utils;
    }

    public TARDISLocationGetters getLocationUtils() {
        return this.locationUtils;
    }

    public TARDISPluginRespect getPluginRespect() {
        return this.pluginRespect;
    }

    public TARDISPresetBuilderFactory getPresetBuilder() {
        return this.presetBuilder;
    }

    public TARDISDestroyerInner getInteriorDestroyer() {
        return this.interiorDestroyer;
    }

    public TARDISPresetDestroyerFactory getPresetDestroyer() {
        return this.presetDestroyer;
    }

    public TARDISArea getTardisArea() {
        return this.tardisArea;
    }

    public TARDISWorldGuardUtils getWorldGuardUtils() {
        return this.worldGuardUtils;
    }

    public TARDISChameleonPreset getPresets() {
        return this.presets;
    }

    public TARDISShapedRecipe getFigura() {
        return this.figura;
    }

    public TARDISSeedRecipe getObstructionum() {
        return this.obstructionum;
    }

    public TARDISShapelessRecipe getIncomposita() {
        return this.incomposita;
    }

    public TARDISPerceptionFilter getFilter() {
        return this.filter;
    }

    public Calendar getBeforeCal() {
        return this.beforeCal;
    }

    public Calendar getAfterCal() {
        return this.afterCal;
    }

    public HashMap<String, Integer> getCondensables() {
        return this.condensables;
    }

    public TARDISGeneralInstanceKeeper getGeneralKeeper() {
        return this.generalKeeper;
    }

    public TARDISBuilderInstanceKeeper getBuildKeeper() {
        return this.buildKeeper;
    }

    public TARDISTrackerInstanceKeeper getTrackerKeeper() {
        return this.trackerKeeper;
    }

    public TARDISChatGUI getJsonKeeper() {
        return this.jsonKeeper;
    }

    public SkinChanger getSkinChanger() {
        return this.skinChanger;
    }

    public ConsoleCommandSender getConsole() {
        return this.console;
    }

    public boolean isTardisSpawn() {
        return this.tardisSpawn;
    }

    public void setTardisSpawn(boolean tardisSpawn) {
        this.tardisSpawn = tardisSpawn;
    }

    public boolean isWorldGuardOnServer() {
        return this.worldGuardOnServer;
    }

    public boolean isDisguisesOnServer() {
        return this.disguisesOnServer;
    }

    public PluginManager getPM() {
        return this.pm;
    }

    public TARDISFileCopier getTardisCopier() {
        return this.tardisCopier;
    }

    public TARDII getTardisAPI() {
        return new TARDII();
    }

    public BukkitTask getStandbyTask() {
        return this.standbyTask;
    }

    public void setStandbyTask(BukkitTask task) {
        this.standbyTask = task;
    }

    public List<String> getCleanUpWorlds() {
        return this.cleanUpWorlds;
    }

    public CraftingDifficulty getCraftingDifficulty() {
        return this.craftingDifficulty;
    }

    public void setDifficulty(CraftingDifficulty craftingDifficulty) {
        this.craftingDifficulty = craftingDifficulty;
    }

    public WorldManager getWorldManager() {
        return this.worldManager;
    }

    public NamespacedKey getOldBlockKey() {
        return this.oldBlockKey;
    }

    public NamespacedKey getHeadBlockKey() {
        return this.headBlockKey;
    }

    public NamespacedKey getCustomBlockKey() {
        return this.customBlockKey;
    }

    public NamespacedKey getDestroyKey() {
        return this.destroyKey;
    }

    public NamespacedKey getLoopKey() {
        return this.loopKey;
    }

    public NamespacedKey getTardisIdKey() {
        return this.tardisIdKey;
    }

    public NamespacedKey getTimeLordUuidKey() {
        return this.timeLordUuidKey;
    }

    public NamespacedKey getStandUuidKey() {
        return this.standUuidKey;
    }

    public NamespacedKey getInteractionUuidKey() {
        return this.interactionUuidKey;
    }

    public NamespacedKey getModelUuidKey() {
        return this.modelUuidKey;
    }

    public NamespacedKey getUnaryKey() {
        return this.unaryKey;
    }

    public NamespacedKey getBlueprintKey() {
        return this.blueprintKey;
    }

    public NamespacedKey getSonicUuidKey() {
        return this.sonicUuidKey;
    }

    public NamespacedKey getSonicChargeKey() {
        return this.sonicChargeKey;
    }

    public NamespacedKey getMicroscopeKey() {
        return this.microscopeKey;
    }

    public PersistentDataType<byte[], UUID> getPersistentDataTypeUUID() {
        return this.persistentDataTypeUUID;
    }

    public QueryFactory getQueryFactory() {
        return this.queryFactory;
    }

    public TARDISBlockLogger getBlockLogger() {
        return this.blockLogger;
    }

    public void savePlanetsConfig() {
        try {
            String planetsPath = String.valueOf(plugin.getDataFolder()) + File.separator + "planets.yml";
            this.planetsConfig.save(new File(planetsPath));
        }
        catch (IOException io) {
            plugin.debug("Could not save planets.yml, " + io.getMessage());
        }
    }

    public TARDISMapper getTardisMapper() {
        return this.tardisMapper;
    }

    public void setTardisMapper(TARDISMapper tardisMapper) {
        this.tardisMapper = tardisMapper;
    }

    public ShopSettings getShopSettings() {
        return this.shopSettings;
    }

    public void setShopSettings(ShopSettings settings) {
        this.shopSettings = settings;
    }

    public TVMSettings getTvmSettings() {
        return this.tvmSettings;
    }

    public void setTvmSettings(TVMSettings tvmSettings) {
        this.tvmSettings = tvmSettings;
    }

    public BlasterSettings getBlasterSettings() {
        return this.blasterSettings;
    }

    public void setBlasterSettings(BlasterSettings blasterSettings) {
        this.blasterSettings = blasterSettings;
    }

    private ModuleDescriptor.Version getServerVersion(String s) {
        Matcher mat = this.versionPattern.matcher(s);
        String v = mat.find() ? mat.group(0) : "1.13";
        return ModuleDescriptor.Version.parse(v);
    }

    private boolean checkPluginVersion(String plg, String min) {
        if (this.pm.isPluginEnabled(plg)) {
            Plugin check = this.pm.getPlugin(plg);
            ModuleDescriptor.Version minVersion = ModuleDescriptor.Version.parse(min);
            String yamlVersion = check.getDescription().getVersion();
            Matcher matcher = this.versionPattern.matcher(yamlVersion);
            if (matcher.find()) {
                String pluginVersion = matcher.group(0);
                try {
                    ModuleDescriptor.Version version = ModuleDescriptor.Version.parse(pluginVersion);
                    return version.compareTo(minVersion) >= 0;
                }
                catch (IllegalArgumentException e) {
                    this.debug("Version IllegalArgumentException");
                }
            }
            this.getLogger().log(Level.WARNING, "TARDIS failed to get the version for {0}.", plg);
            this.getLogger().log(Level.WARNING, "This could cause issues with enabling the plugin.");
            this.getLogger().log(Level.WARNING, "Please check you have at least v{0}", min);
            this.getLogger().log(Level.WARNING, "The invalid version format was {0}", yamlVersion);
        }
        return true;
    }

    private void loadDatabase() {
        String databaseType = this.getConfig().getString("storage.database", "sqlite");
        try {
            if (databaseType.equals("sqlite")) {
                String path = String.valueOf(this.getDataFolder()) + File.separator + "TARDIS.db";
                this.service.setConnection(path);
                TARDISSQLiteDatabase sqlite = new TARDISSQLiteDatabase(this);
                sqlite.createTables();
            } else {
                this.service.setConnection();
                TARDISMySQLDatabase mysql = new TARDISMySQLDatabase(this);
                mysql.createTables();
            }
        }
        catch (Exception e) {
            this.getMessenger().message((CommandSender)this.console, TardisModule.TARDIS, "Connection and Tables Error: " + String.valueOf(e));
        }
    }

    private void closeDatabase() {
        try {
            this.service.connection.close();
        }
        catch (SQLException e) {
            this.getLogger().log(Level.WARNING, "Could not close database connection: " + String.valueOf(e));
        }
    }

    private void loadLanguage() {
        boolean result;
        File langDir = new File(String.valueOf(this.getDataFolder()) + File.separator + "language");
        if (!langDir.exists() && (result = langDir.mkdir()) && langDir.setWritable(true) && langDir.setExecutable(true)) {
            this.getMessenger().message((CommandSender)this.console, TardisModule.TARDIS, "Created language directory.");
        }
        TARDISFileCopier.copy(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "en.yml", this.getResource("en.yml"), true);
        TARDISFileCopier.copy(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "ru.yml", this.getResource("ru.yml"), false);
        String lang = this.getConfig().getString("preferences.language");
        File file = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + lang + ".yml");
        if (!file.isFile()) {
            file = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "en.yml");
            lang = "en";
        }
        this.getMessenger().message((CommandSender)this.console, TardisModule.TARDIS, "Loading language: " + Language.valueOf(lang).getLang());
        this.language = YamlConfiguration.loadConfiguration((File)file);
        new TARDISLanguageUpdater(this).update();
    }

    private void loadSigns() {
        File file = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "signs.yml");
        if (!file.exists()) {
            TARDISFileCopier.copy(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "signs.yml", this.getResource("signs.yml"), true);
            file = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "signs.yml");
        }
        this.signs = YamlConfiguration.loadConfiguration((File)file);
        new TARDISSignsUpdater(plugin, this.signs).checkSignsConfig();
    }

    private void loadChameleonGUIs() {
        File file = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "chameleon_guis.yml");
        if (!file.exists()) {
            TARDISFileCopier.copy(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "chameleon_guis.yml", this.getResource("chameleon_guis.yml"), true);
            file = new File(String.valueOf(this.getDataFolder()) + File.separator + "language" + File.separator + "chameleon_guis.yml");
        }
        this.chameleonGuis = YamlConfiguration.loadConfiguration((File)file);
        new TARDISChameleonGuiUpdater(plugin, this.chameleonGuis).checkChameleonConfig();
    }

    private void loadCustomConfigs() {
        List<String> files = List.of("achievements.yml", "adaptive.yml", "artron.yml", "blaster.yml", "blocks.yml", "condensables.yml", "custom_consoles.yml", "custom_desktops.yml", "custom_doors.yml", "custom_models.yml", "custom_presets.json", "custom_time_rotors.yml", "generator.yml", "handles.yml", "items.yml", "kits.yml", "lamps.yml", "monsters.yml", "regeneration.yml", "rooms.yml", "shop.yml", "system_upgrades.yml", "tag.yml", "vortex_manipulator.yml");
        for (String f : files) {
            this.tardisCopier.copy(f);
            this.tardisCopier.copy(f);
        }
        new TARDISPlanetsUpdater(this, this.planetsConfig).checkPlanetsConfig();
        this.roomsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "rooms.yml"));
        new TARDISRoomsUpdater(this, this.roomsConfig).checkRoomsConfig();
        this.artronConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "artron.yml"));
        new TARDISArtronUpdater(this).checkArtronConfig();
        this.blocksConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "blocks.yml"));
        new TARDISBlocksUpdater(this, this.blocksConfig).checkBlocksConfig();
        this.condensablesConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "condensables.yml"));
        new TARDISCondensablesUpdater(this).checkCondensables();
        this.customConsolesConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "custom_consoles.yml"));
        this.customDesktopsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "custom_desktops.yml"));
        this.customDoorsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "custom_doors.yml"));
        this.customRotorsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "custom_time_rotors.yml"));
        this.kitsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "kits.yml"));
        new TARDISKitsUpdater(this, this.kitsConfig).checkKits();
        this.achievementConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "achievements.yml"));
        this.tagConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "tag.yml"));
        this.handlesConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "handles.yml"));
        new TARDISHandlesUpdater(this, this.handlesConfig).checkHandles();
        this.adaptiveConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "adaptive.yml"));
        new TARDISAdaptiveUpdater(this).checkBiomesConfig();
        this.generatorConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "generator.yml"));
        new TARDISGeneratorUpdater(this, this.generatorConfig).checkTrees();
        this.lampsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "lamps.yml"));
        if (this.getConfig().getBoolean("modules.weeping_angels")) {
            this.monstersConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "monsters.yml"));
        }
        if (this.getConfig().getBoolean("modules.shop")) {
            this.shopConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "shop.yml"));
            this.itemsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "items.yml"));
        }
        if (this.getConfig().getBoolean("modules.vortex_manipulator")) {
            this.vortexConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "vortex_manipulator.yml"));
        }
        if (this.getConfig().getBoolean("modules.sonic_blaster")) {
            this.blasterConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "blaster.yml"));
        }
        this.customModelConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "custom_models.yml"));
        this.systemUpgradesConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "system_upgrades.yml"));
        new TARDISSysUpsUpdater(this).checkSystemUpgradesConfig();
        if (this.getConfig().getBoolean("modules.regeneration")) {
            this.regenerationConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "regeneration.yml"));
            new TARDISRegenerationUpdater(this).checkConfig();
        }
    }

    private void loadFiles() {
        this.tardisCopier.copyRoomTemplateFile();
        new TARDISRoomMap(this).load();
        this.quotesfile = this.tardisCopier.copy("quotes.txt");
    }

    private void loadBooks() {
        boolean result;
        File bookDir = new File(String.valueOf(this.getDataFolder()) + File.separator + "books");
        if (!bookDir.exists() && (result = bookDir.mkdir()) && bookDir.setWritable(true) && bookDir.setExecutable(true)) {
            this.getMessenger().message((CommandSender)this.console, TardisModule.TARDIS, "Created books directory.");
        }
        Set bookNames = this.achievementConfig.getKeys(false);
        bookNames.forEach(b -> TARDISFileCopier.copy(String.valueOf(this.getDataFolder()) + File.separator + "books" + File.separator + b + ".txt", this.getResource("books/" + b + ".txt"), false));
    }

    private void loadWorldGuard() {
        if (this.pm.getPlugin("WorldGuard") != null) {
            this.debug("Hooking into WorldGuard!");
            this.worldGuardOnServer = true;
            this.worldGuardUtils = new TARDISWorldGuardUtils(this);
        }
    }

    private void loadLuckPerms() {
        if (this.pm.getPlugin("LuckPerms") != null) {
            this.debug("Loading LuckPerms `is-flying-tardis` context");
            new TARDISContexts().register();
        }
    }

    private void loadInventoryManager() {
        if (this.pm.isPluginEnabled("Multiverse-Inventories")) {
            this.invManager = InventoryManager.MULTIVERSE;
        }
        if (this.pm.isPluginEnabled("GameModeInventories")) {
            this.invManager = InventoryManager.GAMEMODE;
        }
    }

    private void loadMultiverse() {
        if (this.worldManager.equals((Object)WorldManager.MULTIVERSE)) {
            this.debug("Hooking into Multiverse-Core!");
            this.mvHelper = new TARDISMultiverseHelper();
        }
    }

    private void loadHelper() {
        this.debug("Loading Helper module!");
        this.tardisHelper = new TARDISHelper(this);
        this.tardisHelper.enable();
        new EyeLoader(this).enable();
        new VehicleLoader().injectEntity();
    }

    private void loadPluginRespect() {
        this.pluginRespect = new TARDISPluginRespect(this);
        this.pluginRespect.loadTowny();
        this.pluginRespect.loadChunkyBorder();
        this.pluginRespect.loadGriefPrevention();
        this.pluginRespect.checkWorldGuardEntry();
    }

    private ArrayList<String> quotes() {
        ArrayList<String> quotes = new ArrayList<String>();
        if (this.quotesfile != null) {
            try (BufferedReader bufRdr = new BufferedReader(new FileReader(this.quotesfile));){
                String line;
                while ((line = bufRdr.readLine()) != null) {
                    quotes.add(line);
                }
                if (quotes.isEmpty()) {
                    quotes.add("");
                }
            }
            catch (IOException io) {
                this.getLogger().log(Level.WARNING, "Could not read quotes file");
            }
        }
        return quotes;
    }

    private HashMap<Material, String> getSeeds() {
        HashMap<Material, String> map = new HashMap<Material, String>();
        Set rooms = this.getRoomsConfig().getConfigurationSection("rooms").getKeys(false);
        int r = 0;
        for (String s : rooms) {
            if (!this.getRoomsConfig().contains("rooms." + s + ".user")) {
                this.getRoomsConfig().set("rooms." + s + ".user", (Object)true);
                ++r;
            }
            if (!this.getRoomsConfig().getBoolean("rooms." + s + ".enabled")) continue;
            try {
                Material m = Material.valueOf((String)this.getRoomsConfig().getString("rooms." + s + ".seed"));
                map.put(m, s);
            }
            catch (IllegalArgumentException e) {
                this.debug("Invalid room seed: " + this.getRoomsConfig().getString("rooms." + s + ".seed"));
            }
        }
        if (r > 0) {
            try {
                this.getRoomsConfig().save(new File(this.getDataFolder(), "rooms.yml"));
            }
            catch (IOException io) {
                this.debug("Could not save rooms.yml, " + io.getMessage());
            }
        }
        return map;
    }

    private void resetTime() {
        this.trackerKeeper.getSetTime().keySet().forEach(key -> {
            Player p = this.getServer().getPlayer(key);
            if (p != null) {
                p.resetPlayerTime();
            }
        });
    }

    private void setDates() {
        int month = this.getTagConfig().getInt("month") - 1;
        int day = this.getTagConfig().getInt("day");
        this.beforeCal = Calendar.getInstance();
        this.beforeCal.set(10, 0);
        this.beforeCal.set(12, 0);
        this.beforeCal.set(13, 0);
        this.beforeCal.set(2, month);
        this.beforeCal.set(5, day);
        this.afterCal = Calendar.getInstance();
        this.afterCal.set(10, 23);
        this.afterCal.set(12, 59);
        this.afterCal.set(13, 59);
        this.afterCal.set(2, month);
        this.afterCal.set(5, day);
        this.getTagConfig().set("it", (Object)"");
    }

    private void updateTagStats() {
        String it = this.getTagConfig().getString("it", "");
        if (!it.isEmpty()) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("player", this.getTagConfig().getString("it"));
            long time = System.currentTimeMillis() - this.getTagConfig().getLong("time");
            set.put("time", time);
            this.getQueryFactory().doSyncInsert("tag", set);
        }
    }
}

