/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.ARS;
import me.eccentric_nz.TARDIS.ARS.ARSSound;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.ARS.TARDISARSInventory;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMapData;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMethods;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSaveData;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.custommodels.keys.RoomVariant;
import me.eccentric_nz.TARDIS.enumeration.Room;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISARSListener
extends TARDISARSMethods
implements Listener {
    private List<Material> room_materials;
    private List<String> room_names;

    public TARDISARSListener(TARDIS plugin) {
        super(plugin);
        this.getRoomIdAndNames();
    }

    @EventHandler(ignoreCancelled=true)
    public void onARSTerminalClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISARSInventory)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(playerUUID, playerUUID);
        this.ids.put(playerUUID, this.getTardisId(uuid.toString()));
        int slot = event.getRawSlot();
        if (slot != 10 && !this.hasLoadedMap.contains(playerUUID)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_LOAD");
            return;
        }
        if (slot < 0 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 1: 
            case 9: 
            case 11: 
            case 19: {
                this.moveMap(playerUUID, view, slot);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (this.checkSlotForConsole(view, slot)) break;
                this.selected_slot.put(playerUUID, slot);
                break;
            }
            case 10: {
                this.loadMap(view, playerUUID);
                break;
            }
            case 12: {
                if (!this.plugin.getBuildKeeper().getRoomProgress().containsKey(player.getUniqueId())) {
                    this.close(player);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_ACTIVE");
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                if (this.map_data.containsKey(playerUUID)) {
                    this.switchLevel(view, slot, playerUUID);
                    TARDISARSMapData md = (TARDISARSMapData)this.map_data.get(playerUUID);
                    this.setMap(md.getY(), md.getE(), md.getS(), playerUUID, view);
                    this.setLore(view, slot, null);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
                break;
            }
            case 30: {
                if (this.selected_slot.containsKey(playerUUID)) {
                    if (this.checkSavedGrid(playerUUID, (Integer)this.selected_slot.get(playerUUID), 0)) {
                        this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_RESET_SLOT", "You cannot reset the selected slot!"));
                        break;
                    }
                    ItemStack stone = ItemStack.of((Material)Material.STONE, (int)1);
                    ItemMeta s1 = stone.getItemMeta();
                    s1.displayName((Component)Component.text((String)"Empty slot"));
                    stone.setItemMeta(s1);
                    this.setSlot(view, (Integer)this.selected_slot.get(playerUUID), stone, playerUUID, true);
                    this.setLore(view, slot, null);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_NO_SLOT", "No slot selected!"));
                break;
            }
            case 36: {
                int startl;
                int max = this.room_materials.size() - 9;
                if (this.scroll_start.containsKey(playerUUID)) {
                    startl = (Integer)this.scroll_start.get(playerUUID) + 1;
                    if (startl >= max) {
                        startl = max;
                    }
                } else {
                    startl = 1;
                }
                this.scroll_start.put(playerUUID, startl);
                for (int i = 0; i < 9; ++i) {
                    this.setSlot(view, 45 + i, this.room_materials.get(startl + i), this.room_names.get(startl + i), playerUUID, true);
                }
                break;
            }
            case 38: {
                int startr;
                if (this.scroll_start.containsKey(playerUUID)) {
                    startr = (Integer)this.scroll_start.get(playerUUID) - 1;
                    if (startr <= 0) {
                        startr = 0;
                    }
                } else {
                    startr = 0;
                }
                this.scroll_start.put(playerUUID, startr);
                for (int i = 0; i < 9; ++i) {
                    this.setSlot(view, 45 + i, this.room_materials.get(startr + i), this.room_names.get(startr + i), playerUUID, true);
                }
                break;
            }
            case 39: {
                if (this.selected_slot.containsKey(playerUUID)) {
                    ItemStack tnt = ItemStack.of((Material)Material.TNT, (int)1);
                    ItemMeta j = tnt.getItemMeta();
                    j.displayName((Component)Component.text((String)"Jettison"));
                    tnt.setItemMeta(j);
                    this.setSlot(view, (Integer)this.selected_slot.get(playerUUID), tnt, playerUUID, true);
                    this.setLore(view, slot, null);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_NO_SLOT", "No slot selected!"));
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                ItemStack ris;
                Room room;
                if (event.isShiftClick() && ARSSound.ROOM_SOUNDS.containsKey((Object)(room = Room.valueOf(TARDISARS.ARSFor((ris = view.getItem(slot)).getType().toString()).getConfigPath().toUpperCase(Locale.ROOT))))) {
                    player.playSound(player.getLocation(), ARSSound.ROOM_SOUNDS.get((Object)room), 1.0f, 1.0f);
                }
                if (this.selected_slot.containsKey(playerUUID)) {
                    if (this.checkSavedGrid(playerUUID, (Integer)this.selected_slot.get(playerUUID), 0)) {
                        this.setLore(view, slot, "Jettison existing room first!");
                        break;
                    }
                    ris = view.getItem(slot);
                    String displayName = ComponentUtils.stripColour(ris.getItemMeta().displayName());
                    String room2 = TARDISARS.ARSFor(ris.getType().toString()).getConfigPath();
                    if (!TARDISPermission.hasPermission(player, "tardis.room." + room2.toLowerCase(Locale.ROOT))) break;
                    if (room2.equals("GRAVITY") || room2.equals("ANTIGRAVITY")) {
                        int updown;
                        int n = updown = room2.equals("GRAVITY") ? -1 : 1;
                        if (this.checkSavedGrid(playerUUID, (Integer)this.selected_slot.get(playerUUID), updown)) {
                            this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_GRAVITY", "Using a gravity well here would overwrite an existing room!"));
                            break;
                        }
                    }
                    if (room2.equals("RENDERER") && this.hasRenderer(playerUUID)) {
                        this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_HAS_RENDERER", "You already have one of these!"));
                        break;
                    }
                    this.setSlot(view, (Integer)this.selected_slot.get(playerUUID), ris, playerUUID, true);
                    this.setSlot(view, slot, ris.getType(), displayName, playerUUID, false);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_NO_SLOT", "No slot selected!"));
                break;
            }
        }
    }

    private boolean checkSavedGrid(UUID playerUUID, int slot, int updown) {
        TARDISARSMapData md = (TARDISARSMapData)this.map_data.get(playerUUID);
        TARDISARSSaveData sd = (TARDISARSSaveData)this.save_map_data.get(playerUUID);
        String[][][] grid = sd.getData();
        int yy = md.getY() + updown;
        if (yy < 0 || yy > 2) {
            return false;
        }
        int[] coords = this.getCoords(slot, md);
        int xx = coords[0];
        int zz = coords[1];
        Material prior = Material.valueOf((String)grid[yy][xx][zz]);
        if (this.room_materials.stream().anyMatch(i -> prior == i)) {
            return true;
        }
        return this.consoleBlocks.contains(grid[yy][xx][zz]);
    }

    private void getRoomIdAndNames() {
        List<String> custom_names = this.getCustomRoomNames();
        TARDISARS[] ars = TARDISARS.values();
        this.room_materials = new ArrayList<Material>();
        this.room_names = new ArrayList<String>();
        for (TARDISARS a : ars) {
            if (a.getOffset() == 0) continue;
            this.room_materials.add(Material.valueOf((String)a.getMaterial()));
            this.room_names.add(a.getDescriptiveName());
        }
        custom_names.forEach(c -> {
            this.room_materials.add(Material.valueOf((String)this.plugin.getRoomsConfig().getString("rooms." + c + ".seed")));
            String uc = TARDISStringUtils.uppercaseFirst(c);
            this.room_names.add(uc);
            TARDISARS.addNewARS(new ARS(){
                final /* synthetic */ String val$c;
                final /* synthetic */ String val$uc;
                {
                    this.val$c = string;
                    this.val$uc = string2;
                }

                @Override
                public String getMaterial() {
                    return TARDISARSListener.this.plugin.getRoomsConfig().getString("rooms." + this.val$c + ".seed");
                }

                @Override
                public String getDescriptiveName() {
                    return this.val$uc;
                }

                @Override
                public String getConfigPath() {
                    return this.val$c;
                }

                @Override
                public int getOffset() {
                    return 1;
                }

                @Override
                public NamespacedKey getKey() {
                    return RoomVariant.SLOT.getKey();
                }
            });
        });
    }

    private List<String> getCustomRoomNames() {
        ArrayList<String> crooms = new ArrayList<String>();
        Set names = this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false);
        names.forEach(cr -> {
            if (this.plugin.getRoomsConfig().getBoolean("rooms." + cr + ".user") && this.plugin.getRoomsConfig().getBoolean("rooms." + cr + ".enabled")) {
                crooms.add((String)cr);
            }
        });
        return crooms;
    }
}

