/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.utils;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class MonstersConfig {
    private final TARDIS plugin;
    private final HashMap<String, List<String>> listOptions = new HashMap();
    private final HashMap<String, String> strOptions = new HashMap();
    private final HashMap<String, Integer> intOptions = new HashMap();
    private final HashMap<String, Double> doubleOptions = new HashMap();
    private final HashMap<String, Boolean> boolOptions = new HashMap();
    private final FileConfiguration config;

    public MonstersConfig(TARDIS plugin) {
        this.plugin = plugin;
        File monstersFile = new File(plugin.getDataFolder(), "monsters.yml");
        this.config = YamlConfiguration.loadConfiguration((File)monstersFile);
        this.intOptions.put("angels.freeze_time", 100);
        this.intOptions.put("daleks.dalek_sec_chance", 5);
        this.intOptions.put("daleks.davros_chance", 5);
        this.intOptions.put("spawn_rate.how_many", 2);
        this.intOptions.put("spawn_rate.how_often", 400);
        this.intOptions.put("spawn_rate.default_max", 0);
        this.intOptions.put("angels.spawn_from_chat.chance", 50);
        this.intOptions.put("angels.spawn_from_chat.distance_from_player", 10);
        this.intOptions.put("judoon.ammunition", 25);
        this.intOptions.put("judoon.damage", 4);
        this.intOptions.put("ood.spawn_from_villager", 20);
        this.intOptions.put("ood.spawn_from_cured", 5);
        this.intOptions.put("toclafane.spawn_from_bee", 5);
        this.strOptions.put("angels.weapon", "DIAMOND_PICKAXE");
        this.strOptions.put("headless_monks.projectile", "SMALL_FIREBALL");
        this.listOptions.put("angel_of_liberty.drops", List.of("TORCH", "OXIDIZED_COPPER"));
        this.listOptions.put("angels.drops", List.of("STONE", "COBBLESTONE"));
        this.listOptions.put("angels.teleport_worlds", List.of("world"));
        this.listOptions.put("cybermen.drops", List.of("REDSTONE", "STONE_BUTTON"));
        this.listOptions.put("daleks.dalek_sec_drops", List.of("VERDANT_FROGLIGHT", "LEATHER_CHESTPLATE"));
        this.listOptions.put("daleks.davros_drops", List.of("IRON_CHAIN", "CRIMSON_BUTTON"));
        this.listOptions.put("daleks.drops", List.of("SLIME_BALL", "ROTTEN_FLESH"));
        this.listOptions.put("empty_child.drops", List.of("COOKED_BEEF", "SUGAR"));
        this.listOptions.put("hath.drops", List.of("SALMON", "STONE_PICKAXE"));
        this.listOptions.put("headless_monks.drops", List.of("BOOK", "RED_CANDLE"));
        this.listOptions.put("heavenly_hosts.drops", List.of("GOLD_NUGGET", "PAPER"));
        this.listOptions.put("ice_warriors.drops", List.of("ICE", "PACKED_ICE", "SNOW_BLOCK"));
        this.listOptions.put("nimon.drops", List.of("BEEF", "POLISHED_BLACKSTONE"));
        this.listOptions.put("omega.drops", List.of("GOLD_INGOT", "CLOCK"));
        this.listOptions.put("ood.drops", List.of("NAME_TAG"));
        this.listOptions.put("ossified.drops", List.of("CHARCOAL", "FIREWORK_STAR", "DEAD_BRAIN_CORAL"));
        this.listOptions.put("racnoss.drops", List.of("NETHERITE_INGOT", "ECHO_SHARD"));
        this.listOptions.put("sea_devils.drops", List.of("COD", "KELP"));
        this.listOptions.put("silent.drops", List.of("INK_SAC", "FLOWER_POT"));
        this.listOptions.put("silurians.drops", List.of("GOLD_NUGGET", "FEATHER"));
        this.listOptions.put("slitheen.drops", List.of("RABBIT_HIDE", "PHANTOM_MEMBRANE"));
        this.listOptions.put("smilers.drops", List.of("COMPARATOR", "CHERRY_LOG"));
        this.listOptions.put("sontarans.drops", List.of("POTATO", "POISONOUS_POTATO"));
        this.listOptions.put("sutekh.drops", List.of("GLOWSTONE_DUST", "LIGHTNING_ROD"));
        this.listOptions.put("the_beast.drops", List.of("MAGMA_BLOCK", "IRON_CHAIN"));
        this.listOptions.put("the_mire.drops", List.of("HONEY_BOTTLE", "POTION"));
        this.listOptions.put("toclafane.drops", List.of("GUNPOWDER", "HONEYCOMB"));
        this.listOptions.put("vampires.drops", List.of("TROPICAL_FISH", "FISHING_ROD"));
        this.listOptions.put("vashta_nerada.drops", List.of("BONE", "LEATHER"));
        this.listOptions.put("zygons.drops", List.of("PAINTING", "SAND"));
        this.boolOptions.put("angels.angels_can_steal", true);
        this.boolOptions.put("angels.teleport_to_location", false);
        this.boolOptions.put("angels.can_build", true);
        this.boolOptions.put("angels.spawn_from_chat.enabled", true);
        this.boolOptions.put("cybermen.can_upgrade", true);
        this.boolOptions.put("headless_monks.particles", true);
        this.boolOptions.put("silurians.check_slime_chunk", false);
        this.boolOptions.put("sontarans.can_tame", true);
        this.boolOptions.put("judoon.guards", true);
        this.boolOptions.put("judoon.can_build", true);
        this.boolOptions.put("k9.can_build", true);
        this.boolOptions.put("k9.by_taming", true);
        this.boolOptions.put("toclafane.destroy_blocks", true);
        this.boolOptions.put("custom_spawners", true);
        double min_version = 2.0;
        this.doubleOptions.put("config_version", min_version);
    }

    public void updateConfig() {
        List list;
        List drops;
        int i = 0;
        for (Map.Entry<String, Integer> entry : this.intOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getMonstersConfig().set(entry.getKey(), (Object)entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Object> entry : this.strOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getMonstersConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Object> entry : this.listOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getMonstersConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Object> entry : this.boolOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getMonstersConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        for (Map.Entry<String, Object> entry : this.doubleOptions.entrySet()) {
            if (this.config.contains(entry.getKey())) continue;
            this.plugin.getMonstersConfig().set(entry.getKey(), entry.getValue());
            ++i;
        }
        if (!this.config.contains("angels.teleport_locations")) {
            Location location = ((World)this.plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
            String string = location.getWorld().getName() + "," + location.getBlockX() + "," + location.getBlockY() + "," + location.getBlockZ();
            List<CallSite> list2 = List.of(string);
            this.plugin.getMonstersConfig().set("angels.teleport_locations", list2);
            ++i;
        }
        if (!(drops = this.config.getStringList("daleks.davros_drops")).isEmpty() && drops.contains("CHAIN")) {
            drops.remove("CHAIN");
            drops.add("IRON_CHAIN");
            this.plugin.getMonstersConfig().set("daleks.davros_drops", (Object)drops);
            ++i;
        }
        if (!(list = this.config.getStringList("the_beast.drops")).isEmpty() && list.contains("CHAIN")) {
            list.remove("CHAIN");
            list.add("COPPER_CHAIN");
            this.plugin.getMonstersConfig().set("the_beast.drops", (Object)list);
            ++i;
        }
        if (i > 0) {
            try {
                String monstersPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "monsters.yml";
                this.plugin.getMonstersConfig().save(new File(monstersPath));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.MONSTERS, "Added " + i + " new items to monsters.yml");
            }
            catch (IOException io) {
                this.plugin.debug("Could not save monsters.yml, " + io.getMessage());
            }
        }
    }
}

