/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.command;

import java.util.ArrayList;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisvortexmanipulator.TVMUtils;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMQueryFactory;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TVMCommandBeacon {
    private final TARDIS plugin;

    public TVMCommandBeacon(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean process(Player player) {
        if (!TARDISPermission.hasPermission(player, "vm.beacon")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_PERM_CMD");
            return true;
        }
        int required = this.plugin.getVortexConfig().getInt("tachyon_use.lifesigns");
        if (!TVMUtils.checkTachyonLevel(player.getUniqueId().toString(), required)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_BEACON_TACHYON");
            return true;
        }
        UUID uuid = player.getUniqueId();
        String ustr = uuid.toString();
        Location l = player.getLocation();
        ArrayList<Flag> flags = new ArrayList<Flag>();
        if (this.plugin.getConfig().getBoolean("preferences.respect_griefprevention")) {
            flags.add(Flag.RESPECT_GRIEFPREVENTION);
        }
        if (this.plugin.getConfig().getBoolean("preferences.respect_towny")) {
            flags.add(Flag.RESPECT_TOWNY);
        }
        if (this.plugin.getConfig().getBoolean("preferences.respect_worldborder")) {
            flags.add(Flag.RESPECT_WORLDBORDER);
        }
        if (this.plugin.getConfig().getBoolean("preferences.respect_worldguard")) {
            flags.add(Flag.RESPECT_WORLDGUARD);
        }
        Parameters params = new Parameters(player, flags);
        if (!this.plugin.getTardisAPI().getRespect().getRespect(l, params)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_BEACON_PERMIT");
            return true;
        }
        Block b = l.getBlock().getRelative(BlockFace.DOWN);
        TVMQueryFactory qf = new TVMQueryFactory(this.plugin);
        qf.saveBeaconBlock(ustr, b);
        b.setBlockData(Material.BEACON.createBlockData());
        Block down = b.getRelative(BlockFace.DOWN);
        qf.saveBeaconBlock(ustr, down);
        BlockData iron = Material.IRON_BLOCK.createBlockData();
        down.setBlockData(iron);
        this.plugin.getGeneralKeeper().getSurrounding().forEach(f -> {
            qf.saveBeaconBlock(ustr, down.getRelative(f));
            down.getRelative(f).setBlockData(iron);
        });
        this.plugin.getTvmSettings().getBeaconSetters().add(uuid);
        qf.alterTachyons(ustr, -required);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.VORTEX_MANIPULATOR, "VM_BEACON_MOVE");
        return true;
    }
}

