/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.siegemode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.event.TARDISSiegeEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISSiegeOffEvent;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.UseClay;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegeArea;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegeWallFloorRunnable;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enemy;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class TARDISSiegeMode {
    private final TARDIS plugin;

    public TARDISSiegeMode(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void toggleViaSwitch(int id, Player p) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            return;
        }
        Current current = rsc.getCurrent();
        Block siege = current.location().getBlock();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("tardis_id", id);
        HashMap<String, Object> set = new HashMap<String, Object>();
        if (tardis.isSiegeOn()) {
            int min = this.plugin.getArtronConfig().getInt("full_charge") / 100 * this.plugin.getArtronConfig().getInt("siege_transfer");
            if (min > tardis.getArtronLevel()) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_POWER");
                return;
            }
            this.plugin.getPM().callEvent((Event)new TARDISSiegeOffEvent(p, tardis));
            siege.setBlockData(TARDISConstants.AIR);
            TARDISDisplayItemUtils.remove(siege);
            BuildData bd = new BuildData(p.getUniqueId().toString());
            bd.setDirection(current.direction());
            bd.setLocation(current.location());
            bd.setMalfunction(false);
            bd.setOutside(false);
            bd.setPlayer((OfflinePlayer)p);
            bd.setRebuild(true);
            bd.setSubmarine(current.submarine());
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getPresetBuilder().buildPreset(bd), 10L);
            set.put("siege_on", 0);
            this.plugin.getTrackerKeeper().getInSiegeMode().remove(id);
            if (this.plugin.getConfig().getInt("siege.breeding") > 0 || this.plugin.getConfig().getInt("siege.growth") > 0) {
                String[] chu = tardis.getChunk().split(":");
                if (this.plugin.getConfig().getInt("siege.breeding") > 0) {
                    ArrayList breeding = new ArrayList();
                    this.plugin.getTrackerKeeper().getSiegeBreedingAreas().get(chu[0]).forEach(breeding_area -> {
                        if (breeding_area.getId() != id) {
                            breeding.add(breeding_area);
                        }
                    });
                    if (!breeding.isEmpty()) {
                        this.plugin.getTrackerKeeper().getSiegeBreedingAreas().put(chu[0], breeding);
                    } else {
                        this.plugin.getTrackerKeeper().getSiegeBreedingAreas().remove(chu[0]);
                    }
                }
                if (this.plugin.getConfig().getInt("siege.growth") > 0) {
                    ArrayList growth = new ArrayList();
                    List<TARDISSiegeArea> siegeAreas = this.plugin.getTrackerKeeper().getSiegeGrowthAreas().get(chu[0]);
                    if (siegeAreas != null) {
                        siegeAreas.forEach(growth_area -> {
                            if (growth_area.getId() != id) {
                                growth.add(growth_area);
                            }
                        });
                    }
                    if (!growth.isEmpty()) {
                        this.plugin.getTrackerKeeper().getSiegeGrowthAreas().put(chu[0], growth);
                    } else {
                        this.plugin.getTrackerKeeper().getSiegeGrowthAreas().remove(chu[0]);
                    }
                }
            }
            if (this.plugin.getConfig().getBoolean("siege.texture")) {
                this.changeTextures(tardis.getUuid().toString(), tardis.getSchematic(), p, false);
            }
            this.plugin.getMessenger().sendStatus(p, "SIEGE_OFF");
        } else {
            if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id) || this.plugin.getTrackerKeeper().getInVortex().contains(id)) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                return;
            }
            DestroyData dd = new DestroyData();
            dd.setDirection(current.direction());
            dd.setLocation(current.location());
            dd.setPlayer((OfflinePlayer)p.getPlayer());
            dd.setHide(false);
            dd.setOutside(false);
            dd.setSiege(true);
            dd.setSubmarine(current.submarine());
            dd.setTardisID(id);
            dd.setThrottle(SpaceTimeThrottle.REBUILD);
            this.plugin.getPresetDestroyer().destroyPreset(dd);
            this.plugin.getTrackerKeeper().getInSiegeMode().add(id);
            set.put("siege_on", 1);
            this.plugin.getMessenger().sendStatus(p, "SIEGE_ON");
            this.plugin.getPM().callEvent((Event)new TARDISSiegeEvent(p, tardis));
            if (this.plugin.getConfig().getBoolean("siege.butcher")) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SIEGE_BUTCHER");
                for (Entity ent : p.getNearbyEntities(72.0, 32.0, 72.0)) {
                    if (!(ent instanceof Enemy)) continue;
                    if (ent instanceof Creeper) {
                        Location cl = ent.getLocation();
                        Location dbl = TARDISStaticLocationGetters.getLocationFromDB(tardis.getCreeper());
                        if (cl.getBlockX() == dbl.getBlockX() && cl.getBlockY() == dbl.getBlockY() && cl.getBlockZ() == dbl.getBlockZ()) continue;
                    }
                    ent.remove();
                }
            }
            if (this.plugin.getConfig().getInt("siege.breeding") > 0 || this.plugin.getConfig().getInt("siege.growth") > 0) {
                Chunk c = this.plugin.getLocationUtils().getTARDISChunk(id);
                TARDISSiegeArea tsa = new TARDISSiegeArea(id, c);
                if (this.plugin.getConfig().getInt("siege.breeding") > 0) {
                    List<TARDISSiegeArea> breeding_areas = this.plugin.getTrackerKeeper().getSiegeBreedingAreas().get(c.getWorld().getName());
                    if (breeding_areas == null) {
                        breeding_areas = new ArrayList<TARDISSiegeArea>();
                    }
                    breeding_areas.add(tsa);
                    this.plugin.getTrackerKeeper().getSiegeBreedingAreas().put(c.getWorld().getName(), breeding_areas);
                }
                if (this.plugin.getConfig().getInt("siege.growth") > 0) {
                    List<TARDISSiegeArea> growth_areas = this.plugin.getTrackerKeeper().getSiegeGrowthAreas().get(c.getWorld().getName());
                    if (growth_areas == null) {
                        growth_areas = new ArrayList<TARDISSiegeArea>();
                    }
                    growth_areas.add(tsa);
                    this.plugin.getTrackerKeeper().getSiegeGrowthAreas().put(c.getWorld().getName(), growth_areas);
                }
            }
            if (this.plugin.getConfig().getBoolean("siege.texture")) {
                this.changeTextures(tardis.getUuid().toString(), tardis.getSchematic(), p, true);
            }
            this.plugin.getTrackerKeeper().getActiveForceFields().remove(p.getUniqueId());
        }
        this.plugin.getQueryFactory().doUpdate("tardis", set, wheres);
    }

    void changeTextures(String uuid, Schematic schm, Player p, boolean toSiege) {
        ResultSetPlayerPrefs rspp = new ResultSetPlayerPrefs(this.plugin, uuid);
        if (rspp.resultSet()) {
            UseClay use_clay;
            String wall = rspp.getWall();
            String floor = rspp.getFloor();
            String sw = rspp.getSiegeWall();
            String sf = rspp.getSiegeFloor();
            try {
                use_clay = UseClay.valueOf(this.plugin.getConfig().getString("creation.use_clay"));
            }
            catch (IllegalArgumentException e) {
                use_clay = UseClay.WOOL;
            }
            if (!use_clay.equals((Object)UseClay.WOOL) && (sw.equals("GRAY_CLAY") || sw.equals("GREY_CONCRETE"))) {
                sw = "GRAY_WOOL";
            }
            if (!use_clay.equals((Object)UseClay.WOOL) && (sf.equals("BLACK_CLAY") || sw.equals("BLACK_CONCRETE"))) {
                sf = "BLACK_WOOL";
            }
            TARDISUpgradeData tud = new TARDISUpgradeData();
            tud.setWall(wall);
            tud.setFloor(floor);
            tud.setSiegeWall(sw);
            tud.setSiegeFloor(sf);
            tud.setSchematic(schm);
            tud.setPrevious(schm);
            TARDISSiegeWallFloorRunnable ttr = new TARDISSiegeWallFloorRunnable(this.plugin, p.getUniqueId(), tud, toSiege);
            long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)ttr, 5L, delay);
            ttr.setTaskID(task);
        }
    }
}

