/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.eye;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.particles.Sphere;
import me.eccentric_nz.TARDIS.rooms.eye.Capacitor;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public class EyeStarter {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private Statement statement = null;
    private PreparedStatement ps = null;

    public EyeStarter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goSuperNova() {
        ResultSet rs = null;
        try {
            String update = "UPDATE " + this.prefix + "eyes SET task = ? WHERE tardis_id = ?";
            this.ps = this.connection.prepareStatement(update);
            String query = "SELECT " + this.prefix + "controls.location, " + this.prefix + "eyes.capacitors, " + this.prefix + "tardis.uuid, " + this.prefix + "tardis.tardis_id FROM " + this.prefix + "controls, " + this.prefix + "eyes, " + this.prefix + "tardis WHERE " + this.prefix + "controls.type = 53 AND " + this.prefix + "controls.tardis_id = " + this.prefix + "eyes.tardis_id AND " + this.prefix + "eyes.tardis_id = " + this.prefix + "tardis.tardis_id";
            this.statement = this.connection.createStatement();
            rs = this.statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                this.connection.setAutoCommit(false);
                int count = 0;
                while (rs.next()) {
                    int capacitors = rs.getInt("capacitors");
                    if (capacitors <= 0) continue;
                    Location s = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getString("location"));
                    Capacitor capacitor = Capacitor.values()[rs.getInt("capacitors") - 1];
                    Sphere sphere = new Sphere(this.plugin, UUID.fromString(rs.getString("uuid")), s, capacitor);
                    int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)sphere, 0L, 10L);
                    sphere.setTaskID(task);
                    this.ps.setInt(1, task);
                    this.ps.setInt(2, rs.getInt("tardis_id"));
                    this.ps.addBatch();
                    ++count;
                }
                if (count > 0) {
                    this.ps.executeBatch();
                }
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Error loading eye of harmony stars: " + ex.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (this.statement != null) {
                    this.statement.close();
                }
                if (this.ps != null) {
                    this.ps.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing eye of harmony stars: " + ex.getMessage());
            }
        }
    }
}

