/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.messaging;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISRoomLister {
    private final TARDIS plugin;
    private final Player player;
    private final LinkedHashMap<String, List<String>> options;

    public TARDISRoomLister(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.options = this.createRoomOptions();
    }

    public void list() {
        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_INFO", String.format("%d", this.plugin.getGeneralKeeper().getRoomArgs().size()));
        this.plugin.getMessenger().messageWithColour((CommandSender)this.player, "Click a room name to suggest a command", "#AAAAAA");
        this.plugin.getMessenger().message((CommandSender)this.player, "");
        this.options.forEach((key, value) -> {
            this.player.sendMessage(key);
            if (!value.isEmpty()) {
                value.forEach(s -> this.plugin.getMessenger().sendRoom((CommandSender)this.player, (String)s, TARDISPermission.hasPermission(this.player, "tardis.room." + s.toLowerCase(Locale.ROOT))));
            } else {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_NONE");
            }
        });
        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "ROOM_GALLERY");
        this.plugin.getMessenger().sendRoomGallery((CommandSender)this.player);
    }

    private LinkedHashMap<String, List<String>> createRoomOptions() {
        LinkedHashMap<String, List<String>> room_options = new LinkedHashMap<String, List<String>>();
        ArrayList default_rooms = new ArrayList();
        ArrayList custom_rooms = new ArrayList();
        this.plugin.getRoomsConfig().getConfigurationSection("rooms").getKeys(false).forEach(room -> {
            if (this.plugin.getRoomsConfig().getBoolean("rooms." + room + ".enabled")) {
                if (this.plugin.getRoomsConfig().getBoolean("rooms." + room + ".user")) {
                    custom_rooms.add(room);
                } else {
                    default_rooms.add(room);
                }
            }
        });
        room_options.put("Default Rooms", default_rooms);
        room_options.put("Custom Rooms", custom_rooms);
        return room_options;
    }
}

